/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render.tile;

import com.github.alexthe666.alexsmobs.block.BlockEndPirateShipWheel;
import com.github.alexthe666.alexsmobs.client.model.ModelEndPirateShipWheel;
import com.github.alexthe666.alexsmobs.client.render.AMRenderTypes;
import com.github.alexthe666.alexsmobs.tileentity.TileEntityEndPirateShipWheel;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.Property;

public class RenderEndPirateShipWheel<T extends TileEntityEndPirateShipWheel>
implements BlockEntityRenderer<T> {
    private static final ResourceLocation TEXTURE = ResourceLocation.parse((String)"alexsmobs:textures/entity/end_pirate/ship_wheel.png");
    private static final ResourceLocation TEXTURE_GLOW = ResourceLocation.parse((String)"alexsmobs:textures/entity/end_pirate/ship_wheel_glow.png");
    private static final ModelEndPirateShipWheel WHEEL_MODEL = new ModelEndPirateShipWheel();

    public RenderEndPirateShipWheel(BlockEntityRendererProvider.Context rendererDispatcherIn) {
    }

    public void render(T tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        matrixStackIn.pushPose();
        Direction dir = (Direction)tileEntityIn.getBlockState().getValue((Property)BlockEndPirateShipWheel.FACING);
        switch (dir) {
            case UP: {
                matrixStackIn.translate(0.5f, 1.5f, 0.5f);
                break;
            }
            case DOWN: {
                matrixStackIn.translate(0.5f, -0.5f, 0.5f);
                break;
            }
            case NORTH: {
                matrixStackIn.translate(0.5, 0.5, -0.5);
                break;
            }
            case EAST: {
                matrixStackIn.translate(1.5f, 0.5f, 0.5f);
                break;
            }
            case SOUTH: {
                matrixStackIn.translate(0.5, 0.5, 1.5);
                break;
            }
            case WEST: {
                matrixStackIn.translate(-0.5f, 0.5f, 0.5f);
            }
        }
        matrixStackIn.mulPose(dir.getOpposite().getRotation());
        matrixStackIn.pushPose();
        WHEEL_MODEL.renderWheel((TileEntityEndPirateShipWheel)((Object)tileEntityIn), partialTicks);
        WHEEL_MODEL.renderToBuffer(matrixStackIn, bufferIn.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)TEXTURE)), combinedLightIn, combinedOverlayIn);
        WHEEL_MODEL.renderToBuffer(matrixStackIn, bufferIn.getBuffer(AMRenderTypes.entityCutoutNoCull((ResourceLocation)TEXTURE_GLOW)), 240, combinedOverlayIn);
        matrixStackIn.popPose();
        matrixStackIn.popPose();
    }
}

