/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render.tile;

import com.github.alexthe666.alexsmobs.block.BlockEndPirateDoor;
import com.github.alexthe666.alexsmobs.client.model.ModelEndPirateDoor;
import com.github.alexthe666.alexsmobs.tileentity.TileEntityEndPirateDoor;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.Property;

public class RenderEndPirateDoor<T extends TileEntityEndPirateDoor>
implements BlockEntityRenderer<T> {
    private static final ResourceLocation TEXTURE = ResourceLocation.parse((String)"alexsmobs:textures/entity/end_pirate/door.png");
    private static final ModelEndPirateDoor DOOR_MODEL = new ModelEndPirateDoor();

    public RenderEndPirateDoor(BlockEntityRendererProvider.Context rendererDispatcherIn) {
    }

    public void render(T tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        matrixStackIn.pushPose();
        Direction dir = (Direction)tileEntityIn.getBlockState().getValue((Property)BlockEndPirateDoor.HORIZONTAL_FACING);
        switch (dir) {
            case NORTH: {
                matrixStackIn.translate(0.5, 0.5, -0.5);
                break;
            }
            case EAST: {
                matrixStackIn.translate(1.5f, 0.5f, 0.5f);
                break;
            }
            case SOUTH: {
                matrixStackIn.translate(0.5, 0.5, 1.5);
                break;
            }
            case WEST: {
                matrixStackIn.translate(-0.5f, 0.5f, 0.5f);
            }
        }
        matrixStackIn.mulPose(dir.getOpposite().getRotation());
        matrixStackIn.pushPose();
        matrixStackIn.translate(0.0f, 1.0f, -1.0f);
        matrixStackIn.mulPose(Axis.XP.rotationDegrees(90.0f));
        matrixStackIn.scale(0.999f, 0.999f, 0.999f);
        DOOR_MODEL.renderDoor((TileEntityEndPirateDoor)((Object)tileEntityIn), partialTicks, tileEntityIn.getBlockState().getValue(BlockEndPirateDoor.HINGE) == DoorHingeSide.LEFT);
        DOOR_MODEL.renderToBuffer(matrixStackIn, bufferIn.getBuffer(RenderType.entityTranslucent((ResourceLocation)TEXTURE)), combinedLightIn, combinedOverlayIn);
        matrixStackIn.popPose();
        matrixStackIn.popPose();
    }

    public int getViewDistance() {
        return 128;
    }
}

