/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render.layer;

import com.github.alexthe666.alexsmobs.client.model.ModelTiger;
import com.github.alexthe666.alexsmobs.client.render.RenderTiger;
import com.github.alexthe666.alexsmobs.entity.EntityTiger;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.LightLayer;

public class LayerTigerEyes
extends RenderLayer<EntityTiger, ModelTiger> {
    private static final ResourceLocation TEXTURE = ResourceLocation.parse((String)"alexsmobs:textures/entity/tiger/tiger_eyes.png");
    private static final ResourceLocation TEXTURE_WHITE = ResourceLocation.parse((String)"alexsmobs:textures/entity/tiger/tiger_white_eyes.png");
    private static final ResourceLocation TEXTURE_ANGRY = ResourceLocation.parse((String)"alexsmobs:textures/entity/tiger/tiger_angry_eyes.png");

    public LayerTigerEyes(RenderTiger render) {
        super((RenderLayerParent)render);
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, EntityTiger tiger, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!tiger.isSleeping()) {
            long roundedTime = tiger.level().getDayTime() % 24000L;
            boolean night = roundedTime >= 13000L && roundedTime <= 22000L;
            BlockPos ratPos = tiger.getLightPosition();
            int i = tiger.level().getBrightness(LightLayer.SKY, ratPos);
            int j = tiger.level().getBrightness(LightLayer.BLOCK, ratPos);
            int brightness = night ? j : Math.max(i, j);
            if (brightness < 7 || tiger.getRemainingPersistentAngerTime() > 0) {
                VertexConsumer ivertexbuilder = bufferIn.getBuffer(RenderType.eyes((ResourceLocation)(tiger.getRemainingPersistentAngerTime() > 0 ? TEXTURE_ANGRY : (tiger.isWhite() ? TEXTURE_WHITE : TEXTURE))));
                ((ModelTiger)this.getParentModel()).renderToBuffer(matrixStackIn, ivertexbuilder, packedLightIn, LivingEntityRenderer.getOverlayCoords((LivingEntity)tiger, (float)0.0f), -1);
            }
        }
    }
}

