/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render.layer;

import com.github.alexthe666.alexsmobs.client.model.ModelCockroach;
import com.github.alexthe666.alexsmobs.client.model.layered.AMModelLayers;
import com.github.alexthe666.alexsmobs.client.model.layered.ModelSombrero;
import com.github.alexthe666.alexsmobs.client.render.RenderCockroach;
import com.github.alexthe666.alexsmobs.entity.EntityCockroach;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class LayerCockroachMaracas
extends RenderLayer<EntityCockroach, ModelCockroach> {
    private final ItemStack stack = new ItemStack((ItemLike)AMItemRegistry.MARACA.get());
    private final ModelSombrero sombrero;
    private static final ResourceLocation SOMBRERO_TEX = ResourceLocation.parse((String)"alexsmobs:textures/armor/sombrero.png");

    public LayerCockroachMaracas(RenderCockroach render, EntityRendererProvider.Context renderManagerIn) {
        super((RenderLayerParent)render);
        this.sombrero = new ModelSombrero(renderManagerIn.bakeLayer(AMModelLayers.SOMBRERO));
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, EntityCockroach entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entitylivingbaseIn.hasMaracas()) {
            ItemInHandRenderer renderer = Minecraft.getInstance().getEntityRenderDispatcher().getItemInHandRenderer();
            matrixStackIn.pushPose();
            if (entitylivingbaseIn.isBaby()) {
                matrixStackIn.scale(0.65f, 0.65f, 0.65f);
                matrixStackIn.translate(0.0, 0.815, 0.125);
            }
            matrixStackIn.pushPose();
            this.translateToHand(0, matrixStackIn);
            matrixStackIn.translate(-0.25f, 0.0f, 0.0f);
            matrixStackIn.scale(1.4f, 1.4f, 1.4f);
            matrixStackIn.mulPose(Axis.XP.rotationDegrees(-90.0f));
            matrixStackIn.mulPose(Axis.ZP.rotationDegrees(60.0f));
            renderer.renderItem((LivingEntity)entitylivingbaseIn, this.stack, ItemDisplayContext.GROUND, false, matrixStackIn, bufferIn, packedLightIn);
            matrixStackIn.popPose();
            matrixStackIn.pushPose();
            this.translateToHand(1, matrixStackIn);
            matrixStackIn.translate(0.25f, 0.0f, 0.0f);
            matrixStackIn.scale(1.4f, 1.4f, 1.4f);
            matrixStackIn.mulPose(Axis.XP.rotationDegrees(90.0f));
            matrixStackIn.mulPose(Axis.ZP.rotationDegrees(-120.0f));
            renderer.renderItem((LivingEntity)entitylivingbaseIn, this.stack, ItemDisplayContext.GROUND, false, matrixStackIn, bufferIn, packedLightIn);
            matrixStackIn.popPose();
            matrixStackIn.pushPose();
            this.translateToHand(2, matrixStackIn);
            matrixStackIn.translate(-0.35f, 0.0f, 0.0f);
            matrixStackIn.scale(1.4f, 1.4f, 1.4f);
            matrixStackIn.mulPose(Axis.XP.rotationDegrees(-90.0f));
            matrixStackIn.mulPose(Axis.ZP.rotationDegrees(60.0f));
            renderer.renderItem((LivingEntity)entitylivingbaseIn, this.stack, ItemDisplayContext.GROUND, false, matrixStackIn, bufferIn, packedLightIn);
            matrixStackIn.popPose();
            matrixStackIn.pushPose();
            this.translateToHand(3, matrixStackIn);
            matrixStackIn.translate(0.35f, 0.0f, 0.0f);
            matrixStackIn.scale(1.4f, 1.4f, 1.4f);
            matrixStackIn.mulPose(Axis.XP.rotationDegrees(90.0f));
            matrixStackIn.mulPose(Axis.ZP.rotationDegrees(-120.0f));
            renderer.renderItem((LivingEntity)entitylivingbaseIn, this.stack, ItemDisplayContext.GROUND, false, matrixStackIn, bufferIn, packedLightIn);
            matrixStackIn.popPose();
            if (!entitylivingbaseIn.isHeadless()) {
                matrixStackIn.pushPose();
                this.translateToHand(4, matrixStackIn);
                matrixStackIn.translate(0.0f, -0.4f, -0.01f);
                matrixStackIn.translate(0.0f, entitylivingbaseIn.danceProgress * 0.045f, entitylivingbaseIn.danceProgress * -0.09f);
                matrixStackIn.scale(0.8f, 0.8f, 0.8f);
                matrixStackIn.mulPose(Axis.XP.rotationDegrees(60.0f * entitylivingbaseIn.danceProgress * 0.2f));
                VertexConsumer ivertexbuilder = bufferIn.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)SOMBRERO_TEX));
                this.sombrero.renderToBuffer(matrixStackIn, ivertexbuilder, packedLightIn, LivingEntityRenderer.getOverlayCoords((LivingEntity)entitylivingbaseIn, (float)0.0f), -1);
                matrixStackIn.popPose();
            }
            matrixStackIn.popPose();
        }
    }

    protected void translateToHand(int hand, PoseStack matrixStack) {
        ((ModelCockroach)this.getParentModel()).root.translateAndRotate(matrixStack);
        ((ModelCockroach)this.getParentModel()).abdomen.translateAndRotate(matrixStack);
        if (hand == 0) {
            ((ModelCockroach)this.getParentModel()).right_leg_front.translateAndRotate(matrixStack);
        } else if (hand == 1) {
            ((ModelCockroach)this.getParentModel()).left_leg_front.translateAndRotate(matrixStack);
        } else if (hand == 2) {
            ((ModelCockroach)this.getParentModel()).right_leg_mid.translateAndRotate(matrixStack);
        } else if (hand == 3) {
            ((ModelCockroach)this.getParentModel()).left_leg_mid.translateAndRotate(matrixStack);
        } else {
            ((ModelCockroach)this.getParentModel()).neck.translateAndRotate(matrixStack);
            ((ModelCockroach)this.getParentModel()).head.translateAndRotate(matrixStack);
        }
    }
}

