/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render.layer;

import com.github.alexthe666.alexsmobs.client.model.ModelAncientDart;
import com.github.alexthe666.alexsmobs.client.model.ModelCapuchinMonkey;
import com.github.alexthe666.alexsmobs.client.render.RenderCapuchinMonkey;
import com.github.alexthe666.alexsmobs.entity.EntityCapuchinMonkey;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class LayerCapuchinItem
extends RenderLayer<EntityCapuchinMonkey, ModelCapuchinMonkey> {
    public static final ResourceLocation DART_TEXTURE = ResourceLocation.parse((String)"alexsmobs:textures/entity/ancient_dart.png");
    public static final ModelAncientDart DART_MODEL = new ModelAncientDart();

    public LayerCapuchinItem(RenderCapuchinMonkey render) {
        super((RenderLayerParent)render);
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, EntityCapuchinMonkey entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entitylivingbaseIn.hasDart()) {
            matrixStackIn.pushPose();
            if (entitylivingbaseIn.isBaby()) {
                matrixStackIn.scale(0.35f, 0.35f, 0.35f);
                matrixStackIn.translate(0.5, 2.6, 0.15);
                this.translateToHand(false, matrixStackIn);
                matrixStackIn.translate(-0.65, -0.75, (double)-0.1f);
                matrixStackIn.scale(2.8f, 2.8f, 2.8f);
            } else {
                this.translateToHand(false, matrixStackIn);
            }
            float f = 0.0f;
            if (entitylivingbaseIn.getAnimation() == EntityCapuchinMonkey.ANIMATION_THROW) {
                f = entitylivingbaseIn.getAnimationTick() < 6 ? Math.min(3.0f, (float)entitylivingbaseIn.getAnimationTick() + partialTicks) * 60.0f : (12.0f - ((float)entitylivingbaseIn.getAnimationTick() + partialTicks)) * 30.0f;
            }
            matrixStackIn.translate(0.0f, 0.5f, 0.0f);
            matrixStackIn.scale(1.2f, 1.2f, 1.2f);
            matrixStackIn.pushPose();
            matrixStackIn.mulPose(Axis.XP.rotationDegrees(f));
            VertexConsumer ivertexbuilder = bufferIn.getBuffer(DART_MODEL.renderType(DART_TEXTURE));
            DART_MODEL.renderToBuffer(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, -1);
            matrixStackIn.popPose();
            matrixStackIn.popPose();
        } else if (entitylivingbaseIn.getAnimation() == EntityCapuchinMonkey.ANIMATION_THROW && entitylivingbaseIn.getAnimationTick() <= 5) {
            ItemStack itemstack = new ItemStack((ItemLike)Items.COBBLESTONE);
            matrixStackIn.pushPose();
            if (entitylivingbaseIn.isBaby()) {
                matrixStackIn.scale(0.35f, 0.35f, 0.35f);
                matrixStackIn.translate(0.5, 2.6, 0.15);
                this.translateToHand(false, matrixStackIn);
                matrixStackIn.translate(-0.4f, 0.75f, -0.0f);
                matrixStackIn.scale(2.8f, 2.8f, 2.8f);
            } else {
                this.translateToHand(false, matrixStackIn);
                matrixStackIn.translate(0.125f, 0.5f, 0.1f);
            }
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(-2.5f));
            matrixStackIn.mulPose(Axis.XP.rotationDegrees(-90.0f));
            ItemInHandRenderer renderer = Minecraft.getInstance().getEntityRenderDispatcher().getItemInHandRenderer();
            renderer.renderItem((LivingEntity)entitylivingbaseIn, itemstack, ItemDisplayContext.GROUND, false, matrixStackIn, bufferIn, packedLightIn);
            matrixStackIn.popPose();
        }
    }

    protected void translateToHand(boolean left, PoseStack matrixStack) {
        ((ModelCapuchinMonkey)this.getParentModel()).root.translateAndRotate(matrixStack);
        ((ModelCapuchinMonkey)this.getParentModel()).body.translateAndRotate(matrixStack);
        ((ModelCapuchinMonkey)this.getParentModel()).arm_right.translateAndRotate(matrixStack);
    }
}

