/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render.layer;

import com.github.alexthe666.alexsmobs.ClientProxy;
import com.github.alexthe666.alexsmobs.client.model.ModelCachalotWhale;
import com.github.alexthe666.alexsmobs.client.render.RenderCachalotWhale;
import com.github.alexthe666.alexsmobs.entity.EntityCachalotWhale;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.Entity;

public class LayerCachalotWhaleCapturedSquid
extends RenderLayer<EntityCachalotWhale, ModelCachalotWhale> {
    public LayerCachalotWhaleCapturedSquid(RenderCachalotWhale render) {
        super((RenderLayerParent)render);
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, EntityCachalotWhale whale, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        Entity squid;
        if (whale.hasCaughtSquid() && whale.isAlive() && (squid = whale.getCaughtSquid()) != null && squid.isAlive()) {
            boolean rightSquid = !whale.isHoldingSquidLeft();
            float riderRot = squid.yRotO + (squid.getYRot() - squid.yRotO) * partialTicks;
            EntityRenderer render = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer(squid);
            EntityModel modelBase = null;
            if (render instanceof LivingEntityRenderer) {
                modelBase = ((LivingEntityRenderer)render).getModel();
            }
            if (modelBase != null) {
                ClientProxy.currentUnrenderedEntities.remove(squid.getUUID());
                matrixStackIn.pushPose();
                this.translateToPouch(matrixStackIn);
                matrixStackIn.translate(rightSquid ? -1.2f : 1.2f, 0.0f, -3.4f);
                matrixStackIn.mulPose(Axis.ZP.rotationDegrees(180.0f));
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(riderRot + (rightSquid ? -90.0f : 90.0f)));
                this.renderEntity(squid, 0.0, 0.0, 0.0, 0.0f, partialTicks, matrixStackIn, bufferIn, packedLightIn);
                matrixStackIn.popPose();
                ClientProxy.currentUnrenderedEntities.add(squid.getUUID());
            }
        }
    }

    public <E extends Entity> void renderEntity(E entityIn, double x, double y, double z, float yaw, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int packedLight) {
        block4: {
            EntityRenderer render = null;
            EntityRenderDispatcher manager = Minecraft.getInstance().getEntityRenderDispatcher();
            try {
                render = manager.getRenderer(entityIn);
                if (render == null) break block4;
                try {
                    render.render(entityIn, yaw, partialTicks, matrixStack, bufferIn, packedLight);
                }
                catch (Throwable throwable1) {
                    throw new ReportedException(CrashReport.forThrowable((Throwable)throwable1, (String)"Rendering entity in world"));
                }
            }
            catch (Throwable throwable3) {
                CrashReport crashreport = CrashReport.forThrowable((Throwable)throwable3, (String)"Rendering entity in world");
                CrashReportCategory crashreportcategory = crashreport.addCategory("Entity being rendered");
                entityIn.fillCrashReportCategory(crashreportcategory);
                CrashReportCategory crashreportcategory1 = crashreport.addCategory("Renderer details");
                crashreportcategory1.setDetail("Assigned renderer", (Object)render);
                crashreportcategory1.setDetail("Rotation", (Object)Float.valueOf(yaw));
                crashreportcategory1.setDetail("Delta", (Object)Float.valueOf(partialTicks));
                throw new ReportedException(crashreport);
            }
        }
    }

    protected void translateToPouch(PoseStack matrixStack) {
        ((ModelCachalotWhale)this.getParentModel()).root.translateAndRotate(matrixStack);
        ((ModelCachalotWhale)this.getParentModel()).body.translateAndRotate(matrixStack);
        ((ModelCachalotWhale)this.getParentModel()).head.translateAndRotate(matrixStack);
        ((ModelCachalotWhale)this.getParentModel()).jaw.translateAndRotate(matrixStack);
    }
}

