/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render;

import com.github.alexthe666.alexsmobs.client.model.ModelVoidWormShot;
import com.github.alexthe666.alexsmobs.client.render.AMRenderTypes;
import com.github.alexthe666.alexsmobs.entity.EntityVoidWormShot;
import com.github.alexthe666.alexsmobs.entity.util.Maths;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Quaternionf;

public class RenderVoidWormShot
extends EntityRenderer<EntityVoidWormShot> {
    private static final ResourceLocation TEXTURE = ResourceLocation.parse((String)"alexsmobs:textures/entity/void_worm/void_worm_shot.png");
    private static final ModelVoidWormShot MODEL = new ModelVoidWormShot();

    public RenderVoidWormShot(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public ResourceLocation getTextureLocation(EntityVoidWormShot entity) {
        return TEXTURE;
    }

    public void render(EntityVoidWormShot entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        float home;
        matrixStackIn.pushPose();
        matrixStackIn.mulPose(new Quaternionf().rotateX(Maths.rad(180.0)));
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entityIn.yRotO, (float)entityIn.getYRot())));
        matrixStackIn.mulPose(Axis.XP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entityIn.xRotO, (float)entityIn.getXRot())));
        matrixStackIn.pushPose();
        MODEL.animate(entityIn, (float)entityIn.tickCount + partialTicks);
        float colorize = home = (entityIn.prevStopHomingProgress + (entityIn.getStopHomingProgress() - entityIn.prevStopHomingProgress) * partialTicks) / 40.0f;
        matrixStackIn.translate(0.0f, -1.5f, 0.0f);
        VertexConsumer ivertexbuilder = bufferIn.getBuffer(AMRenderTypes.getFullBright(this.getTextureLocation(entityIn)));
        MODEL.renderToBuffer(matrixStackIn, ivertexbuilder, 210, OverlayTexture.NO_OVERLAY);
        matrixStackIn.popPose();
        matrixStackIn.popPose();
    }
}

