/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render;

import com.github.alexthe666.alexsmobs.client.model.ModelVoidWormBody;
import com.github.alexthe666.alexsmobs.client.model.ModelVoidWormTail;
import com.github.alexthe666.alexsmobs.client.render.layer.LayerVoidWormGlow;
import com.github.alexthe666.alexsmobs.entity.EntityVoidWormPart;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;

public class RenderVoidWormBody
extends LivingEntityRenderer<EntityVoidWormPart, EntityModel<EntityVoidWormPart>> {
    private static final ResourceLocation TEXTURE_BODY = ResourceLocation.parse((String)"alexsmobs:textures/entity/void_worm/void_worm_body.png");
    private static final ResourceLocation TEXTURE_BODY_HURT = ResourceLocation.parse((String)"alexsmobs:textures/entity/void_worm/void_worm_body_hurt.png");
    private static final ResourceLocation TEXTURE_BODY_GLOW = ResourceLocation.parse((String)"alexsmobs:textures/entity/void_worm/void_worm_body_glow.png");
    private static final ResourceLocation TEXTURE_TAIL = ResourceLocation.parse((String)"alexsmobs:textures/entity/void_worm/void_worm_tail.png");
    private static final ResourceLocation TEXTURE_TAIL_HURT = ResourceLocation.parse((String)"alexsmobs:textures/entity/void_worm/void_worm_tail_hurt.png");
    private static final ResourceLocation TEXTURE_TAIL_GLOW = ResourceLocation.parse((String)"alexsmobs:textures/entity/void_worm/void_worm_tail_glow.png");
    private final ModelVoidWormBody bodyModel = new ModelVoidWormBody(0.0f);
    private final ModelVoidWormTail tailModel = new ModelVoidWormTail(0.0f);

    public RenderVoidWormBody(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)new ModelVoidWormBody(0.0f), 1.0f);
        this.addLayer(new LayerVoidWormGlow(this, (RenderLayerParent)this, renderManagerIn.getResourceManager(), (EntityModel)new ModelVoidWormBody(0.0f)){

            @Override
            public ResourceLocation getGlowTexture(LivingEntity worm) {
                return ((EntityVoidWormPart)worm).isTail() ? TEXTURE_TAIL_GLOW : TEXTURE_BODY_GLOW;
            }

            @Override
            public boolean isGlowing(LivingEntity worm) {
                return !((EntityVoidWormPart)worm).isHurt();
            }

            @Override
            public float getAlpha(LivingEntity livingEntity) {
                EntityVoidWormPart worm = (EntityVoidWormPart)livingEntity;
                return (float)Mth.clamp((double)(((double)worm.getHealth() - worm.getHealthThreshold()) / ((double)worm.getMaxHealth() - worm.getHealthThreshold())), (double)0.0, (double)1.0);
            }
        });
    }

    public boolean shouldRender(EntityVoidWormPart worm, Frustum camera, double camX, double camY, double camZ) {
        return worm.getPortalTicks() <= 0 && super.shouldRender((Entity)worm, camera, camX, camY, camZ);
    }

    public ResourceLocation getTextureLocation(EntityVoidWormPart entity) {
        if (entity.isHurt()) {
            return entity.isTail() ? TEXTURE_TAIL_HURT : TEXTURE_BODY_HURT;
        }
        return entity.isTail() ? TEXTURE_TAIL : TEXTURE_BODY;
    }

    protected void setupRotations(EntityVoidWormPart entityLiving, PoseStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks, float scale) {
        Pose pose = entityLiving.getPose();
        if (pose != Pose.SLEEPING) {
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(180.0f - entityLiving.getWormYaw(partialTicks)));
        }
        if (entityLiving.deathTime > 0) {
            float f = ((float)entityLiving.deathTime + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = Mth.sqrt((float)f)) > 1.0f) {
                f = 1.0f;
            }
            matrixStackIn.mulPose(Axis.ZP.rotationDegrees(f * this.getFlipDegrees(entityLiving)));
        }
    }

    protected void scale(EntityVoidWormPart entitylivingbaseIn, PoseStack matrixStackIn, float partialTickTime) {
        this.model = entitylivingbaseIn.isTail() ? this.tailModel : this.bodyModel;
        matrixStackIn.scale(entitylivingbaseIn.getWormScale(), entitylivingbaseIn.getWormScale(), entitylivingbaseIn.getWormScale());
    }

    protected boolean shouldShowName(EntityVoidWormPart entity) {
        return super.shouldShowName((LivingEntity)entity) && (entity.shouldShowName() || entity.hasCustomName() && entity == this.entityRenderDispatcher.crosshairPickEntity);
    }
}

