/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render;

import com.github.alexthe666.alexsmobs.client.model.ModelUnderminerDwarf;
import com.github.alexthe666.alexsmobs.client.model.layered.AMModelLayers;
import com.github.alexthe666.alexsmobs.client.render.AMRenderTypes;
import com.github.alexthe666.alexsmobs.client.render.layer.LayerUnderminerItem;
import com.github.alexthe666.alexsmobs.entity.EntityUnderminer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.data.ModelData;

public class RenderUnderminer
extends MobRenderer<EntityUnderminer, EntityModel<EntityUnderminer>> {
    private static final ResourceLocation TEXTURE_DWARF = ResourceLocation.parse((String)"alexsmobs:textures/entity/underminer_dwarf.png");
    private static final ResourceLocation TEXTURE_0 = ResourceLocation.parse((String)"alexsmobs:textures/entity/underminer_0.png");
    private static final ResourceLocation TEXTURE_1 = ResourceLocation.parse((String)"alexsmobs:textures/entity/underminer_1.png");
    public static final List<ResourceLocation> BREAKING_LOCATIONS = IntStream.range(0, 10).mapToObj(destroyStage -> ResourceLocation.parse((String)("alexsmobs:textures/block/ghostly_pickaxe/destroy_stage_" + destroyStage + ".png"))).collect(Collectors.toList());
    private static final ModelUnderminerDwarf DWARF_MODEL = new ModelUnderminerDwarf();
    private static HumanoidModel<EntityUnderminer> NORMAL_MODEL = null;
    private static final List<RenderType> DESTROY_TYPES = BREAKING_LOCATIONS.stream().map(AMRenderTypes::getGhostCrumbling).collect(Collectors.toList());
    public static boolean renderWithPickaxe = false;

    public RenderUnderminer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)DWARF_MODEL, 0.4f);
        NORMAL_MODEL = new HumanoidModel(Minecraft.getInstance().getEntityModels().bakeLayer(AMModelLayers.UNDERMINER));
        this.addLayer(new LayerUnderminerItem(this));
    }

    protected void scale(EntityUnderminer entitylivingbaseIn, PoseStack matrixStackIn, float partialTickTime) {
        matrixStackIn.scale(0.925f, 0.925f, 0.925f);
    }

    public boolean shouldRender(EntityUnderminer livingEntityIn, Frustum camera, double camX, double camY, double camZ) {
        BlockPos pos;
        if (super.shouldRender((Entity)livingEntityIn, camera, camX, camY, camZ)) {
            return true;
        }
        if (livingEntityIn.getMiningPos() != null && (pos = livingEntityIn.getMiningPos()) != null) {
            Vec3 vector3d = Vec3.atLowerCornerOf((Vec3i)pos);
            Vec3 vector3dCorner = Vec3.atLowerCornerOf((Vec3i)pos).add(1.0, 1.0, 1.0);
            return camera.isVisible(new AABB(vector3d.x, vector3d.y, vector3d.z, vector3dCorner.x, vector3dCorner.y, vector3dCorner.z));
        }
        return false;
    }

    protected float getFlipDegrees(EntityUnderminer entityUnderminer) {
        return 0.0f;
    }

    public void render(EntityUnderminer entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        BlockPos miningPos;
        Direction direction;
        boolean shouldSit;
        matrixStackIn.pushPose();
        this.model.attackTime = this.getAttackAnim((LivingEntity)entityIn, partialTicks);
        this.model.riding = shouldSit = entityIn.isPassenger() && entityIn.getVehicle() != null && entityIn.getVehicle().shouldRiderSit();
        this.model.young = entityIn.isBaby();
        float f = Mth.rotLerp((float)partialTicks, (float)entityIn.yBodyRotO, (float)entityIn.yBodyRot);
        float f1 = Mth.rotLerp((float)partialTicks, (float)entityIn.yHeadRotO, (float)entityIn.yHeadRot);
        float f2 = f1 - f;
        if (shouldSit && entityIn.getVehicle() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entityIn.getVehicle();
            f = Mth.rotLerp((float)partialTicks, (float)livingentity.yBodyRotO, (float)livingentity.yBodyRot);
            f2 = f1 - f;
            float f3 = Mth.wrapDegrees((float)f2);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            f = f1 - f3;
            if (f3 * f3 > 2500.0f) {
                f += f3 * 0.2f;
            }
            f2 = f1 - f;
        }
        float f6 = Mth.lerp((float)partialTicks, (float)entityIn.xRotO, (float)entityIn.getXRot());
        if (entityIn.getPose() == Pose.SLEEPING && (direction = entityIn.getBedOrientation()) != null) {
            float f4 = entityIn.getEyeHeight(Pose.STANDING) - 0.1f;
            matrixStackIn.translate((double)((float)(-direction.getStepX()) * f4), 0.0, (double)((float)(-direction.getStepZ()) * f4));
        }
        float f7 = this.getBob((LivingEntity)entityIn, partialTicks);
        this.setupRotations((LivingEntity)entityIn, matrixStackIn, f7, f, partialTicks, 1.0f);
        matrixStackIn.scale(-1.0f, -1.0f, 1.0f);
        this.scale(entityIn, matrixStackIn, partialTicks);
        matrixStackIn.translate(0.0, (double)-1.501f, 0.0);
        float f8 = 0.0f;
        float f5 = 0.0f;
        if (!shouldSit && entityIn.isAlive()) {
            f8 = entityIn.walkAnimation.speed(partialTicks);
            f5 = entityIn.walkAnimation.position(partialTicks);
            if (entityIn.isBaby()) {
                f5 *= 3.0f;
            }
            if (f8 > 1.0f) {
                f8 = 1.0f;
            }
        }
        this.model = entityIn.isDwarf() ? DWARF_MODEL : NORMAL_MODEL;
        this.model.prepareMobModel((Entity)entityIn, f5, f8, partialTicks);
        this.model.setupAnim((Entity)entityIn, f5, f8, f7, f2, f6);
        Minecraft minecraft = Minecraft.getInstance();
        boolean flag = this.isBodyVisible((LivingEntity)entityIn);
        boolean flag1 = !flag && !entityIn.isInvisibleTo((Player)minecraft.player);
        boolean flag2 = minecraft.shouldEntityAppearGlowing((Entity)entityIn);
        RenderType rendertype = this.getRenderType(entityIn, flag, flag1, flag2);
        if (rendertype != null && !entityIn.isFullyHidden()) {
            float hide = (entityIn.prevHidingProgress + (entityIn.hidingProgress - entityIn.prevHidingProgress) * partialTicks) * 0.1f;
            float alpha = (1.0f - hide) * 0.6f;
            this.shadowRadius = 0.9f * alpha;
            int i = RenderUnderminer.getOverlayCoords((LivingEntity)entityIn, (float)this.getWhiteOverlayProgress((LivingEntity)entityIn, partialTicks));
            this.renderUnderminerModel(matrixStackIn, bufferIn, rendertype, partialTicks, packedLightIn, i, flag1 ? 0.15f : Mth.clamp((float)alpha, (float)0.0f, (float)1.0f), entityIn);
        } else {
            this.shadowRadius = 0.0f;
        }
        if (!entityIn.isSpectator()) {
            for (RenderLayer layerrenderer : this.layers) {
                layerrenderer.render(matrixStackIn, bufferIn, packedLightIn, (Entity)entityIn, f5, f8, partialTicks, f7, f2, f6);
            }
        }
        matrixStackIn.popPose();
        if (this.shouldShowName((Mob)entityIn)) {
            this.renderNameTag((Entity)entityIn, entityIn.getDisplayName(), matrixStackIn, bufferIn, packedLightIn, partialTicks);
        }
        if ((miningPos = entityIn.getMiningPos()) != null) {
            matrixStackIn.pushPose();
            double d0 = Mth.lerp((double)partialTicks, (double)entityIn.xo, (double)entityIn.getX());
            double d1 = Mth.lerp((double)partialTicks, (double)entityIn.yo, (double)entityIn.getY());
            double d2 = Mth.lerp((double)partialTicks, (double)entityIn.zo, (double)entityIn.getZ());
            matrixStackIn.translate((double)miningPos.getX() - d0, (double)miningPos.getY() - d1, (double)miningPos.getZ() - d2);
            int progress = Math.round((float)(DESTROY_TYPES.size() - 1) * Mth.clamp((float)entityIn.getMiningProgress(), (float)0.0f, (float)1.0f));
            PoseStack.Pose posestack$pose = matrixStackIn.last();
            SheetedDecalTextureGenerator vertexconsumer1 = new SheetedDecalTextureGenerator(bufferIn.getBuffer(DESTROY_TYPES.get(progress)), posestack$pose, 1.0f);
            ModelData modelData = entityIn.level().getModelDataManager().getAt(miningPos);
            Minecraft.getInstance().getBlockRenderer().renderBreakingTexture(entityIn.level().getBlockState(miningPos), miningPos, (BlockAndTintGetter)entityIn.level(), matrixStackIn, (VertexConsumer)vertexconsumer1, modelData == null ? ModelData.EMPTY : modelData);
            matrixStackIn.popPose();
        }
    }

    private void renderUnderminerModel(PoseStack matrixStackIn, MultiBufferSource source, RenderType defRenderType, float partialTicks, int packedLightIn, int overlayColors, float alphaIn, EntityUnderminer entityIn) {
        this.model.renderToBuffer(matrixStackIn, source.getBuffer(defRenderType), packedLightIn, LivingEntityRenderer.getOverlayCoords((LivingEntity)entityIn, (float)0.0f));
    }

    @Nullable
    protected RenderType getRenderType(EntityUnderminer farseer, boolean normal, boolean invis, boolean outline) {
        ResourceLocation resourcelocation = this.getTextureLocation(farseer);
        return outline ? RenderType.outline((ResourceLocation)resourcelocation) : AMRenderTypes.getUnderminer(resourcelocation);
    }

    public ResourceLocation getTextureLocation(EntityUnderminer entity) {
        return entity.isDwarf() ? TEXTURE_DWARF : (entity.getVariant() == 0 ? TEXTURE_0 : TEXTURE_1);
    }
}

