/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render;

import com.github.alexthe666.alexsmobs.client.model.ModelSunbird;
import com.github.alexthe666.alexsmobs.client.render.AMRenderTypes;
import com.github.alexthe666.alexsmobs.entity.EntitySunbird;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class RenderSunbird
extends MobRenderer<EntitySunbird, ModelSunbird> {
    private static final ResourceLocation TEXTURE = ResourceLocation.parse((String)"alexsmobs:textures/entity/sunbird.png");
    private static final ResourceLocation TEXTURE_GLOW = ResourceLocation.parse((String)"alexsmobs:textures/entity/sunbird_glow.png");

    public RenderSunbird(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)new ModelSunbird(), 0.5f);
        this.addLayer(new LayerScorch(this));
    }

    private static void vertex(VertexConsumer p_114090_, Matrix4f p_114091_, Matrix3f p_114092_, int p_114093_, float p_114094_, float p_114095_, int p_114096_, int p_114097_) {
        p_114090_.addVertex(0.0f, 0.0f, 0.0f).setColor(65025, 65025, 65025, 25500).setUv((float)p_114096_, (float)p_114097_).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(p_114093_ & 0xFFFF, p_114093_ >> 16).setNormal(0.0f, 1.0f, 0.0f);
    }

    public void render(EntitySunbird entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light) {
        super.render((LivingEntity)entity, yaw, partialTicks, poseStack, buffer, light);
        float ageInTicks = (float)entity.tickCount + partialTicks;
        float scale = (12.0f + (float)Math.sin(ageInTicks * 0.3f)) * entity.getScorchProgress(partialTicks);
        if (scale > 0.0f) {
            poseStack.pushPose();
            poseStack.translate(0.0f, entity.getBbHeight() * 0.5f, 0.0f);
            poseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            poseStack.pushPose();
            poseStack.mulPose(Axis.ZP.rotationDegrees(ageInTicks * 8.0f));
            poseStack.translate(-scale * 0.5f, -scale * 0.5f, 0.0f);
            PoseStack.Pose posestack$pose = poseStack.last();
            Matrix4f matrix4f = posestack$pose.pose();
            Matrix3f matrix3f = posestack$pose.normal();
            VertexConsumer vertexconsumer = buffer.getBuffer(AMRenderTypes.getSunbirdShine());
            RenderSunbird.vertex(vertexconsumer, matrix4f, matrix3f, light, 0.0f, 0.0f, 0, 1);
            RenderSunbird.vertex(vertexconsumer, matrix4f, matrix3f, light, scale, 0.0f, 1, 1);
            RenderSunbird.vertex(vertexconsumer, matrix4f, matrix3f, light, scale, scale, 1, 0);
            RenderSunbird.vertex(vertexconsumer, matrix4f, matrix3f, light, 0.0f, scale, 0, 0);
            poseStack.popPose();
            poseStack.popPose();
        }
    }

    protected void scale(EntitySunbird entitylivingbaseIn, PoseStack matrixStackIn, float partialTickTime) {
    }

    protected int getBlockLightLevel(EntitySunbird entityIn, BlockPos partialTicks) {
        return 15;
    }

    public ResourceLocation getTextureLocation(EntitySunbird entity) {
        return TEXTURE;
    }

    static class LayerScorch
    extends RenderLayer<EntitySunbird, ModelSunbird> {
        public LayerScorch(RenderSunbird p_i50928_1_) {
            super((RenderLayerParent)p_i50928_1_);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, EntitySunbird entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            VertexConsumer scorch = bufferIn.getBuffer(AMRenderTypes.getEyesAlphaEnabled(TEXTURE_GLOW));
            float alpha = entitylivingbaseIn.getScorchProgress(partialTicks);
            ((ModelSunbird)this.getParentModel()).renderToBuffer(matrixStackIn, scorch, 240, LivingEntityRenderer.getOverlayCoords((LivingEntity)entitylivingbaseIn, (float)0.0f));
        }
    }
}

