/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render;

import com.github.alexthe666.alexsmobs.client.model.ModelSugarGlider;
import com.github.alexthe666.alexsmobs.entity.EntitySugarGlider;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.ChatFormatting;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import org.joml.Quaternionf;

public class RenderSugarGlider
extends MobRenderer<EntitySugarGlider, ModelSugarGlider> {
    private static final ResourceLocation TEXTURE = ResourceLocation.parse((String)"alexsmobs:textures/entity/sugar_glider.png");

    public RenderSugarGlider(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)new ModelSugarGlider(), 0.35f);
    }

    private Direction rotate(Direction attachmentFacing) {
        return attachmentFacing.getAxis() == Direction.Axis.Y ? Direction.UP : attachmentFacing;
    }

    protected void setupRotations(EntitySugarGlider entityLiving, PoseStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks, float scale) {
        String s;
        if (entityLiving.isPassenger()) {
            super.setupRotations((LivingEntity)entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks, 1.0f);
            return;
        }
        if (this.isShaking((LivingEntity)entityLiving)) {
            rotationYaw += (float)(Math.cos((double)entityLiving.tickCount * 3.25) * Math.PI * (double)0.4f);
        }
        float trans = entityLiving.isBaby() ? 0.2f : 0.4f;
        Pose pose = entityLiving.getPose();
        if (pose != Pose.SLEEPING) {
            float prevProg = entityLiving.prevAttachChangeProgress + (entityLiving.attachChangeProgress - entityLiving.prevAttachChangeProgress) * partialTicks;
            float yawMul = 0.0f;
            if (entityLiving.prevAttachDir == entityLiving.getAttachmentFacing() && entityLiving.getAttachmentFacing().getAxis() == Direction.Axis.Y) {
                yawMul = 1.0f;
            }
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(180.0f - yawMul * rotationYaw));
            if (entityLiving.getAttachmentFacing() == Direction.DOWN) {
                matrixStackIn.translate(0.0, (double)trans, 0.0);
                if (entityLiving.yo <= entityLiving.getY()) {
                    matrixStackIn.mulPose(Axis.XP.rotationDegrees(90.0f * prevProg));
                } else {
                    matrixStackIn.mulPose(Axis.XP.rotationDegrees(-90.0f * prevProg));
                }
                matrixStackIn.translate(0.0, (double)(-trans), 0.0);
            }
            matrixStackIn.translate(0.0, (double)trans, 0.0);
            Quaternionf current = this.rotate(entityLiving.getAttachmentFacing()).getRotation();
            current.mul(1.0f - prevProg);
            matrixStackIn.mulPose(current);
            matrixStackIn.translate(0.0, (double)(-trans), 0.0);
        }
        if (entityLiving.deathTime > 0) {
            float f = ((float)entityLiving.deathTime + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = Mth.sqrt((float)f)) > 1.0f) {
                f = 1.0f;
            }
            matrixStackIn.mulPose(Axis.ZP.rotationDegrees(f * this.getFlipDegrees((LivingEntity)entityLiving)));
        } else if (entityLiving.isAutoSpinAttack()) {
            matrixStackIn.mulPose(Axis.XP.rotationDegrees(-90.0f - entityLiving.getXRot()));
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(((float)entityLiving.tickCount + partialTicks) * -75.0f));
        } else if (entityLiving.hasCustomName() && ("Dinnerbone".equals(s = ChatFormatting.stripFormatting((String)entityLiving.getName().getString())) || "Grumm".equals(s))) {
            matrixStackIn.translate(0.0, (double)(entityLiving.getBbHeight() + 0.1f), 0.0);
            matrixStackIn.mulPose(Axis.ZP.rotationDegrees(180.0f));
        }
    }

    protected void scale(EntitySugarGlider mob, PoseStack matrixStackIn, float partialTickTime) {
        ((ModelSugarGlider)this.model).young = mob.isBaby();
        if (mob.isPassenger() && mob.getVehicle() != null && mob.getVehicle() instanceof Player) {
            Player mount = (Player)mob.getVehicle();
            EntityRenderer playerRender = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)mount);
            if ((Minecraft.getInstance().player != mount || Minecraft.getInstance().options.getCameraType() != CameraType.FIRST_PERSON) && playerRender instanceof LivingEntityRenderer && ((LivingEntityRenderer)playerRender).getModel() instanceof HumanoidModel) {
                matrixStackIn.translate(0.0f, 0.5f, 0.0f);
                ((HumanoidModel)((LivingEntityRenderer)playerRender).getModel()).head.translateAndRotate(matrixStackIn);
                matrixStackIn.translate(0.0f, -0.5f, 0.0f);
            }
        }
    }

    public ResourceLocation getTextureLocation(EntitySugarGlider entity) {
        return TEXTURE;
    }
}

