/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render;

import com.github.alexthe666.alexsmobs.client.model.ModelStraddleboard;
import com.github.alexthe666.alexsmobs.entity.EntityStraddleboard;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Quaternionf;

public class RenderStraddleboard
extends EntityRenderer<EntityStraddleboard> {
    private static final ResourceLocation TEXTURE_OVERLAY = ResourceLocation.parse((String)"alexsmobs:textures/entity/straddleboard_overlay.png");
    private static final ResourceLocation TEXTURE = ResourceLocation.parse((String)"alexsmobs:textures/entity/straddleboard.png");
    private static final ModelStraddleboard BOARD_MODEL = new ModelStraddleboard();

    public RenderStraddleboard(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public ResourceLocation getTextureLocation(EntityStraddleboard entity) {
        return TEXTURE;
    }

    public void render(EntityStraddleboard entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        matrixStackIn.pushPose();
        matrixStackIn.mulPose(new Quaternionf().rotateY((float)Math.PI));
        matrixStackIn.mulPose(Axis.YN.rotationDegrees(Mth.lerp((float)partialTicks, (float)entityIn.yRotO, (float)entityIn.getYRot()) + 180.0f));
        matrixStackIn.mulPose(Axis.XP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entityIn.xRotO, (float)entityIn.getXRot())));
        matrixStackIn.pushPose();
        boolean lava = entityIn.isVehicle();
        float f2 = entityIn.getRockingAngle(partialTicks);
        if (!Mth.equal((float)f2, (float)0.0f)) {
            matrixStackIn.mulPose(Axis.ZP.rotationDegrees(entityIn.getRockingAngle(partialTicks)));
        }
        int k = entityIn.getColor();
        float r = (float)(k >> 16 & 0xFF) / 255.0f;
        float g = (float)(k >> 8 & 0xFF) / 255.0f;
        float b = (float)(k & 0xFF) / 255.0f;
        float boardRot = entityIn.prevBoardRot + partialTicks * (entityIn.getBoardRot() - entityIn.prevBoardRot);
        matrixStackIn.mulPose(Axis.ZP.rotationDegrees(boardRot));
        matrixStackIn.mulPose(Axis.XP.rotationDegrees(180.0f));
        matrixStackIn.translate(0.0f, -1.5f - Math.abs(boardRot * 0.007f) - (lava ? 0.0f : 0.25f), 0.0f);
        BOARD_MODEL.animateBoard(entityIn, (float)entityIn.tickCount + partialTicks);
        VertexConsumer ivertexbuilder2 = bufferIn.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)TEXTURE_OVERLAY));
        BOARD_MODEL.renderToBuffer(matrixStackIn, ivertexbuilder2, packedLightIn, OverlayTexture.NO_OVERLAY);
        VertexConsumer ivertexbuilder = bufferIn.getBuffer(RenderType.entityTranslucentCull((ResourceLocation)TEXTURE));
        int color = 0xFF000000 | (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f);
        BOARD_MODEL.renderToBuffer(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, color);
        matrixStackIn.popPose();
        matrixStackIn.popPose();
    }
}

