/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render;

import com.github.alexthe666.alexsmobs.client.model.ModelSquidGrapple;
import com.github.alexthe666.alexsmobs.entity.EntitySquidGrapple;
import com.github.alexthe666.alexsmobs.misc.AMBlockPos;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class RenderSquidGrapple
extends EntityRenderer<EntitySquidGrapple> {
    private static final ResourceLocation SQUID_TEXTURE = ResourceLocation.parse((String)"alexsmobs:textures/entity/giant_squid.png");
    private static final ModelSquidGrapple SQUID_MODEL = new ModelSquidGrapple();
    private static final float TENTACLES_COLOR_R = 0.70980394f;
    private static final float TENTACLES_COLOR_G = 0.34117648f;
    private static final float TENTACLES_COLOR_B = 0.33333334f;
    private static final float TENTACLES_COLOR_R2 = 0.7490196f;
    private static final float TENTACLES_COLOR_G2 = 0.38431373f;
    private static final float TENTACLES_COLOR_B2 = 0.34901962f;

    public RenderSquidGrapple(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn);
    }

    private static void addVertexPairAlex(VertexConsumer p_174308_, Matrix4f p_174309_, float p_174310_, float p_174311_, float p_174312_, int p_174313_, int p_174314_, int p_174315_, int p_174316_, float p_174317_, float p_174318_, float p_174319_, float p_174320_, int p_174321_, boolean p_174322_) {
        float f = (float)p_174321_ / 24.0f;
        int i = (int)Mth.lerp((float)f, (float)p_174313_, (float)p_174314_);
        int j = (int)Mth.lerp((float)f, (float)p_174315_, (float)p_174316_);
        int k = LightTexture.pack((int)i, (int)j);
        float f2 = 0.70980394f;
        float f3 = 0.34117648f;
        float f4 = 0.33333334f;
        if (p_174321_ % 2 == (p_174322_ ? 1 : 0)) {
            f2 = 0.7490196f;
            f3 = 0.38431373f;
            f4 = 0.34901962f;
        }
        float f5 = p_174310_ * f;
        float f6 = p_174311_ > 0.0f ? p_174311_ * f * f : p_174311_ - p_174311_ * (1.0f - f) * (1.0f - f);
        float f7 = p_174312_ * f;
        p_174308_.addVertex(p_174309_, f5 - p_174319_, f6 + p_174318_, f7 + p_174320_).setColor((int)(f2 * 255.0f), (int)(f3 * 255.0f), (int)(f4 * 255.0f), 255).setLight(k);
        p_174308_.addVertex(p_174309_, f5 + p_174319_, f6 + p_174317_ - p_174318_, f7 - p_174320_).setColor((int)(f2 * 255.0f), (int)(f3 * 255.0f), (int)(f4 * 255.0f), 255).setLight(k);
    }

    public static <E extends Entity> void renderTentacle(Entity mob, float partialTick, PoseStack p_115464_, MultiBufferSource p_115465_, LivingEntity player, boolean left, float zOffset) {
        p_115464_.pushPose();
        float bodyRot = mob instanceof LivingEntity ? ((LivingEntity)mob).yBodyRot : mob.getYRot();
        float bodyRot0 = mob instanceof LivingEntity ? ((LivingEntity)mob).yBodyRotO : mob.yRotO;
        Vec3 vec3 = player.getRopeHoldPosition(partialTick);
        double d0 = (double)(Mth.lerp((float)partialTick, (float)bodyRot, (float)bodyRot0) * ((float)Math.PI / 180)) + 1.5707963267948966;
        Vec3 vec31 = new Vec3(0.0, 0.0, 0.0);
        double d1 = Math.cos(d0) * vec31.z + Math.sin(d0) * vec31.x;
        double d2 = Math.sin(d0) * vec31.z - Math.cos(d0) * vec31.x;
        double d3 = Mth.lerp((double)partialTick, (double)mob.xo, (double)mob.getX()) + d1;
        double d4 = Mth.lerp((double)partialTick, (double)mob.yo, (double)mob.getY()) + vec31.y;
        double d5 = Mth.lerp((double)partialTick, (double)mob.zo, (double)mob.getZ()) + d2;
        p_115464_.translate(d3, d4, d5);
        float f = (float)(vec3.x - d3);
        float f1 = (float)(vec3.y - d4);
        float f2 = (float)(vec3.z - d5);
        VertexConsumer vertexconsumer = p_115465_.getBuffer(RenderType.leash());
        Matrix4f matrix4f = p_115464_.last().pose();
        float f4 = (float)(Mth.fastInvSqrt((double)(f * f + f2 * f2)) * (double)0.025f / 2.0);
        float f5 = f2 * f4;
        float f6 = f * f4;
        BlockPos blockpos = AMBlockPos.fromVec3(mob.getEyePosition(partialTick));
        BlockPos blockpos1 = AMBlockPos.fromVec3(player.getEyePosition(partialTick));
        int i = RenderSquidGrapple.getTentacleLightLevel(mob, blockpos);
        int j = mob.level().getBrightness(LightLayer.BLOCK, blockpos1);
        int k = mob.level().getBrightness(LightLayer.SKY, blockpos);
        int l = mob.level().getBrightness(LightLayer.SKY, blockpos1);
        float width = 0.2f;
        for (int i1 = 0; i1 <= 24; ++i1) {
            RenderSquidGrapple.addVertexPairAlex(vertexconsumer, matrix4f, f, f1, f2, i, j, k, l, width, width, f5, f6, i1, false);
        }
        for (int j1 = 24; j1 >= 0; --j1) {
            RenderSquidGrapple.addVertexPairAlex(vertexconsumer, matrix4f, f, f1, f2, i, j, k, l, width, width, f5, f6, j1, true);
        }
        p_115464_.popPose();
    }

    protected static int getTentacleLightLevel(Entity p_114496_, BlockPos p_114497_) {
        return p_114496_.isOnFire() ? 15 : p_114496_.level().getBrightness(LightLayer.BLOCK, p_114497_);
    }

    public boolean shouldRender(EntitySquidGrapple grapple, Frustum f, double d1, double d2, double d3) {
        return super.shouldRender((Entity)grapple, f, d1, d2, d3) || grapple.getOwner() != null && (f.isVisible(grapple.getOwner().getBoundingBox()) || grapple.getOwner() == Minecraft.getInstance().player);
    }

    public void render(EntitySquidGrapple entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        matrixStackIn.pushPose();
        matrixStackIn.mulPose(Axis.YN.rotationDegrees(Mth.lerp((float)partialTicks, (float)entityIn.yRotO, (float)entityIn.getYRot())));
        matrixStackIn.mulPose(Axis.XP.rotationDegrees(180.0f + Mth.lerp((float)partialTicks, (float)entityIn.xRotO, (float)entityIn.getXRot())));
        matrixStackIn.translate(0.0f, -1.5f, -0.25f);
        VertexConsumer ivertexbuilder = bufferIn.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.getTextureLocation(entityIn)));
        SQUID_MODEL.renderToBuffer(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY);
        matrixStackIn.popPose();
        super.render((Entity)entityIn, 0.0f, 0.0f, null, null, 0);
        Entity entity = entityIn.getOwner();
        if (entity instanceof LivingEntity) {
            LivingEntity holder = (LivingEntity)entity;
            double d0 = Mth.lerp((double)partialTicks, (double)entityIn.xOld, (double)entityIn.getX());
            double d1 = Mth.lerp((double)partialTicks, (double)entityIn.yOld, (double)entityIn.getY());
            double d2 = Mth.lerp((double)partialTicks, (double)entityIn.zOld, (double)entityIn.getZ());
            matrixStackIn.pushPose();
            matrixStackIn.translate(-d0, -d1, -d2);
            RenderSquidGrapple.renderTentacle(entityIn, partialTicks, matrixStackIn, bufferIn, holder, holder.getMainArm() != HumanoidArm.LEFT, -0.1f);
            matrixStackIn.popPose();
        }
    }

    public ResourceLocation getTextureLocation(EntitySquidGrapple entity) {
        return SQUID_TEXTURE;
    }

    public void drawVertex(Matrix4f p_229039_1_, Matrix3f p_229039_2_, VertexConsumer p_229039_3_, int p_229039_4_, int p_229039_5_, int p_229039_6_, float p_229039_7_, float p_229039_8_, int p_229039_9_, int p_229039_10_, int p_229039_11_, int p_229039_12_) {
        p_229039_3_.addVertex(p_229039_1_, (float)p_229039_4_, (float)p_229039_5_, (float)p_229039_6_).setColor(255, 255, 255, 255).setUv(p_229039_7_, p_229039_8_).setOverlay(OverlayTexture.NO_OVERLAY).setLight(p_229039_12_).setNormal((float)p_229039_9_, (float)p_229039_11_, (float)p_229039_10_);
    }
}

