/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render;

import com.github.alexthe666.alexsmobs.client.model.ModelRaccoon;
import com.github.alexthe666.alexsmobs.client.render.AMRenderTypes;
import com.github.alexthe666.alexsmobs.client.render.layer.LayerRaccoonEyes;
import com.github.alexthe666.alexsmobs.client.render.layer.LayerRaccoonItem;
import com.github.alexthe666.alexsmobs.entity.EntityRaccoon;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;

public class RenderRaccoon
extends MobRenderer<EntityRaccoon, ModelRaccoon> {
    private static final ResourceLocation TEXTURE = ResourceLocation.parse((String)"alexsmobs:textures/entity/raccoon.png");
    private static final ResourceLocation TEXTURE_RIGBY = ResourceLocation.parse((String)"alexsmobs:textures/entity/raccoon_rigby.png");
    private static final ResourceLocation TEXTURE_BANDANA = ResourceLocation.parse((String)"alexsmobs:textures/entity/raccoon_bandana.png");

    private static float[] getColorArray(DyeColor color) {
        int rgb = color.getTextureDiffuseColor();
        float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
        float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
        float b = (float)(rgb & 0xFF) / 255.0f;
        return new float[]{r, g, b};
    }

    public RenderRaccoon(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)new ModelRaccoon(), 0.4f);
        this.addLayer(new LayerRaccoonEyes(this));
        this.addLayer(new LayerRaccoonItem(this));
        this.addLayer(new BandanaLayer(this));
    }

    protected void scale(EntityRaccoon entitylivingbaseIn, PoseStack matrixStackIn, float partialTickTime) {
        ((ModelRaccoon)this.model).young = entitylivingbaseIn.isBaby();
        matrixStackIn.scale(0.75f, 0.75f, 0.75f);
    }

    public ResourceLocation getTextureLocation(EntityRaccoon entity) {
        return entity.isRigby() ? TEXTURE_RIGBY : TEXTURE;
    }

    private static class BandanaLayer
    extends RenderLayer<EntityRaccoon, ModelRaccoon> {
        public BandanaLayer(RenderRaccoon renderRaccoon) {
            super((RenderLayerParent)renderRaccoon);
        }

        public void render(PoseStack p_225628_1_, MultiBufferSource p_225628_2_, int p_225628_3_, EntityRaccoon raccoon, float p_225628_5_, float p_225628_6_, float p_225628_7_, float p_225628_8_, float p_225628_9_, float p_225628_10_) {
            if (raccoon.getColor() != null && !raccoon.isInvisible()) {
                if (raccoon.hasCustomName() && "jeb_".equals(raccoon.getName().getContents())) {
                    int lvt_15_1_ = raccoon.tickCount / 25 + raccoon.getId();
                    int lvt_16_1_ = DyeColor.values().length;
                    int lvt_17_1_ = lvt_15_1_ % lvt_16_1_;
                    int lvt_18_1_ = (lvt_15_1_ + 1) % lvt_16_1_;
                    float lvt_19_1_ = ((float)(raccoon.tickCount % 25) + p_225628_7_) / 25.0f;
                    float[] lvt_20_1_ = RenderRaccoon.getColorArray(DyeColor.byId((int)lvt_17_1_));
                    float[] lvt_21_1_ = RenderRaccoon.getColorArray(DyeColor.byId((int)lvt_18_1_));
                    float lvt_11_2_ = lvt_20_1_[0] * (1.0f - lvt_19_1_) + lvt_21_1_[0] * lvt_19_1_;
                    float lvt_12_2_ = lvt_20_1_[1] * (1.0f - lvt_19_1_) + lvt_21_1_[1] * lvt_19_1_;
                    float lvt_13_2_ = lvt_20_1_[2] * (1.0f - lvt_19_1_) + lvt_21_1_[2] * lvt_19_1_;
                } else {
                    float[] lvt_14_2_ = RenderRaccoon.getColorArray(raccoon.getColor());
                    float lvt_11_2_ = lvt_14_2_[0];
                    float lvt_12_2_ = lvt_14_2_[1];
                    float lvt_13_2_ = lvt_14_2_[2];
                }
                ((ModelRaccoon)this.getParentModel()).renderToBuffer(p_225628_1_, p_225628_2_.getBuffer(AMRenderTypes.entityCutoutNoCull((ResourceLocation)TEXTURE_BANDANA)), p_225628_3_, OverlayTexture.NO_OVERLAY);
            }
        }
    }
}

