/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render;

import com.github.alexthe666.alexsmobs.client.model.ModelMurmurBody;
import com.github.alexthe666.alexsmobs.client.model.ModelMurmurHead;
import com.github.alexthe666.alexsmobs.client.model.ModelMurmurNeck;
import com.github.alexthe666.alexsmobs.entity.EntityMurmur;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class RenderMurmurBody
extends MobRenderer<EntityMurmur, ModelMurmurBody> {
    public static final ResourceLocation TEXTURE = ResourceLocation.parse((String)"alexsmobs:textures/entity/murmur.png");
    public static final ResourceLocation TEXTURE_ANGRY = ResourceLocation.parse((String)"alexsmobs:textures/entity/murmur_angry.png");
    public static boolean renderWithHead = false;
    private static final ModelMurmurNeck NECK_MODEL = new ModelMurmurNeck();
    private static final ModelMurmurHead HEAD_MODEL = new ModelMurmurHead();

    public RenderMurmurBody(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)new ModelMurmurBody(), 0.5f);
    }

    protected void scale(EntityMurmur entitylivingbaseIn, PoseStack matrixStackIn, float partialTickTime) {
        matrixStackIn.scale(0.85f, 0.85f, 0.85f);
    }

    public void render(EntityMurmur body, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        super.render((LivingEntity)body, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        if (renderWithHead || body.shouldRenderFakeHead()) {
            float f = Mth.rotLerp((float)partialTicks, (float)body.yBodyRotO, (float)body.yBodyRot);
            float f7 = this.getBob((LivingEntity)body, partialTicks);
            ResourceLocation loc = this.getTextureLocation(body);
            int overlayCoords = RenderMurmurBody.getOverlayCoords((LivingEntity)body, (float)this.getWhiteOverlayProgress((LivingEntity)body, partialTicks));
            matrixStackIn.pushPose();
            this.setupRotations((LivingEntity)body, matrixStackIn, f7, f, partialTicks, 1.0f);
            matrixStackIn.scale(-1.0f, -1.0f, 1.0f);
            matrixStackIn.pushPose();
            matrixStackIn.translate(0.0f, -2.9f, 0.0f);
            this.scale(body, matrixStackIn, partialTicks);
            HEAD_MODEL.resetToDefaultPose();
            HEAD_MODEL.animateHair(f7);
            HEAD_MODEL.renderToBuffer(matrixStackIn, bufferIn.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)loc)), packedLightIn, overlayCoords);
            matrixStackIn.translate(0.0f, 0.0f, 0.0f);
            NECK_MODEL.renderToBuffer(matrixStackIn, bufferIn.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)loc)), packedLightIn, overlayCoords);
            matrixStackIn.popPose();
            matrixStackIn.popPose();
        }
    }

    public ResourceLocation getTextureLocation(EntityMurmur entity) {
        return entity.isAngry() ? TEXTURE_ANGRY : TEXTURE;
    }
}

