/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render;

import com.github.alexthe666.alexsmobs.client.model.ModelMungus;
import com.github.alexthe666.alexsmobs.client.render.AMRenderTypes;
import com.github.alexthe666.alexsmobs.entity.EntityMungus;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class RenderMungus
extends MobRenderer<EntityMungus, ModelMungus> {
    private static final ResourceLocation TEXTURE = ResourceLocation.parse((String)"alexsmobs:textures/entity/mungus.png");
    private static final ResourceLocation BEAM_TEXTURE = ResourceLocation.parse((String)"alexsmobs:textures/entity/mungus_beam.png");
    private static final ResourceLocation TEXTURE_BEAM_OVERLAY = ResourceLocation.parse((String)"alexsmobs:textures/entity/mungus_beam_overlay.png");
    private static final ResourceLocation TEXTURE_SACK_OVERLAY = ResourceLocation.parse((String)"alexsmobs:textures/entity/mungus_sack.png");
    private static final ResourceLocation TEXTURE_SHOES = ResourceLocation.parse((String)"alexsmobs:textures/entity/mungus_shoes.png");
    private static final RenderType beamType = AMRenderTypes.getEyesNoFog(BEAM_TEXTURE);

    public RenderMungus(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)new ModelMungus(0.0f), 0.5f);
        this.addLayer(new MungusSackLayer(this));
        this.addLayer(new MungusMushroomLayer(this));
    }

    protected boolean isShaking(EntityMungus mungus) {
        return mungus.isReverting();
    }

    private static void vertex(VertexConsumer p_229108_0_, Matrix4f p_229108_1_, Matrix3f p_229108_2_, float p_229108_3_, float p_229108_4_, float p_229108_5_, int p_229108_6_, int p_229108_7_, int p_229108_8_, float p_229108_9_, float p_229108_10_) {
        p_229108_0_.addVertex(p_229108_5_, 0.0f, 0.0f).setColor(p_229108_6_ * 255, p_229108_7_ * 255, p_229108_8_ * 255, 65025).setUv(p_229108_9_, p_229108_10_).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(240, 0).setNormal(0.0f, 1.0f, 0.0f);
    }

    protected void setupRotations(EntityMungus entityLiving, PoseStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        if (entityLiving.deathTime > 0) {
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(180.0f - rotationYaw));
            float f = ((float)entityLiving.deathTime + partialTicks - 1.0f) / 20.0f * 1.6f;
            f = Mth.sqrt((float)f);
            if (f > 1.0f) {
                f = 1.0f;
            }
            matrixStackIn.mulPose(Axis.XP.rotationDegrees(f * -90.0f));
        } else {
            super.setupRotations((LivingEntity)entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks, 1.0f);
        }
    }

    protected float getFlipDegrees(EntityMungus p_77037_1_) {
        return 0.0f;
    }

    protected void scale(EntityMungus entitylivingbaseIn, PoseStack matrixStackIn, float partialTickTime) {
        ((ModelMungus)this.model).young = entitylivingbaseIn.isBaby();
        String s = ChatFormatting.stripFormatting((String)entitylivingbaseIn.getName().getString());
        if (s != null && s.toLowerCase().contains("drip")) {
            matrixStackIn.translate(0.0f, entitylivingbaseIn.isBaby() ? -0.075f : -0.15f, 0.0f);
        }
    }

    public boolean shouldRender(EntityMungus livingEntityIn, Frustum camera, double camX, double camY, double camZ) {
        BlockPos pos;
        if (super.shouldRender((Entity)livingEntityIn, camera, camX, camY, camZ)) {
            return true;
        }
        if (livingEntityIn.getBeamTarget() != null && (pos = livingEntityIn.getBeamTarget()) != null) {
            Vec3 vector3d = Vec3.atLowerCornerOf((Vec3i)pos);
            Vec3 vector3dCorner = Vec3.atLowerCornerOf((Vec3i)pos).add(1.0, 1.0, 1.0);
            Vec3 vector3d1 = this.getPosition((LivingEntity)livingEntityIn, livingEntityIn.getEyeHeight(), 1.0f);
            return camera.isVisible(new AABB(vector3d1.x, vector3d1.y, vector3d1.z, vector3d.x, vector3d.y, vector3d.z)) || camera.isVisible(new AABB(vector3d1.x, vector3d1.y, vector3d1.z, vector3dCorner.x, vector3dCorner.y, vector3dCorner.z));
        }
        return false;
    }

    private Vec3 getPosition(LivingEntity entityLivingBaseIn, double p_177110_2_, float p_177110_4_) {
        double d0 = Mth.lerp((double)p_177110_4_, (double)entityLivingBaseIn.xOld, (double)entityLivingBaseIn.getX());
        double d1 = Mth.lerp((double)p_177110_4_, (double)entityLivingBaseIn.yOld, (double)entityLivingBaseIn.getY()) + p_177110_2_;
        double d2 = Mth.lerp((double)p_177110_4_, (double)entityLivingBaseIn.zOld, (double)entityLivingBaseIn.getZ());
        return new Vec3(d0, d1, d2);
    }

    public void render(EntityMungus entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        super.render((LivingEntity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        BlockPos target = entityIn.getBeamTarget();
        if (target != null) {
            float f = 1.0f;
            float f1 = (float)entityIn.level().getGameTime() + partialTicks;
            float f2 = -1.0f * (f1 * 0.15f % 1.0f);
            float f3 = 1.13f;
            if (entityIn.isBaby()) {
                f3 = 0.555f;
            }
            matrixStackIn.pushPose();
            matrixStackIn.translate(0.0, (double)f3, 0.0);
            Vec3 vector3d = Vec3.upFromBottomCenterOf((Vec3i)target, (double)0.15f);
            Vec3 vector3d1 = this.getPosition((LivingEntity)entityIn, f3, partialTicks);
            Vec3 vector3d2 = vector3d.subtract(vector3d1);
            float f4 = (float)vector3d2.length();
            vector3d2 = vector3d2.normalize();
            float f5 = (float)Math.acos(vector3d2.y);
            float f6 = (float)Math.atan2(vector3d2.z, vector3d2.x);
            matrixStackIn.mulPose(Axis.YP.rotationDegrees((1.5707964f - f6) * 57.295776f));
            matrixStackIn.mulPose(Axis.XP.rotationDegrees(f5 * 57.295776f));
            boolean i = true;
            float f7 = f1 * 0.05f * 1.5f;
            float f8 = 1.0f;
            int j = (int)(f8 * 255.0f);
            int k = (int)(f8 * 255.0f);
            int l = (int)(f8 * 255.0f);
            float f9 = 0.2f;
            float f10 = 0.282f;
            float f11 = Mth.cos((float)2.3561945f) * 0.8f;
            float f12 = Mth.sin((float)2.3561945f) * 0.8f;
            float f13 = Mth.cos((float)0.7853982f) * 0.8f;
            float f14 = Mth.sin((float)0.7853982f) * 0.8f;
            float f15 = Mth.cos((float)3.926991f) * 0.8f;
            float f16 = Mth.sin((float)3.926991f) * 0.8f;
            float f17 = Mth.cos((float)5.4977875f) * 0.8f;
            float f18 = Mth.sin((float)5.4977875f) * 0.8f;
            float f19 = Mth.cos((float)((float)Math.PI)) * 0.4f;
            float f20 = Mth.sin((float)((float)Math.PI)) * 0.4f;
            float f21 = Mth.cos((float)0.0f) * 0.4f;
            float f22 = Mth.sin((float)0.0f) * 0.4f;
            float f23 = Mth.cos((float)1.5707964f) * 0.4f;
            float f24 = Mth.sin((float)1.5707964f) * 0.4f;
            float f25 = Mth.cos((float)4.712389f) * 0.4f;
            float f26 = Mth.sin((float)4.712389f) * 0.4f;
            float f27 = 0.0f;
            float f28 = 0.4999f;
            float f29 = -1.0f + f2;
            float f30 = f4 * 0.5f + f29;
            VertexConsumer ivertexbuilder = bufferIn.getBuffer(beamType);
            PoseStack.Pose matrixstack$entry = matrixStackIn.last();
            Matrix4f matrix4f = matrixstack$entry.pose();
            Matrix3f matrix3f = matrixstack$entry.normal();
            RenderMungus.vertex(ivertexbuilder, matrix4f, matrix3f, f19, f4, f20, j, k, l, 0.4999f, f30);
            RenderMungus.vertex(ivertexbuilder, matrix4f, matrix3f, f19, 0.0f, f20, j, k, l, 0.4999f, f29);
            RenderMungus.vertex(ivertexbuilder, matrix4f, matrix3f, f21, 0.0f, f22, j, k, l, 0.0f, f29);
            RenderMungus.vertex(ivertexbuilder, matrix4f, matrix3f, f21, f4, f22, j, k, l, 0.0f, f30);
            RenderMungus.vertex(ivertexbuilder, matrix4f, matrix3f, f23, f4, f24, j, k, l, 0.4999f, f30);
            RenderMungus.vertex(ivertexbuilder, matrix4f, matrix3f, f23, 0.0f, f24, j, k, l, 0.4999f, f29);
            RenderMungus.vertex(ivertexbuilder, matrix4f, matrix3f, f25, 0.0f, f26, j, k, l, 0.0f, f29);
            RenderMungus.vertex(ivertexbuilder, matrix4f, matrix3f, f25, f4, f26, j, k, l, 0.0f, f30);
            float f31 = 0.0f;
            if (entityIn.tickCount % 4 > 1) {
                f31 = 0.5f;
            }
            RenderMungus.vertex(ivertexbuilder, matrix4f, matrix3f, f11, f4, f12, j, k, l, 0.5f, f31 + 0.5f);
            RenderMungus.vertex(ivertexbuilder, matrix4f, matrix3f, f13, f4, f14, j, k, l, 1.0f, f31 + 0.5f);
            RenderMungus.vertex(ivertexbuilder, matrix4f, matrix3f, f17, f4, f18, j, k, l, 1.0f, f31);
            RenderMungus.vertex(ivertexbuilder, matrix4f, matrix3f, f15, f4, f16, j, k, l, 0.5f, f31);
            matrixStackIn.popPose();
        }
    }

    public ResourceLocation getTextureLocation(EntityMungus entity) {
        return TEXTURE;
    }

    static class MungusSackLayer
    extends RenderLayer<EntityMungus, ModelMungus> {
        public MungusSackLayer(RenderMungus p_i50928_1_) {
            super((RenderLayerParent)p_i50928_1_);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, EntityMungus entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            String s;
            VertexConsumer lead = bufferIn.getBuffer(AMRenderTypes.getEyesFlickering(TEXTURE_SACK_OVERLAY, 0.0f));
            float alpha = 0.75f + (Mth.cos((float)(ageInTicks * 0.2f)) + 1.0f) * 0.125f;
            ((ModelMungus)this.getParentModel()).renderToBuffer(matrixStackIn, lead, 240, OverlayTexture.NO_OVERLAY);
            if (entitylivingbaseIn.getBeamTarget() != null) {
                VertexConsumer beam = bufferIn.getBuffer(AMRenderTypes.getGhost(TEXTURE_BEAM_OVERLAY));
                float beamAlpha = 0.75f + (Mth.cos((float)(ageInTicks * 1.0f)) + 1.0f) * 0.125f;
                ((ModelMungus)this.getParentModel()).renderToBuffer(matrixStackIn, beam, 240, LivingEntityRenderer.getOverlayCoords((LivingEntity)entitylivingbaseIn, (float)0.0f));
            }
            if ((s = ChatFormatting.stripFormatting((String)entitylivingbaseIn.getName().getString())) != null && s.toLowerCase().contains("drip")) {
                VertexConsumer shoeBuffer = bufferIn.getBuffer(AMRenderTypes.entityCutoutNoCull((ResourceLocation)TEXTURE_SHOES));
                matrixStackIn.pushPose();
                ((ModelMungus)this.getParentModel()).renderShoes();
                ((ModelMungus)this.getParentModel()).renderToBuffer(matrixStackIn, shoeBuffer, packedLightIn, OverlayTexture.NO_OVERLAY);
                ((ModelMungus)this.getParentModel()).postRenderShoes();
                matrixStackIn.popPose();
            }
        }
    }

    static class MungusMushroomLayer
    extends RenderLayer<EntityMungus, ModelMungus> {
        public MungusMushroomLayer(RenderMungus p_i50928_1_) {
            super((RenderLayerParent)p_i50928_1_);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, EntityMungus entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            BlockRenderDispatcher blockrendererdispatcher = Minecraft.getInstance().getBlockRenderer();
            BlockState blockstate = entitylivingbaseIn.getMushroomState();
            if (blockstate == null) {
                return;
            }
            int i = LivingEntityRenderer.getOverlayCoords((LivingEntity)entitylivingbaseIn, (float)0.0f);
            boolean altOrder = entitylivingbaseIn.isAltOrderMushroom();
            int mushroomCount = entitylivingbaseIn.getMushroomCount();
            matrixStackIn.pushPose();
            if (entitylivingbaseIn.isBaby()) {
                matrixStackIn.scale(0.5f, 0.5f, 0.5f);
                matrixStackIn.translate(0.0, 1.5, 0.0);
            }
            matrixStackIn.pushPose();
            this.translateToBody(matrixStackIn);
            if (mushroomCount == 1 && !altOrder || mushroomCount >= 2) {
                matrixStackIn.pushPose();
                matrixStackIn.translate((double)0.2f, (double)-1.4f, 0.15);
                matrixStackIn.scale(-1.0f, -1.0f, 1.0f);
                matrixStackIn.translate(-0.5, -0.5, -0.5);
                blockrendererdispatcher.renderSingleBlock(blockstate, matrixStackIn, bufferIn, packedLightIn, i);
                matrixStackIn.popPose();
            }
            if (mushroomCount == 1 && altOrder || mushroomCount >= 2) {
                matrixStackIn.pushPose();
                matrixStackIn.translate((double)-0.2f, -1.5, -0.2);
                matrixStackIn.scale(-1.0f, -1.0f, 1.0f);
                matrixStackIn.translate(-0.5, -0.5, -0.5);
                blockrendererdispatcher.renderSingleBlock(blockstate, matrixStackIn, bufferIn, packedLightIn, i);
                matrixStackIn.popPose();
            }
            if (mushroomCount >= 3) {
                matrixStackIn.pushPose();
                matrixStackIn.translate((double)0.76f, (double)-0.4f, 0.1);
                matrixStackIn.mulPose(Axis.ZP.rotationDegrees(90.0f));
                matrixStackIn.scale(-1.0f, -1.0f, 1.0f);
                matrixStackIn.translate(-0.5, -0.5, -0.5);
                blockrendererdispatcher.renderSingleBlock(blockstate, matrixStackIn, bufferIn, packedLightIn, i);
                matrixStackIn.popPose();
            }
            if (mushroomCount >= 4) {
                matrixStackIn.pushPose();
                matrixStackIn.translate((double)-0.76f, -1.0, 0.1);
                matrixStackIn.mulPose(Axis.ZP.rotationDegrees(-60.0f));
                matrixStackIn.scale(-1.0f, -1.0f, 1.0f);
                matrixStackIn.translate(-0.5, -0.5, -0.5);
                blockrendererdispatcher.renderSingleBlock(blockstate, matrixStackIn, bufferIn, packedLightIn, i);
                matrixStackIn.popPose();
            }
            if (mushroomCount >= 5) {
                matrixStackIn.pushPose();
                matrixStackIn.translate((double)-0.76f, (double)-0.1f, 0.1);
                matrixStackIn.mulPose(Axis.ZP.rotationDegrees(-100.0f));
                matrixStackIn.scale(-1.0f, -1.0f, 1.0f);
                matrixStackIn.translate(-0.5, -0.5, -0.5);
                blockrendererdispatcher.renderSingleBlock(blockstate, matrixStackIn, bufferIn, packedLightIn, i);
                matrixStackIn.popPose();
            }
            matrixStackIn.popPose();
            matrixStackIn.popPose();
        }

        protected void translateToBody(PoseStack matrixStack) {
            ((ModelMungus)this.getParentModel()).root.translateAndRotate(matrixStack);
            ((ModelMungus)this.getParentModel()).body.translateAndRotate(matrixStack);
        }
    }
}

