/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render;

import com.github.alexthe666.alexsmobs.client.model.ModelMimicOctopus;
import com.github.alexthe666.alexsmobs.client.render.AMRenderTypes;
import com.github.alexthe666.alexsmobs.client.render.OctopusColorRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityMimicOctopus;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class RenderMimicOctopus
extends MobRenderer<EntityMimicOctopus, ModelMimicOctopus> {
    private static final ResourceLocation TEXTURE = ResourceLocation.parse((String)"alexsmobs:textures/entity/mimic_octopus.png");
    private static final ResourceLocation TEXTURE_OVERLAY = ResourceLocation.parse((String)"alexsmobs:textures/entity/mimic_octopus_overlay.png");
    private static final ResourceLocation TEXTURE_CREEPER = ResourceLocation.parse((String)"alexsmobs:textures/entity/mimic_octopus_creeper.png");
    private static final ResourceLocation TEXTURE_GUARDIAN = ResourceLocation.parse((String)"alexsmobs:textures/entity/mimic_octopus_guardian.png");
    private static final ResourceLocation TEXTURE_PUFFERFISH = ResourceLocation.parse((String)"alexsmobs:textures/entity/mimic_octopus_pufferfish.png");
    private static final ResourceLocation TEXTURE_MIMICUBE = ResourceLocation.parse((String)"alexsmobs:textures/entity/mimic_octopus_mimicube.png");
    private static final ResourceLocation TEXTURE_EYES = ResourceLocation.parse((String)"alexsmobs:textures/entity/mimic_octopus_eyes.png");
    private static final ResourceLocation GUARDIAN_BEAM_TEXTURE = ResourceLocation.parse((String)"textures/entity/guardian_beam.png");
    private static final RenderType BEAM_RENDER_TYPE = RenderType.entityCutoutNoCull((ResourceLocation)GUARDIAN_BEAM_TEXTURE);

    public RenderMimicOctopus(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)new ModelMimicOctopus(), 0.4f);
        this.addLayer(new OverlayLayer(this));
    }

    private static void vertex(VertexConsumer p_229108_0_, Matrix4f p_229108_1_, Matrix3f p_229108_2_, float p_229108_3_, float p_229108_4_, float p_229108_5_, int p_229108_6_, int p_229108_7_, int p_229108_8_, float p_229108_9_, float p_229108_10_) {
        p_229108_0_.addVertex(p_229108_5_, 0.0f, 0.0f).setColor(p_229108_6_ * 255, p_229108_7_ * 255, p_229108_8_ * 255, 65025).setUv(p_229108_9_, p_229108_10_).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(240, 240).setNormal(0.0f, 1.0f, 0.0f);
    }

    public void render(EntityMimicOctopus entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        LivingEntity livingentity = entityIn.getGuardianLaser();
        if (livingentity != null) {
            float f = entityIn.getLaserAttackAnimationScale(partialTicks);
            float f1 = (float)entityIn.level().getGameTime() + partialTicks;
            float f2 = f1 * 0.5f % 1.0f;
            float f3 = entityIn.getEyeHeight();
            matrixStackIn.pushPose();
            matrixStackIn.translate(0.0, (double)f3, 0.0);
            Vec3 vector3d = this.getPosition(livingentity, (double)livingentity.getBbHeight() * 0.5, partialTicks);
            Vec3 vector3d1 = this.getPosition((LivingEntity)entityIn, f3, partialTicks);
            Vec3 vector3d2 = vector3d.subtract(vector3d1);
            float f4 = (float)(vector3d2.length() + 1.0);
            vector3d2 = vector3d2.normalize();
            float f5 = (float)Math.acos(vector3d2.y);
            float f6 = (float)Math.atan2(vector3d2.z, vector3d2.x);
            matrixStackIn.mulPose(Axis.YP.rotationDegrees((1.5707964f - f6) * 57.295776f));
            matrixStackIn.mulPose(Axis.XP.rotationDegrees(f5 * 57.295776f));
            boolean i = true;
            float f7 = f1 * 0.05f * -1.5f;
            float f8 = f * f;
            int j = 64 + (int)(f8 * 191.0f);
            int k = 32 + (int)(f8 * 191.0f);
            int l = 128 - (int)(f8 * 64.0f);
            float f9 = 0.2f;
            float f10 = 0.282f;
            float f11 = Mth.cos((float)(f7 + 2.3561945f)) * 0.282f;
            float f12 = Mth.sin((float)(f7 + 2.3561945f)) * 0.282f;
            float f13 = Mth.cos((float)(f7 + 0.7853982f)) * 0.282f;
            float f14 = Mth.sin((float)(f7 + 0.7853982f)) * 0.282f;
            float f15 = Mth.cos((float)(f7 + 3.926991f)) * 0.282f;
            float f16 = Mth.sin((float)(f7 + 3.926991f)) * 0.282f;
            float f17 = Mth.cos((float)(f7 + 5.4977875f)) * 0.282f;
            float f18 = Mth.sin((float)(f7 + 5.4977875f)) * 0.282f;
            float f19 = Mth.cos((float)(f7 + (float)Math.PI)) * 0.2f;
            float f20 = Mth.sin((float)(f7 + (float)Math.PI)) * 0.2f;
            float f21 = Mth.cos((float)(f7 + 0.0f)) * 0.2f;
            float f22 = Mth.sin((float)(f7 + 0.0f)) * 0.2f;
            float f23 = Mth.cos((float)(f7 + 1.5707964f)) * 0.2f;
            float f24 = Mth.sin((float)(f7 + 1.5707964f)) * 0.2f;
            float f25 = Mth.cos((float)(f7 + 4.712389f)) * 0.2f;
            float f26 = Mth.sin((float)(f7 + 4.712389f)) * 0.2f;
            float f27 = 0.0f;
            float f28 = 0.4999f;
            float f29 = -1.0f + f2;
            float f30 = f4 * 2.5f + f29;
            VertexConsumer ivertexbuilder = bufferIn.getBuffer(BEAM_RENDER_TYPE);
            PoseStack.Pose matrixstack$entry = matrixStackIn.last();
            Matrix4f matrix4f = matrixstack$entry.pose();
            Matrix3f matrix3f = matrixstack$entry.normal();
            RenderMimicOctopus.vertex(ivertexbuilder, matrix4f, matrix3f, f19, f4, f20, j, k, l, 0.4999f, f30);
            RenderMimicOctopus.vertex(ivertexbuilder, matrix4f, matrix3f, f19, 0.0f, f20, j, k, l, 0.4999f, f29);
            RenderMimicOctopus.vertex(ivertexbuilder, matrix4f, matrix3f, f21, 0.0f, f22, j, k, l, 0.0f, f29);
            RenderMimicOctopus.vertex(ivertexbuilder, matrix4f, matrix3f, f21, f4, f22, j, k, l, 0.0f, f30);
            RenderMimicOctopus.vertex(ivertexbuilder, matrix4f, matrix3f, f23, f4, f24, j, k, l, 0.4999f, f30);
            RenderMimicOctopus.vertex(ivertexbuilder, matrix4f, matrix3f, f23, 0.0f, f24, j, k, l, 0.4999f, f29);
            RenderMimicOctopus.vertex(ivertexbuilder, matrix4f, matrix3f, f25, 0.0f, f26, j, k, l, 0.0f, f29);
            RenderMimicOctopus.vertex(ivertexbuilder, matrix4f, matrix3f, f25, f4, f26, j, k, l, 0.0f, f30);
            float f31 = 0.0f;
            if (entityIn.tickCount % 2 == 0) {
                f31 = 0.5f;
            }
            RenderMimicOctopus.vertex(ivertexbuilder, matrix4f, matrix3f, f11, f4, f12, j, k, l, 0.5f, f31 + 0.5f);
            RenderMimicOctopus.vertex(ivertexbuilder, matrix4f, matrix3f, f13, f4, f14, j, k, l, 1.0f, f31 + 0.5f);
            RenderMimicOctopus.vertex(ivertexbuilder, matrix4f, matrix3f, f17, f4, f18, j, k, l, 1.0f, f31);
            RenderMimicOctopus.vertex(ivertexbuilder, matrix4f, matrix3f, f15, f4, f16, j, k, l, 0.5f, f31);
            matrixStackIn.popPose();
        }
        super.render((LivingEntity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    protected void scale(EntityMimicOctopus octo, PoseStack matrixStackIn, float partialTickTime) {
        ((ModelMimicOctopus)this.model).young = octo.isBaby();
        matrixStackIn.translate(0.0f, -0.02f, 0.0f);
        matrixStackIn.scale(0.9f * octo.getScale(), 0.9f * octo.getScale(), 0.9f * octo.getScale());
    }

    public boolean shouldRender(EntityMimicOctopus livingEntityIn, Frustum camera, double camX, double camY, double camZ) {
        LivingEntity livingentity;
        if (super.shouldRender((Entity)livingEntityIn, camera, camX, camY, camZ)) {
            return true;
        }
        if (livingEntityIn.hasGuardianLaser() && (livingentity = livingEntityIn.getGuardianLaser()) != null) {
            Vec3 vector3d = this.getPosition(livingentity, (double)livingentity.getBbHeight() * 0.5, 1.0f);
            Vec3 vector3d1 = this.getPosition((LivingEntity)livingEntityIn, livingEntityIn.getEyeHeight(), 1.0f);
            return camera.isVisible(new AABB(vector3d1.x, vector3d1.y, vector3d1.z, vector3d.x, vector3d.y, vector3d.z));
        }
        return false;
    }

    private Vec3 getPosition(LivingEntity entityLivingBaseIn, double p_177110_2_, float p_177110_4_) {
        double d0 = Mth.lerp((double)p_177110_4_, (double)entityLivingBaseIn.xOld, (double)entityLivingBaseIn.getX());
        double d1 = Mth.lerp((double)p_177110_4_, (double)entityLivingBaseIn.yOld, (double)entityLivingBaseIn.getY()) + p_177110_2_;
        double d2 = Mth.lerp((double)p_177110_4_, (double)entityLivingBaseIn.zOld, (double)entityLivingBaseIn.getZ());
        return new Vec3(d0, d1, d2);
    }

    public ResourceLocation getTextureLocation(EntityMimicOctopus entity) {
        return TEXTURE;
    }

    static class OverlayLayer
    extends RenderLayer<EntityMimicOctopus, ModelMimicOctopus> {
        public OverlayLayer(RenderMimicOctopus render) {
            super((RenderLayerParent)render);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource buffer, int packedLightIn, EntityMimicOctopus entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            float transProgress = entitylivingbaseIn.prevTransProgress + (entitylivingbaseIn.transProgress - entitylivingbaseIn.prevTransProgress) * partialTicks;
            float colorProgress = (entitylivingbaseIn.prevColorShiftProgress + (entitylivingbaseIn.colorShiftProgress - entitylivingbaseIn.prevColorShiftProgress) * partialTicks) * 0.2f;
            float r = 1.0f;
            float g = 1.0f;
            float b = 1.0f;
            float a = 1.0f;
            float startR = 1.0f;
            float startG = 1.0f;
            float startB = 1.0f;
            float startA = 1.0f;
            float finR = 1.0f;
            float finG = 1.0f;
            float finB = 1.0f;
            float finA = 1.0f;
            if (entitylivingbaseIn.getPrevMimicState() == EntityMimicOctopus.MimicState.OVERLAY) {
                if (entitylivingbaseIn.getPrevMimickedBlock() != null) {
                    int j = OctopusColorRegistry.getBlockColor(entitylivingbaseIn.getPrevMimickedBlock());
                    startR = (float)(j >> 16 & 0xFF) / 255.0f;
                    startG = (float)(j >> 8 & 0xFF) / 255.0f;
                    startB = (float)(j & 0xFF) / 255.0f;
                } else {
                    startA = 0.0f;
                }
            }
            if (entitylivingbaseIn.getMimicState() == EntityMimicOctopus.MimicState.OVERLAY) {
                if (entitylivingbaseIn.getMimickedBlock() != null) {
                    int i = OctopusColorRegistry.getBlockColor(entitylivingbaseIn.getMimickedBlock());
                    finR = (float)(i >> 16 & 0xFF) / 255.0f;
                    finG = (float)(i >> 8 & 0xFF) / 255.0f;
                    finB = (float)(i & 0xFF) / 255.0f;
                } else {
                    finA = 0.0f;
                }
                r = startR + (finR - startR) * colorProgress;
                g = startG + (finG - startG) * colorProgress;
                b = startB + (finB - startB) * colorProgress;
                a = startA + (finA - startA) * colorProgress;
            }
            if (a == 1.0f) {
                a *= 0.9f + 0.1f * (float)Math.sin((float)entitylivingbaseIn.tickCount * 0.1f);
            }
            if (entitylivingbaseIn.getPrevMimicState() != null) {
                float alphaPrev = 1.0f - transProgress * 0.2f;
                VertexConsumer prev = buffer.getBuffer(AMRenderTypes.entityTranslucent((ResourceLocation)this.getFor(entitylivingbaseIn.getPrevMimicState())));
                if (entitylivingbaseIn.getPrevMimicState() == entitylivingbaseIn.getMimicState()) {
                    alphaPrev *= a;
                }
                ((ModelMimicOctopus)this.getParentModel()).renderToBuffer(matrixStackIn, prev, packedLightIn, LivingEntityRenderer.getOverlayCoords((LivingEntity)entitylivingbaseIn, (float)0.0f));
            }
            float alphaCurrent = transProgress * 0.2f;
            VertexConsumer current = buffer.getBuffer(AMRenderTypes.entityTranslucent((ResourceLocation)this.getFor(entitylivingbaseIn.getMimicState())));
            ((ModelMimicOctopus)this.getParentModel()).renderToBuffer(matrixStackIn, current, packedLightIn, LivingEntityRenderer.getOverlayCoords((LivingEntity)entitylivingbaseIn, (float)0.0f));
            VertexConsumer eyes = buffer.getBuffer(AMRenderTypes.entityTranslucent((ResourceLocation)TEXTURE_EYES));
            ((ModelMimicOctopus)this.getParentModel()).renderToBuffer(matrixStackIn, eyes, packedLightIn, LivingEntityRenderer.getOverlayCoords((LivingEntity)entitylivingbaseIn, (float)0.0f));
        }

        public ResourceLocation getFor(EntityMimicOctopus.MimicState state) {
            if (state == EntityMimicOctopus.MimicState.CREEPER) {
                return TEXTURE_CREEPER;
            }
            if (state == EntityMimicOctopus.MimicState.GUARDIAN) {
                return TEXTURE_GUARDIAN;
            }
            if (state == EntityMimicOctopus.MimicState.PUFFERFISH) {
                return TEXTURE_PUFFERFISH;
            }
            if (state == EntityMimicOctopus.MimicState.MIMICUBE) {
                return TEXTURE_MIMICUBE;
            }
            return TEXTURE_OVERLAY;
        }
    }
}

