/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render;

import com.github.alexthe666.alexsmobs.client.model.ModelKomodoDragon;
import com.github.alexthe666.alexsmobs.client.render.AMRenderTypes;
import com.github.alexthe666.alexsmobs.entity.EntityKomodoDragon;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class RenderKomodoDragon
extends MobRenderer<EntityKomodoDragon, ModelKomodoDragon> {
    private static final ResourceLocation TEXTURE = ResourceLocation.parse((String)"alexsmobs:textures/entity/komodo_dragon.png");
    private static final ResourceLocation TEXTURE_SADDLE = ResourceLocation.parse((String)"alexsmobs:textures/entity/komodo_dragon_saddle.png");
    private static final ResourceLocation TEXTURE_MAID = ResourceLocation.parse((String)"alexsmobs:textures/entity/komodo_dragon_maid.png");

    public RenderKomodoDragon(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)new ModelKomodoDragon(0.0f), 0.6f);
        this.addLayer(new LayerSaddle(this));
    }

    protected void scale(EntityKomodoDragon entitylivingbaseIn, PoseStack matrixStackIn, float partialTickTime) {
        ((ModelKomodoDragon)this.model).young = entitylivingbaseIn.isBaby();
    }

    public ResourceLocation getTextureLocation(EntityKomodoDragon entity) {
        return TEXTURE;
    }

    static class LayerSaddle
    extends RenderLayer<EntityKomodoDragon, ModelKomodoDragon> {
        private static final ModelKomodoDragon MAID_MODEL = new ModelKomodoDragon(0.3f);
        private static final ModelKomodoDragon SADDLE_MODEL = new ModelKomodoDragon(0.5f);

        public LayerSaddle(RenderKomodoDragon render) {
            super((RenderLayerParent)render);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, EntityKomodoDragon entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (entitylivingbaseIn.isMaid()) {
                VertexConsumer maid = bufferIn.getBuffer(AMRenderTypes.entityCutoutNoCull((ResourceLocation)TEXTURE_MAID));
                ((ModelKomodoDragon)this.getParentModel()).copyPropertiesTo((EntityModel)MAID_MODEL);
                MAID_MODEL.prepareMobModel((Entity)entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks);
                MAID_MODEL.setupAnim(entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                MAID_MODEL.renderToBuffer(matrixStackIn, maid, packedLightIn, LivingEntityRenderer.getOverlayCoords((LivingEntity)entitylivingbaseIn, (float)0.0f));
            }
            if (entitylivingbaseIn.isSaddled()) {
                VertexConsumer saddle = bufferIn.getBuffer(AMRenderTypes.entityCutoutNoCull((ResourceLocation)TEXTURE_SADDLE));
                ((ModelKomodoDragon)this.getParentModel()).copyPropertiesTo((EntityModel)SADDLE_MODEL);
                SADDLE_MODEL.prepareMobModel((Entity)entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks);
                SADDLE_MODEL.setupAnim(entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                SADDLE_MODEL.renderToBuffer(matrixStackIn, saddle, packedLightIn, LivingEntityRenderer.getOverlayCoords((LivingEntity)entitylivingbaseIn, (float)0.0f));
            }
        }
    }
}

