/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render;

import com.github.alexthe666.alexsmobs.client.model.ModelFart;
import com.github.alexthe666.alexsmobs.entity.EntityFart;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class RenderFart
extends EntityRenderer<EntityFart> {
    private static final ResourceLocation FART_TEXTURE = ResourceLocation.parse((String)"alexsmobs:textures/entity/fart.png");
    private static final ModelFart MODEL = new ModelFart();

    public RenderFart(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn);
    }

    public void render(EntityFart entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        float f = Math.min((float)entityIn.tickCount + partialTicks, 30.0f) / 30.0f;
        float alpha = 1.0f - f;
        matrixStackIn.pushPose();
        matrixStackIn.translate(0.0, (double)0.15f, 0.0);
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entityIn.yRotO, (float)entityIn.getYRot()) - 180.0f));
        matrixStackIn.mulPose(Axis.XP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entityIn.xRotO, (float)entityIn.getXRot())));
        VertexConsumer ivertexbuilder = bufferIn.getBuffer(RenderType.entityTranslucent((ResourceLocation)FART_TEXTURE));
        MODEL.setupAnim(entityIn, 0.0f, 0.0f, partialTicks, 0.0f, 0.0f);
        MODEL.renderToBuffer(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY);
        matrixStackIn.popPose();
        super.render((Entity)entityIn, 0.0f, 0.0f, null, null, 0);
    }

    public ResourceLocation getTextureLocation(EntityFart entity) {
        return FART_TEXTURE;
    }
}

