/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render;

import com.github.alexthe666.alexsmobs.client.model.ModelCosmaw;
import com.github.alexthe666.alexsmobs.client.render.layer.LayerBasicGlow;
import com.github.alexthe666.alexsmobs.entity.EntityCosmaw;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class RenderCosmaw
extends MobRenderer<EntityCosmaw, ModelCosmaw> {
    private static final ResourceLocation TEXTURE = ResourceLocation.parse((String)"alexsmobs:textures/entity/cosmaw.png");
    private static final ResourceLocation TEXTURE_GLOW = ResourceLocation.parse((String)"alexsmobs:textures/entity/cosmaw_glow.png");

    public RenderCosmaw(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)new ModelCosmaw(), 0.9f);
        this.addLayer(new LayerHeldItem(this));
        this.addLayer(new LayerBasicGlow(this, TEXTURE_GLOW));
    }

    protected void scale(EntityCosmaw entitylivingbaseIn, PoseStack matrixStackIn, float partialTickTime) {
        matrixStackIn.translate(0.0f, -0.5f, 0.0f);
    }

    public ResourceLocation getTextureLocation(EntityCosmaw entity) {
        return TEXTURE;
    }

    class LayerHeldItem
    extends RenderLayer<EntityCosmaw, ModelCosmaw> {
        public LayerHeldItem(RenderCosmaw this$0) {
            super((RenderLayerParent)this$0);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, EntityCosmaw entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            ItemStack itemstack = entitylivingbaseIn.getMainHandItem();
            matrixStackIn.pushPose();
            this.translateToHand(matrixStackIn);
            matrixStackIn.translate(-0.0, (double)0.1f, (double)-1.35f);
            matrixStackIn.mulPose(Axis.XP.rotationDegrees(-45.0f));
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(-180.0f));
            matrixStackIn.mulPose(Axis.ZP.rotationDegrees(135.0f));
            matrixStackIn.scale(2.0f, 2.0f, 2.0f);
            ItemInHandRenderer renderer = Minecraft.getInstance().getEntityRenderDispatcher().getItemInHandRenderer();
            renderer.renderItem((LivingEntity)entitylivingbaseIn, itemstack, ItemDisplayContext.GROUND, false, matrixStackIn, bufferIn, packedLightIn);
            matrixStackIn.popPose();
        }

        protected void translateToHand(PoseStack matrixStack) {
            ((ModelCosmaw)this.getParentModel()).root.translateAndRotate(matrixStack);
            ((ModelCosmaw)this.getParentModel()).body.translateAndRotate(matrixStack);
            ((ModelCosmaw)this.getParentModel()).mouthArm1.translateAndRotate(matrixStack);
            ((ModelCosmaw)this.getParentModel()).mouthArm2.translateAndRotate(matrixStack);
        }
    }
}

