/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render;

import com.github.alexthe666.alexsmobs.client.model.ModelCombJelly;
import com.github.alexthe666.alexsmobs.entity.EntityCombJelly;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;

public class RenderCombJelly
extends MobRenderer<EntityCombJelly, ModelCombJelly> {
    private static final ResourceLocation TEXTURE_0 = ResourceLocation.parse((String)"alexsmobs:textures/entity/comb_jelly_blue.png");
    private static final ResourceLocation TEXTURE_1 = ResourceLocation.parse((String)"alexsmobs:textures/entity/comb_jelly_green.png");
    private static final ResourceLocation TEXTURE_2 = ResourceLocation.parse((String)"alexsmobs:textures/entity/comb_jelly_red.png");
    private static final ResourceLocation TEXTURE_OVERLAY = ResourceLocation.parse((String)"alexsmobs:textures/entity/comb_jelly_overlay.png");
    private static final ModelCombJelly STRIPES_MODEL = new ModelCombJelly(0.05f);

    public RenderCombJelly(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)new ModelCombJelly(0.0f), 0.3f);
        this.addLayer(new RainbowLayer(this));
    }

    protected void scale(EntityCombJelly jelly, PoseStack matrixStackIn, float partialTickTime) {
        matrixStackIn.scale(jelly.getJellyScale(), jelly.getJellyScale(), jelly.getJellyScale());
    }

    protected float getFlipDegrees(EntityCombJelly jelly) {
        return 0.0f;
    }

    @Nullable
    protected RenderType getRenderType(EntityCombJelly jelly, boolean normal, boolean invis, boolean outline) {
        ResourceLocation resourcelocation = this.getTextureLocation(jelly);
        if (invis) {
            return RenderType.itemEntityTranslucentCull((ResourceLocation)resourcelocation);
        }
        if (normal) {
            return RenderType.entityTranslucent((ResourceLocation)resourcelocation);
        }
        return outline ? RenderType.outline((ResourceLocation)resourcelocation) : null;
    }

    public ResourceLocation getTextureLocation(EntityCombJelly entity) {
        return entity.getVariant() == 0 ? TEXTURE_0 : (entity.getVariant() == 1 ? TEXTURE_1 : TEXTURE_2);
    }

    static class RainbowLayer
    extends RenderLayer<EntityCombJelly, ModelCombJelly> {
        public RainbowLayer(RenderCombJelly render) {
            super((RenderLayerParent)render);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, EntityCombJelly entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            VertexConsumer overlay = bufferIn.getBuffer(RenderType.entityTranslucentEmissive((ResourceLocation)TEXTURE_OVERLAY));
            STRIPES_MODEL.setupAnim(entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            STRIPES_MODEL.renderToBuffer(matrixStackIn, overlay, packedLightIn, OverlayTexture.NO_OVERLAY);
        }
    }
}

