/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render;

import com.github.alexthe666.alexsmobs.client.model.ModelCaveCentipede;
import com.github.alexthe666.alexsmobs.entity.EntityCentipedeTail;
import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;

public class RenderCentipedeTail
extends MobRenderer<EntityCentipedeTail, AdvancedEntityModel<EntityCentipedeTail>> {
    private static final ResourceLocation TEXTURE = ResourceLocation.parse((String)"alexsmobs:textures/entity/cave_centipede.png");

    public RenderCentipedeTail(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, new ModelCaveCentipede(2), 0.5f);
    }

    protected float getFlipDegrees(EntityCentipedeTail centipede) {
        return 180.0f;
    }

    protected void setupRotations(EntityCentipedeTail entity, PoseStack stack, float pitchIn, float yawIn, float partialTickTime, float scale) {
        String s;
        Pose pose;
        float newYaw = entity.yHeadRot;
        if (this.isShaking((LivingEntity)entity)) {
            newYaw += (float)(Math.cos((double)entity.tickCount * 3.25) * Math.PI * (double)0.4f);
        }
        if ((pose = entity.getPose()) != Pose.SLEEPING) {
            stack.mulPose(Axis.YP.rotationDegrees(180.0f - newYaw));
            stack.mulPose(Axis.XP.rotationDegrees(entity.getXRot()));
        }
        if (entity.deathTime > 0) {
            float f = ((float)entity.deathTime + partialTickTime - 1.0f) / 20.0f * 1.6f;
            if ((f = Mth.sqrt((float)f)) > 1.0f) {
                f = 1.0f;
            }
            stack.translate(0.0f, f * 1.15f, 0.0f);
            stack.mulPose(Axis.ZP.rotationDegrees(f * this.getFlipDegrees(entity)));
        } else if (entity.hasCustomName() && ("Dinnerbone".equals(s = ChatFormatting.stripFormatting((String)entity.getName().getString())) || "Grumm".equals(s))) {
            stack.translate(0.0, (double)(entity.getBbHeight() + 0.1f), 0.0);
            stack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        }
    }

    public ResourceLocation getTextureLocation(EntityCentipedeTail entity) {
        return TEXTURE;
    }
}

