/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render;

import com.github.alexthe666.alexsmobs.client.model.ModelBananaSlug;
import com.github.alexthe666.alexsmobs.entity.EntityBananaSlug;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;

public class RenderBananaSlug
extends MobRenderer<EntityBananaSlug, ModelBananaSlug> {
    private static final ResourceLocation TEXTURE_0 = ResourceLocation.parse((String)"alexsmobs:textures/entity/banana_slug/banana_slug_0.png");
    private static final ResourceLocation TEXTURE_1 = ResourceLocation.parse((String)"alexsmobs:textures/entity/banana_slug/banana_slug_1.png");
    private static final ResourceLocation TEXTURE_2 = ResourceLocation.parse((String)"alexsmobs:textures/entity/banana_slug/banana_slug_2.png");
    private static final ResourceLocation TEXTURE_3 = ResourceLocation.parse((String)"alexsmobs:textures/entity/banana_slug/banana_slug_3.png");
    private static final ResourceLocation TEXTURE_SLIME = ResourceLocation.parse((String)"alexsmobs:textures/entity/banana_slug/banana_slug_slime.png");

    public RenderBananaSlug(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)new ModelBananaSlug(), 0.2f);
        this.addLayer(new LayerSlime(this));
    }

    protected void scale(EntityBananaSlug entitylivingbaseIn, PoseStack matrixStackIn, float partialTickTime) {
        matrixStackIn.scale(0.9f, 0.9f, 0.9f);
    }

    private Direction rotate(Direction attachmentFacing) {
        return attachmentFacing.getAxis() == Direction.Axis.Y ? Direction.UP : attachmentFacing;
    }

    private void rotateForAngle(PoseStack matrixStackIn, Direction rotate, float f) {
        if (rotate.getAxis() != Direction.Axis.Y) {
            matrixStackIn.mulPose(Axis.XP.rotationDegrees(90.0f * f));
        }
        switch (rotate) {
            case DOWN: {
                matrixStackIn.mulPose(Axis.ZP.rotationDegrees(180.0f * f));
                break;
            }
            case UP: {
                break;
            }
            case NORTH: {
                matrixStackIn.mulPose(Axis.ZP.rotationDegrees(180.0f * f));
                break;
            }
            case SOUTH: {
                break;
            }
            case WEST: {
                matrixStackIn.mulPose(Axis.ZP.rotationDegrees(90.0f * f));
                break;
            }
            case EAST: {
                matrixStackIn.mulPose(Axis.ZP.rotationDegrees(-90.0f * f));
            }
        }
    }

    protected void setupRotations(EntityBananaSlug entityLiving, PoseStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        String s;
        if (entityLiving.isPassenger()) {
            super.setupRotations((LivingEntity)entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks, 1.0f);
            return;
        }
        if (this.isShaking((LivingEntity)entityLiving)) {
            rotationYaw += (float)(Math.cos((double)entityLiving.tickCount * 3.25) * Math.PI * (double)0.4f);
        }
        float trans = entityLiving.isBaby() ? 0.2f : 0.4f;
        Pose pose = entityLiving.getPose();
        if (pose != Pose.SLEEPING) {
            float progress = (entityLiving.prevAttachChangeProgress + (entityLiving.attachChangeProgress - entityLiving.prevAttachChangeProgress) * partialTicks) * 0.2f;
            float yawMul = 0.0f;
            if (entityLiving.prevAttachDir == entityLiving.getAttachmentFacing() && entityLiving.getAttachmentFacing().getAxis() == Direction.Axis.Y) {
                yawMul = 1.0f;
            }
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(180.0f - yawMul * rotationYaw));
            matrixStackIn.translate(0.0, (double)trans, 0.0);
            float prevProg = 1.0f - progress;
            this.rotateForAngle(matrixStackIn, this.rotate(entityLiving.prevAttachDir), prevProg);
            this.rotateForAngle(matrixStackIn, this.rotate(entityLiving.getAttachmentFacing()), progress);
            if (entityLiving.getAttachmentFacing() != Direction.DOWN) {
                matrixStackIn.translate(0.0, (double)trans, 0.0);
                if (entityLiving.getDeltaMovement().y <= (double)-0.001f) {
                    matrixStackIn.mulPose(Axis.YN.rotationDegrees(180.0f * progress));
                }
                matrixStackIn.translate(0.0, (double)(-trans), 0.0);
            }
            matrixStackIn.translate(0.0, (double)(-trans), 0.0);
        }
        if (entityLiving.deathTime > 0) {
            float f = ((float)entityLiving.deathTime + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = Mth.sqrt((float)f)) > 1.0f) {
                f = 1.0f;
            }
            matrixStackIn.mulPose(Axis.ZP.rotationDegrees(f * this.getFlipDegrees((LivingEntity)entityLiving)));
        } else if (entityLiving.isAutoSpinAttack()) {
            matrixStackIn.mulPose(Axis.XP.rotationDegrees(-90.0f - entityLiving.getXRot()));
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(((float)entityLiving.tickCount + partialTicks) * -75.0f));
        } else if (pose != Pose.SLEEPING && entityLiving.hasCustomName() && ("Dinnerbone".equals(s = ChatFormatting.stripFormatting((String)entityLiving.getName().getString())) || "Grumm".equals(s))) {
            matrixStackIn.translate(0.0, (double)(entityLiving.getBbHeight() + 0.1f), 0.0);
            matrixStackIn.mulPose(Axis.ZP.rotationDegrees(180.0f));
        }
    }

    public ResourceLocation getTextureLocation(EntityBananaSlug entity) {
        return switch (entity.getVariant()) {
            case 1 -> TEXTURE_1;
            case 2 -> TEXTURE_2;
            case 3 -> TEXTURE_3;
            default -> TEXTURE_0;
        };
    }

    class LayerSlime
    extends RenderLayer<EntityBananaSlug, ModelBananaSlug> {
        public LayerSlime(RenderBananaSlug this$0) {
            super((RenderLayerParent)this$0);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, EntityBananaSlug entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            float alpha = entitylivingbaseIn.prevTrailVisability + (entitylivingbaseIn.trailVisability - entitylivingbaseIn.prevTrailVisability) * partialTicks;
            if (alpha > 0.0f) {
                VertexConsumer ivertexbuilder = bufferIn.getBuffer(RenderType.entityTranslucent((ResourceLocation)TEXTURE_SLIME));
                ((ModelBananaSlug)this.getParentModel()).renderToBuffer(matrixStackIn, ivertexbuilder, packedLightIn, LivingEntityRenderer.getOverlayCoords((LivingEntity)entitylivingbaseIn, (float)0.0f));
            }
        }
    }
}

