/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render;

import com.github.alexthe666.alexsmobs.client.model.ModelAnaconda;
import com.github.alexthe666.alexsmobs.client.render.RenderAnaconda;
import com.github.alexthe666.alexsmobs.entity.EntityAnacondaPart;
import com.github.alexthe666.alexsmobs.entity.util.AnacondaPartIndex;
import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;

public class RenderAnacondaPart
extends LivingEntityRenderer<EntityAnacondaPart, AdvancedEntityModel<EntityAnacondaPart>> {
    private final ModelAnaconda<EntityAnacondaPart> neckModel = new ModelAnaconda(AnacondaPartIndex.NECK);
    private final ModelAnaconda<EntityAnacondaPart> bodyModel = new ModelAnaconda(AnacondaPartIndex.BODY);
    private final ModelAnaconda<EntityAnacondaPart> tailModel = new ModelAnaconda(AnacondaPartIndex.TAIL);

    public RenderAnacondaPart(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, new ModelAnaconda(AnacondaPartIndex.NECK), 0.3f);
    }

    protected void setupRotations(EntityAnacondaPart entity, PoseStack stack, float pitchIn, float yawIn, float partialTickTime, float scale) {
        String s;
        Pose pose;
        float newYaw = entity.yHeadRot;
        if (this.isShaking(entity)) {
            newYaw += (float)(Math.cos((double)entity.tickCount * 3.25) * Math.PI * (double)0.4f);
        }
        if ((pose = entity.getPose()) != Pose.SLEEPING) {
            stack.mulPose(Axis.YP.rotationDegrees(180.0f - newYaw));
            stack.mulPose(Axis.XP.rotationDegrees(entity.getXRot()));
        }
        if (entity.deathTime > 0) {
            float f = ((float)entity.deathTime + partialTickTime - 1.0f) / 20.0f * 1.6f;
            if ((f = Mth.sqrt((float)f)) > 1.0f) {
                f = 1.0f;
            }
            stack.mulPose(Axis.ZP.rotationDegrees(f * this.getFlipDegrees(entity)));
        } else if (entity.hasCustomName() && ("Dinnerbone".equals(s = ChatFormatting.stripFormatting((String)entity.getName().getString())) || "Grumm".equals(s))) {
            stack.translate(0.0, (double)(entity.getBbHeight() + 0.1f), 0.0);
            stack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        }
    }

    protected boolean shouldShowName(EntityAnacondaPart entity) {
        return super.shouldShowName((LivingEntity)entity) && (entity.shouldShowName() || entity.hasCustomName() && entity == this.entityRenderDispatcher.crosshairPickEntity);
    }

    protected void scale(EntityAnacondaPart entitylivingbaseIn, PoseStack matrixStackIn, float partialTickTime) {
        this.model = this.getModelForType(entitylivingbaseIn.getPartType());
        matrixStackIn.scale(entitylivingbaseIn.getScale(), entitylivingbaseIn.getScale(), entitylivingbaseIn.getScale());
    }

    private AdvancedEntityModel<EntityAnacondaPart> getModelForType(AnacondaPartIndex partType) {
        switch (partType) {
            case BODY: {
                return this.bodyModel;
            }
            case NECK: {
                return this.neckModel;
            }
            case TAIL: {
                return this.tailModel;
            }
        }
        return this.bodyModel;
    }

    public ResourceLocation getTextureLocation(EntityAnacondaPart entity) {
        return RenderAnaconda.getAnacondaTexture(entity.isYellow(), entity.isShedding());
    }
}

