/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.particle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class ParticleStaticSpark
extends Particle {
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{ResourceLocation.parse((String)"textures/particle/generic_0.png"), ResourceLocation.parse((String)"textures/particle/generic_1.png"), ResourceLocation.parse((String)"textures/particle/generic_2.png"), ResourceLocation.parse((String)"textures/particle/generic_3.png"), ResourceLocation.parse((String)"textures/particle/generic_4.png"), ResourceLocation.parse((String)"textures/particle/generic_5.png"), ResourceLocation.parse((String)"textures/particle/generic_6.png"), ResourceLocation.parse((String)"textures/particle/generic_7.png")};
    private int decrement = 1;
    private int textureIndex = 0;
    private float size;

    private ParticleStaticSpark(ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ) {
        super(world, x, y, z);
        this.setSize(1.0f, 1.0f);
        this.gravity = 0.0f;
        this.xd = motionX;
        this.yd = motionY;
        this.zd = motionZ;
        this.lifetime = 10 + this.random.nextInt(15);
        this.textureIndex = Mth.clamp((int)this.random.nextInt(8), (int)0, (int)7);
        this.decrement = this.textureIndex > 0 ? this.lifetime / this.textureIndex : this.lifetime;
        this.size = this.random.nextFloat() * 0.2f + 0.2f;
    }

    public void tick() {
        super.tick();
        this.xd *= 0.97;
        this.yd *= 0.97;
        this.zd *= 0.97;
        if (this.textureIndex > 0 && this.age % this.decrement == 0) {
            --this.textureIndex;
        }
        if (this.size > 0.2f) {
            this.size -= 0.015f;
        }
    }

    public void render(VertexConsumer vertexConsumer, Camera camera, float partialTick) {
        Quaternionf quaternion;
        Vec3 vec3 = camera.getPosition();
        float f = (float)(Mth.lerp((double)partialTick, (double)this.xo, (double)this.x) - vec3.x());
        float f1 = (float)(Mth.lerp((double)partialTick, (double)this.yo, (double)this.y) - vec3.y());
        float f2 = (float)(Mth.lerp((double)partialTick, (double)this.zo, (double)this.z) - vec3.z());
        if (this.roll == 0.0f) {
            quaternion = camera.rotation();
        } else {
            quaternion = new Quaternionf((Quaternionfc)camera.rotation());
            float f3 = Mth.lerp((float)partialTick, (float)this.oRoll, (float)this.roll);
            quaternion.mul((Quaternionfc)Axis.ZP.rotation(f3));
        }
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.getInstance().renderBuffers().bufferSource();
        VertexConsumer portalStatic = multibuffersource$buffersource.getBuffer(RenderType.entityTranslucentEmissive((ResourceLocation)TEXTURES[this.textureIndex]));
        PoseStack posestack = new PoseStack();
        PoseStack.Pose posestack$pose = posestack.last();
        Matrix3f matrix3f = posestack$pose.normal();
        Vector3f vector3f1 = new Vector3f(-1.0f, -1.0f, 0.0f);
        vector3f1.rotate((Quaternionfc)quaternion);
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f4 = this.size;
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.rotate((Quaternionfc)quaternion);
            vector3f.mul(f4);
            vector3f.add(f, f1, f2);
        }
        float f7 = 0.0f;
        float f8 = 1.0f;
        float f5 = 0.0f;
        float f6 = 1.0f;
        int j = 240;
        portalStatic.addVertex(avector3f[0].x(), avector3f[0].y(), avector3f[0].z()).setColor((int)(this.rCol * 255.0f), (int)(this.gCol * 255.0f), (int)(this.bCol * 255.0f), (int)(this.alpha * 255.0f)).setUv(f8, f6).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(j & 0xFFFF, j >> 16).setNormal(posestack$pose, -1.0f, 0.0f, 0.0f);
        portalStatic.addVertex(avector3f[1].x(), avector3f[1].y(), avector3f[1].z()).setColor((int)(this.rCol * 255.0f), (int)(this.gCol * 255.0f), (int)(this.bCol * 255.0f), (int)(this.alpha * 255.0f)).setUv(f8, f5).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(j & 0xFFFF, j >> 16).setNormal(posestack$pose, -1.0f, 0.0f, 0.0f);
        portalStatic.addVertex(avector3f[2].x(), avector3f[2].y(), avector3f[2].z()).setColor((int)(this.rCol * 255.0f), (int)(this.gCol * 255.0f), (int)(this.bCol * 255.0f), (int)(this.alpha * 255.0f)).setUv(f7, f5).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(j & 0xFFFF, j >> 16).setNormal(posestack$pose, -1.0f, 0.0f, 0.0f);
        portalStatic.addVertex(avector3f[3].x(), avector3f[3].y(), avector3f[3].z()).setColor((int)(this.rCol * 255.0f), (int)(this.gCol * 255.0f), (int)(this.bCol * 255.0f), (int)(this.alpha * 255.0f)).setUv(f7, f6).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(j & 0xFFFF, j >> 16).setNormal(posestack$pose, -1.0f, 0.0f, 0.0f);
        multibuffersource$buffersource.endBatch();
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.CUSTOM;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new ParticleStaticSpark(worldIn, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }
}

