/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.model.layered;

import com.github.alexthe666.alexsmobs.entity.util.Maths;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModelFrontierCap
extends HumanoidModel {
    public ModelPart tail;
    public ModelPart hat;

    public ModelFrontierCap(ModelPart p_170677_) {
        super(p_170677_);
        this.hat = p_170677_.getChild("head").getChild("frontierhat");
        this.tail = this.hat.getChild("tail");
    }

    public static LayerDefinition createArmorLayer(CubeDeformation deformation) {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)deformation, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.getChild("head");
        PartDefinition front = head.addOrReplaceChild("frontierhat", CubeListBuilder.create().texOffs(32, 32).addBox(-4.0f, -10.5f, -4.0f, 8.0f, 4.0f, 8.0f, deformation), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        front.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(36, 46).addBox(-1.5f, -0.3f, -1.5f, 3.0f, 13.0f, 3.0f, deformation), PartPose.offsetAndRotation((float)4.4f, (float)-7.5f, (float)4.5f, (float)0.19565141f, (float)-0.039095376f, (float)-0.11728612f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public ModelFrontierCap withAnimations(LivingEntity entity) {
        if (entity != null) {
            float partialTick = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
            float limbSwingAmount = entity.walkAnimation.speed(partialTick);
            float limbSwing = entity.walkAnimation.position() + partialTick;
            this.tail.xRot = 0.19565141f + limbSwingAmount * Maths.rad(80.0) + Mth.cos((float)(limbSwing * 0.3f)) * 0.2f * limbSwingAmount;
            this.tail.yRot = -0.039095376f + limbSwingAmount * Maths.rad(10.0) - Mth.cos((float)(limbSwing * 0.4f)) * 0.3f * limbSwingAmount;
            this.tail.zRot = -0.11728612f + limbSwingAmount * Maths.rad(10.0);
        }
        return this;
    }
}

