/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.event;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.ClientProxy;
import com.github.alexthe666.alexsmobs.client.model.ModelRockyChestplateRolling;
import com.github.alexthe666.alexsmobs.client.render.AMItemstackRenderer;
import com.github.alexthe666.alexsmobs.client.render.AMRenderTypes;
import com.github.alexthe666.alexsmobs.client.render.RenderVineLasso;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.effect.AMEffectRegistry;
import com.github.alexthe666.alexsmobs.effect.EffectClinging;
import com.github.alexthe666.alexsmobs.effect.EffectPowerDown;
import com.github.alexthe666.alexsmobs.entity.EntityBaldEagle;
import com.github.alexthe666.alexsmobs.entity.EntityBlueJay;
import com.github.alexthe666.alexsmobs.entity.EntityElephant;
import com.github.alexthe666.alexsmobs.entity.IFalconry;
import com.github.alexthe666.alexsmobs.entity.util.Maths;
import com.github.alexthe666.alexsmobs.entity.util.RockyChestplateUtil;
import com.github.alexthe666.alexsmobs.entity.util.VineLassoUtil;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.item.ItemDimensionalCarver;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.github.alexthe666.alexsmobs.network.MessageUpdateEagleControls;
import com.github.alexthe666.citadel.client.event.EventGetFluidRenderType;
import com.github.alexthe666.citadel.client.event.EventGetOutlineColor;
import com.github.alexthe666.citadel.client.event.EventGetStarBrightness;
import com.github.alexthe666.citadel.client.event.EventPosePlayerHand;
import com.google.common.base.MoreObjects;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.LiquidBlockRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.EntityHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.RenderHandEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.RenderLivingEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.TriState;

@OnlyIn(value=Dist.CLIENT)
public class ClientEvents {
    private static final ResourceLocation ROCKY_CHESTPLATE_TEXTURE = ResourceLocation.parse((String)"alexsmobs:textures/armor/rocky_chestplate.png");
    private static final ModelRockyChestplateRolling ROCKY_CHESTPLATE_MODEL = new ModelRockyChestplateRolling();
    private boolean previousLavaVision = false;
    private LiquidBlockRenderer previousFluidRenderer;
    public long lastStaticTick = -1L;
    public static int renderStaticScreenFor = 0;

    @SubscribeEvent
    public void onOutlineEntityColor(EventGetOutlineColor event) {
        EntityBlueJay jay;
        Entity entity;
        if (event.getEntityIn() instanceof Enemy && AlexsMobs.PROXY.getSingingBlueJayId() != -1 && (entity = event.getEntityIn().level().getEntity(AlexsMobs.PROXY.getSingingBlueJayId())) instanceof EntityBlueJay && (jay = (EntityBlueJay)entity).isAlive() && jay.isMakingMonstersBlue()) {
            event.setColor(4953598);
            event.setResult(TriState.TRUE);
        }
        if (event.getEntityIn() instanceof ItemEntity && ((ItemEntity)event.getEntityIn()).getItem().is(AMTagRegistry.VOID_WORM_DROPS)) {
            int fromColor = 0;
            int toColor = 2221567;
            float startR = (float)(fromColor >> 16 & 0xFF) / 255.0f;
            float startG = (float)(fromColor >> 8 & 0xFF) / 255.0f;
            float startB = (float)(fromColor & 0xFF) / 255.0f;
            float endR = (float)(toColor >> 16 & 0xFF) / 255.0f;
            float endG = (float)(toColor >> 8 & 0xFF) / 255.0f;
            float endB = (float)(toColor & 0xFF) / 255.0f;
            float f = (float)(Math.cos(0.4f * ((float)event.getEntityIn().tickCount + Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true))) + 1.0) * 0.5f;
            float r = (endR - startR) * f + startR;
            float g = (endG - startG) * f + startG;
            float b = (endB - startB) * f + startB;
            int j = ((int)(r * 255.0f) & 0xFF) << 16 | ((int)(g * 255.0f) & 0xFF) << 8 | ((int)(b * 255.0f) & 0xFF) << 0;
            event.setColor(j);
            event.setResult(TriState.TRUE);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onGetStarBrightness(EventGetStarBrightness event) {
        if (Minecraft.getInstance().player.hasEffect(AMEffectRegistry.POWER_DOWN) && Minecraft.getInstance().player.getEffect(AMEffectRegistry.POWER_DOWN) != null) {
            MobEffectInstance instance = Minecraft.getInstance().player.getEffect(AMEffectRegistry.POWER_DOWN);
            EffectPowerDown powerDown = (EffectPowerDown)instance.getEffect();
            int duration = instance.getDuration();
            float partialTicks = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
            float f = ((float)Math.min(powerDown.getActiveTime(), duration) + partialTicks) * 0.1f;
            event.setBrightness(0.0f);
            event.setResult(TriState.TRUE);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onFogColor(ViewportEvent.ComputeFogColor event) {
        if (Minecraft.getInstance().player.hasEffect(AMEffectRegistry.POWER_DOWN) && Minecraft.getInstance().player.getEffect(AMEffectRegistry.POWER_DOWN) != null) {
            event.setBlue(0.0f);
            event.setRed(0.0f);
            event.setGreen(0.0f);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    @OnlyIn(value=Dist.CLIENT)
    public void onFogDensity(ViewportEvent.RenderFog event) {
        FogType fogType = event.getCamera().getFluidInCamera();
        if (Minecraft.getInstance().player.hasEffect(AMEffectRegistry.LAVA_VISION) && fogType == FogType.LAVA) {
            event.setNearPlaneDistance(-8.0f);
            event.setFarPlaneDistance(50.0f);
            event.setCanceled(true);
        }
        if (Minecraft.getInstance().player.hasEffect(AMEffectRegistry.POWER_DOWN) && fogType == FogType.NONE && Minecraft.getInstance().player.getEffect(AMEffectRegistry.POWER_DOWN) != null) {
            float initEnd = event.getFarPlaneDistance();
            MobEffectInstance instance = Minecraft.getInstance().player.getEffect(AMEffectRegistry.POWER_DOWN);
            EffectPowerDown powerDown = (EffectPowerDown)instance.getEffect();
            int duration = instance.getDuration();
            float partialTicks = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
            float f = Math.min(20.0f, Math.min((float)powerDown.getActiveTime() + partialTicks, (float)duration + partialTicks)) * 0.05f;
            event.setNearPlaneDistance(-8.0f);
            float f1 = 8.0f + (1.0f - f) * Math.max(0.0f, initEnd - 8.0f);
            event.setFarPlaneDistance(f1);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onPreRenderEntity(RenderLivingEvent.Pre event) {
        if (RockyChestplateUtil.isRockyRolling(event.getEntity())) {
            event.setCanceled(true);
            event.getPoseStack().pushPose();
            float limbSwing = event.getEntity().walkAnimation.position() - event.getEntity().walkAnimation.speed() * (1.0f - event.getPartialTick());
            float limbSwingAmount = event.getEntity().walkAnimation.speed((float)event.getPackedLight());
            float yRot = event.getEntity().yBodyRotO + (event.getEntity().yBodyRot - event.getEntity().yBodyRotO) * event.getPartialTick();
            float roll = event.getEntity().walkDistO + (event.getEntity().walkDist - event.getEntity().walkDistO) * event.getPartialTick();
            VertexConsumer vertexconsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)event.getMultiBufferSource(), (RenderType)RenderType.armorCutoutNoCull((ResourceLocation)ROCKY_CHESTPLATE_TEXTURE), (boolean)event.getEntity().getItemBySlot(EquipmentSlot.CHEST).hasFoil());
            event.getPoseStack().translate(0.0, (double)(event.getEntity().getBbHeight() - event.getEntity().getBbHeight() * 0.5f), 0.0);
            event.getPoseStack().mulPose(Axis.YN.rotationDegrees(180.0f + yRot));
            event.getPoseStack().mulPose(Axis.ZP.rotationDegrees(180.0f));
            event.getPoseStack().mulPose(Axis.XP.rotationDegrees(100.0f * roll));
            ROCKY_CHESTPLATE_MODEL.setupAnim(event.getEntity(), limbSwing, limbSwingAmount, (float)event.getEntity().tickCount + event.getPartialTick(), 0.0f, 0.0f);
            ROCKY_CHESTPLATE_MODEL.renderToBuffer(event.getPoseStack(), vertexconsumer, event.getPackedLight(), OverlayTexture.NO_OVERLAY);
            event.getPoseStack().popPose();
            NeoForge.EVENT_BUS.post((Event)new RenderLivingEvent.Post(event.getEntity(), event.getRenderer(), event.getPartialTick(), event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight()));
            return;
        }
        if (!(event.getEntity() instanceof WanderingTrader) || event.getEntity().getType() != EntityType.WANDERING_TRADER || event.getEntity().getVehicle() instanceof EntityElephant) {
            // empty if block
        }
        if (event.getEntity().hasEffect(AMEffectRegistry.CLINGING) && EffectClinging.isUpsideDown(event.getEntity()) || event.getEntity().hasEffect(AMEffectRegistry.DEBILITATING_STING) && event.getEntity().getTags().contains("arthropod") && event.getEntity().getBbWidth() > event.getEntity().getBbHeight()) {
            event.getPoseStack().pushPose();
            event.getPoseStack().translate(0.0, (double)(event.getEntity().getBbHeight() + 0.1f), 0.0);
            event.getPoseStack().mulPose(Axis.ZP.rotationDegrees(180.0f));
            event.getEntity().yBodyRotO = -event.getEntity().yBodyRotO;
            event.getEntity().yBodyRot = -event.getEntity().yBodyRot;
            event.getEntity().yHeadRotO = -event.getEntity().yHeadRotO;
            event.getEntity().yHeadRot = -event.getEntity().yHeadRot;
        }
        if (event.getEntity().hasEffect(AMEffectRegistry.ENDER_FLU)) {
            event.getPoseStack().pushPose();
            event.getPoseStack().mulPose(Axis.YP.rotationDegrees((float)(Math.cos((double)event.getEntity().tickCount * 7.0) * Math.PI * (double)1.2f)));
            float vibrate = 0.05f;
            event.getPoseStack().translate((event.getEntity().getRandom().nextFloat() - 0.5f) * vibrate, (event.getEntity().getRandom().nextFloat() - 0.5f) * vibrate, (event.getEntity().getRandom().nextFloat() - 0.5f) * vibrate);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onPostRenderEntity(RenderLivingEvent.Post event) {
        Entity lassoedOwner;
        if (RockyChestplateUtil.isRockyRolling(event.getEntity())) {
            return;
        }
        if (event.getEntity().hasEffect(AMEffectRegistry.ENDER_FLU)) {
            event.getPoseStack().popPose();
        }
        if (event.getEntity().hasEffect(AMEffectRegistry.CLINGING) && EffectClinging.isUpsideDown(event.getEntity()) || event.getEntity().hasEffect(AMEffectRegistry.DEBILITATING_STING) && event.getEntity().getTags().contains("arthropod") && event.getEntity().getBbWidth() > event.getEntity().getBbHeight()) {
            event.getPoseStack().popPose();
            event.getEntity().yBodyRotO = -event.getEntity().yBodyRotO;
            event.getEntity().yBodyRot = -event.getEntity().yBodyRot;
            event.getEntity().yHeadRotO = -event.getEntity().yHeadRotO;
            event.getEntity().yHeadRot = -event.getEntity().yHeadRot;
        }
        if (VineLassoUtil.hasLassoData(event.getEntity()) && !(event.getEntity() instanceof Player) && (lassoedOwner = VineLassoUtil.getLassoedTo(event.getEntity())) instanceof LivingEntity && lassoedOwner != event.getEntity()) {
            double d0 = Mth.lerp((double)event.getPartialTick(), (double)event.getEntity().xOld, (double)event.getEntity().getX());
            double d1 = Mth.lerp((double)event.getPartialTick(), (double)event.getEntity().yOld, (double)event.getEntity().getY());
            double d2 = Mth.lerp((double)event.getPartialTick(), (double)event.getEntity().zOld, (double)event.getEntity().getZ());
            event.getPoseStack().pushPose();
            event.getPoseStack().translate(-d0, -d1, -d2);
            RenderVineLasso.renderVine((Entity)event.getEntity(), event.getPartialTick(), event.getPoseStack(), event.getMultiBufferSource(), (LivingEntity)lassoedOwner, ((LivingEntity)lassoedOwner).getMainArm() == HumanoidArm.LEFT, 0.1f);
            event.getPoseStack().popPose();
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onPoseHand(EventPosePlayerHand event) {
        boolean usingLasso;
        LivingEntity player = (LivingEntity)event.getEntityIn();
        float f = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
        boolean leftHand = false;
        boolean bl = usingLasso = player.isUsingItem() && player.getUseItem().is((Item)AMItemRegistry.VINE_LASSO.get());
        if (player.getItemInHand(InteractionHand.MAIN_HAND).getItem() == AMItemRegistry.VINE_LASSO.get()) {
            leftHand = player.getMainArm() == HumanoidArm.LEFT;
        } else if (player.getItemInHand(InteractionHand.OFF_HAND).getItem() == AMItemRegistry.VINE_LASSO.get()) {
            boolean bl2 = leftHand = player.getMainArm() != HumanoidArm.LEFT;
        }
        if (leftHand && event.isLeftHand() && usingLasso) {
            event.setResult(TriState.TRUE);
            event.getModel().leftArm.xRot = Maths.rad(-120.0) + Mth.sin((float)((float)player.tickCount + f)) * 0.5f;
            event.getModel().leftArm.yRot = Maths.rad(-20.0) + Mth.cos((float)((float)player.tickCount + f)) * 0.5f;
        }
        if (!leftHand && !event.isLeftHand() && usingLasso) {
            event.setResult(TriState.TRUE);
            event.getModel().rightArm.xRot = Maths.rad(-120.0) + Mth.sin((float)((float)player.tickCount + f)) * 0.5f;
            event.getModel().rightArm.yRot = Maths.rad(20.0) - Mth.cos((float)((float)player.tickCount + f)) * 0.5f;
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onRenderHand(RenderHandEvent event) {
        if (Minecraft.getInstance().getCameraEntity() instanceof IFalconry) {
            event.setCanceled(true);
        }
        if (!Minecraft.getInstance().player.getPassengers().isEmpty() && event.getHand() == InteractionHand.MAIN_HAND) {
            LocalPlayer player = Minecraft.getInstance().player;
            boolean leftHand = false;
            if (player.getItemInHand(InteractionHand.MAIN_HAND).getItem() == AMItemRegistry.FALCONRY_GLOVE.get()) {
                leftHand = player.getMainArm() == HumanoidArm.LEFT;
            } else if (player.getItemInHand(InteractionHand.OFF_HAND).getItem() == AMItemRegistry.FALCONRY_GLOVE.get()) {
                leftHand = player.getMainArm() != HumanoidArm.LEFT;
            }
            for (Entity entity : player.getPassengers()) {
                if (!(entity instanceof IFalconry)) continue;
                IFalconry falconry = (IFalconry)entity;
                float yaw = player.yBodyRotO + (player.yBodyRot - player.yBodyRotO) * event.getPartialTick();
                ClientProxy.currentUnrenderedEntities.remove(entity.getUUID());
                PoseStack matrixStackIn = event.getPoseStack();
                matrixStackIn.pushPose();
                matrixStackIn.scale(0.5f, 0.5f, 0.5f);
                matrixStackIn.translate(leftHand ? -falconry.getHandOffset() : falconry.getHandOffset(), -0.6f, -1.0f);
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(yaw));
                if (leftHand) {
                    matrixStackIn.mulPose(Axis.YP.rotationDegrees(90.0f));
                } else {
                    matrixStackIn.mulPose(Axis.YN.rotationDegrees(90.0f));
                }
                this.renderEntity(entity, 0.0, 0.0, 0.0, 0.0f, event.getPartialTick(), matrixStackIn, event.getMultiBufferSource(), event.getPackedLight());
                matrixStackIn.popPose();
                ClientProxy.currentUnrenderedEntities.add(entity.getUUID());
            }
        }
        if (Minecraft.getInstance().player.getUseItem().getItem() instanceof ItemDimensionalCarver && event.getItemStack().getItem() instanceof ItemDimensionalCarver) {
            PoseStack matrixStackIn = event.getPoseStack();
            matrixStackIn.pushPose();
            ItemInHandRenderer renderer = Minecraft.getInstance().getEntityRenderDispatcher().getItemInHandRenderer();
            InteractionHand hand = (InteractionHand)MoreObjects.firstNonNull((Object)Minecraft.getInstance().player.swingingArm, (Object)InteractionHand.MAIN_HAND);
            float f = Minecraft.getInstance().player.getAttackAnim(event.getPartialTick());
            float f5 = -0.4f * Mth.sin((float)(Mth.sqrt((float)f) * (float)Math.PI));
            float f6 = 0.2f * Mth.sin((float)(Mth.sqrt((float)f) * ((float)Math.PI * 2)));
            float f10 = -0.2f * Mth.sin((float)(f * (float)Math.PI));
            HumanoidArm handside = hand == InteractionHand.MAIN_HAND ? Minecraft.getInstance().player.getMainArm() : Minecraft.getInstance().player.getMainArm().getOpposite();
            boolean flag3 = handside == HumanoidArm.RIGHT;
            int l = flag3 ? 1 : -1;
            matrixStackIn.translate((float)l * f5, f6, f10);
        }
    }

    public <E extends Entity> void renderEntity(E entityIn, double x, double y, double z, float yaw, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int packedLight) {
        block4: {
            EntityRenderer render = null;
            EntityRenderDispatcher manager = Minecraft.getInstance().getEntityRenderDispatcher();
            try {
                render = manager.getRenderer(entityIn);
                if (render == null) break block4;
                try {
                    render.render(entityIn, yaw, partialTicks, matrixStack, bufferIn, packedLight);
                }
                catch (Throwable throwable1) {
                    throw new ReportedException(CrashReport.forThrowable((Throwable)throwable1, (String)"Rendering entity in world"));
                }
            }
            catch (Throwable throwable3) {
                CrashReport crashreport = CrashReport.forThrowable((Throwable)throwable3, (String)"Rendering entity in world");
                CrashReportCategory crashreportcategory = crashreport.addCategory("Entity being rendered");
                entityIn.fillCrashReportCategory(crashreportcategory);
                CrashReportCategory crashreportcategory1 = crashreport.addCategory("Renderer details");
                crashreportcategory1.setDetail("Assigned renderer", (Object)render);
                crashreportcategory1.setDetail("Rotation", (Object)Float.valueOf(yaw));
                crashreportcategory1.setDetail("Delta", (Object)Float.valueOf(partialTicks));
                throw new ReportedException(crashreport);
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onRenderWorldLastEvent(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_SKY) {
            if (!AMConfig.shadersCompat) {
                if (Minecraft.getInstance().player.hasEffect(AMEffectRegistry.LAVA_VISION)) {
                    if (!this.previousLavaVision) {
                        this.updateAllChunks();
                    }
                } else if (this.previousLavaVision) {
                    this.updateAllChunks();
                }
                this.previousLavaVision = Minecraft.getInstance().player.hasEffect(AMEffectRegistry.LAVA_VISION);
            }
            if (Minecraft.getInstance().getCameraEntity() instanceof EntityBaldEagle) {
                EntityBaldEagle eagle = (EntityBaldEagle)Minecraft.getInstance().getCameraEntity();
                LocalPlayer playerEntity = Minecraft.getInstance().player;
                if (((EntityBaldEagle)Minecraft.getInstance().getCameraEntity()).shouldHoodedReturn() || eagle.isRemoved()) {
                    Minecraft.getInstance().setCameraEntity((Entity)playerEntity);
                    Minecraft.getInstance().options.setCameraType(CameraType.values()[AlexsMobs.PROXY.getPreviousPOV()]);
                } else {
                    float rotX = Mth.wrapDegrees((float)(playerEntity.getYRot() + playerEntity.yHeadRot));
                    float rotY = playerEntity.getXRot();
                    Entity over = null;
                    if (Minecraft.getInstance().hitResult instanceof EntityHitResult) {
                        over = ((EntityHitResult)Minecraft.getInstance().hitResult).getEntity();
                    } else {
                        Minecraft.getInstance().hitResult = null;
                    }
                    boolean loadChunks = playerEntity.level().getDayTime() % 10L == 0L;
                    ((EntityBaldEagle)Minecraft.getInstance().getCameraEntity()).directFromPlayer(rotX, rotY, false, over);
                    AlexsMobs.sendMSGToServer(new MessageUpdateEagleControls(Minecraft.getInstance().getCameraEntity().getId(), rotX, rotY, loadChunks, over == null ? -1 : over.getId()));
                }
            }
        }
    }

    private void updateAllChunks() {
        Minecraft.getInstance().levelRenderer.allChanged();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onGetFluidRenderType(EventGetFluidRenderType event) {
        if (Minecraft.getInstance().player.hasEffect(AMEffectRegistry.LAVA_VISION) && (event.getFluidState().is((Fluid)Fluids.LAVA) || event.getFluidState().is((Fluid)Fluids.FLOWING_LAVA))) {
            event.setRenderType(RenderType.translucent());
            event.setResult(TriState.TRUE);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientTick(ClientTickEvent.Pre event) {
        AMItemstackRenderer.incrementTick();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onCameraSetup(ViewportEvent.ComputeCameraAngles event) {
        if (Minecraft.getInstance().player != null && Minecraft.getInstance().player.getEffect(AMEffectRegistry.EARTHQUAKE) != null && !Minecraft.getInstance().isPaused()) {
            int duration = Minecraft.getInstance().player.getEffect(AMEffectRegistry.EARTHQUAKE).getDuration();
            float f = ((float)Math.min(10, duration) + Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true)) * 0.1f;
            double intensity = (double)f * (Double)Minecraft.getInstance().options.screenEffectScale().get();
            RandomSource rng = Minecraft.getInstance().player.getRandom();
            float shakeX = (float)((double)(rng.nextFloat() * 0.5f) * intensity);
            float shakeY = (float)((double)(rng.nextFloat() * 1.0f) * intensity);
            event.setRoll(event.getRoll() + shakeX);
            event.setPitch(event.getPitch() + shakeY);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onPostGameOverlay(RenderGuiLayerEvent.Post event) {
        if (renderStaticScreenFor > 0) {
            if (Minecraft.getInstance().player.isAlive() && this.lastStaticTick != Minecraft.getInstance().level.getGameTime()) {
                --renderStaticScreenFor;
            }
            float staticLevel = (float)renderStaticScreenFor / 60.0f;
            if (event.getName().equals((Object)VanillaGuiLayers.CAMERA_OVERLAYS)) {
                float screenWidth = event.getGuiGraphics().guiWidth();
                float screenHeight = event.getGuiGraphics().guiHeight();
                RenderSystem.disableDepthTest();
                RenderSystem.depthMask((boolean)false);
                float ageInTicks = (float)Minecraft.getInstance().level.getGameTime() + Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
                float staticIndexX = (float)Math.sin(ageInTicks * 0.2f) * 2.0f;
                float staticIndexY = (float)Math.cos(ageInTicks * 0.2f + 3.0f) * 2.0f;
                RenderSystem.defaultBlendFunc();
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)staticLevel);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)AMRenderTypes.STATIC_TEXTURE);
                Tesselator tesselator = Tesselator.getInstance();
                BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                float minU = 10.0f * staticIndexX * 0.125f;
                float maxU = 10.0f * (0.5f + staticIndexX * 0.125f);
                float minV = 10.0f * staticIndexY * 0.125f;
                float maxV = 10.0f * (0.125f + staticIndexY * 0.125f);
                bufferbuilder.addVertex(0.0f, screenHeight, -190.0f).setUv(minU, maxV);
                bufferbuilder.addVertex(screenWidth, screenHeight, -190.0f).setUv(maxU, maxV);
                bufferbuilder.addVertex(screenWidth, 0.0f, -190.0f).setUv(maxU, minV);
                bufferbuilder.addVertex(0.0f, 0.0f, -190.0f).setUv(minU, minV);
                BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
                RenderSystem.depthMask((boolean)true);
                RenderSystem.enableDepthTest();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            this.lastStaticTick = Minecraft.getInstance().level.getGameTime();
        }
    }
}

