/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockVoidWormEffigy
extends Block {
    public static final MapCodec<BlockVoidWormEffigy> CODEC = BlockVoidWormEffigy.simpleCodec(props -> new BlockVoidWormEffigy());
    public static final DirectionProperty FACING = DirectionalBlock.FACING;
    private static final VoxelShape UP_SHAPE = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0), (VoxelShape)Block.box((double)4.0, (double)6.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0));
    private static final VoxelShape DOWN_SHAPE = Shapes.or((VoxelShape)Block.box((double)0.0, (double)9.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0));
    private static final VoxelShape SOUTH_SHAPE = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)7.0), (VoxelShape)Block.box((double)4.0, (double)4.0, (double)6.0, (double)12.0, (double)12.0, (double)16.0));
    private static final VoxelShape NORTH_SHAPE = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)10.0));
    private static final VoxelShape EAST_SHAPE = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)6.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0));
    private static final VoxelShape WEST_SHAPE = Shapes.or((VoxelShape)Block.box((double)9.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)4.0, (double)4.0, (double)10.0, (double)12.0, (double)12.0));

    public BlockVoidWormEffigy() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PINK).requiresCorrectToolForDrops().strength(1.5f));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public MapCodec<? extends Block> codec() {
        return CODEC;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getClickedFace());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public VoxelShape getShape(BlockState p_54561_, BlockGetter p_54562_, BlockPos p_54563_, CollisionContext p_54564_) {
        return switch ((Direction)p_54561_.getValue((Property)FACING)) {
            case Direction.NORTH -> NORTH_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.EAST -> EAST_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            case Direction.UP -> UP_SHAPE;
            default -> DOWN_SHAPE;
        };
    }
}

