/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.block;

import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityTriops;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.FrogspawnBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;

public class BlockTriopsEggs
extends FrogspawnBlock {
    public static final MapCodec<FrogspawnBlock> CODEC = FrogspawnBlock.CODEC;

    public BlockTriopsEggs() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).instabreak().noOcclusion().noCollission().sound(SoundType.FROGSPAWN).offsetType(BlockBehaviour.OffsetType.XZ));
    }

    public MapCodec<FrogspawnBlock> codec() {
        return CODEC;
    }

    public void tick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        if (!this.canSurvive(blockState, (LevelReader)serverLevel, blockPos)) {
            serverLevel.destroyBlock(blockPos, false);
        } else if (serverLevel.getFluidState(blockPos.below()).is(FluidTags.WATER)) {
            serverLevel.destroyBlock(blockPos, false);
            int i = 2 + randomSource.nextInt(2);
            for (int j = 1; j <= i; ++j) {
                EntityTriops tadpole = (EntityTriops)((EntityType)AMEntityRegistry.TRIOPS.get()).create((Level)serverLevel);
                if (tadpole == null) continue;
                double d0 = blockPos.getX();
                double d1 = blockPos.getZ();
                int k = randomSource.nextInt(1, 361);
                tadpole.moveTo(d0, (double)blockPos.getY() - 0.5, d1, k, 0.0f);
                tadpole.setPersistenceRequired();
                tadpole.setBabyAge(-12000);
                serverLevel.addFreshEntity((Entity)tadpole);
            }
        }
    }
}

