/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.block;

import com.github.alexthe666.alexsmobs.block.AMBlockRegistry;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityTerrapin;
import com.github.alexthe666.alexsmobs.entity.util.TerrapinTypes;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.github.alexthe666.alexsmobs.tileentity.TileEntityTerrapinEgg;
import com.mojang.serialization.MapCodec;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockTerrapinEgg
extends BaseEntityBlock {
    public static final MapCodec<BlockTerrapinEgg> CODEC = BlockTerrapinEgg.simpleCodec(props -> new BlockTerrapinEgg());
    public static final IntegerProperty HATCH = BlockStateProperties.HATCH;
    public static final IntegerProperty EGGS = BlockStateProperties.EGGS;
    private static final VoxelShape ONE_EGG_SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)12.0, (double)7.0, (double)12.0);
    private static final VoxelShape MULTI_EGG_SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0);

    public BlockTerrapinEgg() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.SAND).strength(0.5f).sound(SoundType.METAL).randomTicks().noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HATCH, (Comparable)Integer.valueOf(0))).setValue((Property)EGGS, (Comparable)Integer.valueOf(1)));
    }

    public MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public static boolean hasProperHabitat(BlockGetter reader, BlockPos blockReader) {
        return BlockTerrapinEgg.isProperHabitat(reader, blockReader.below());
    }

    public RenderShape getRenderShape(BlockState p_149645_1_) {
        return RenderShape.MODEL;
    }

    public static boolean isProperHabitat(BlockGetter reader, BlockPos pos) {
        return reader.getBlockState(pos).is(BlockTags.SAND) || reader.getBlockState(pos).is(AMTagRegistry.CROCODILE_SPAWNS);
    }

    public void stepOn(Level worldIn, BlockPos pos, BlockState state, Entity entityIn) {
        this.tryTrample(worldIn, pos, entityIn, 100);
        super.stepOn(worldIn, pos, state, entityIn);
    }

    public void fallOn(Level worldIn, BlockState state, BlockPos pos, Entity entityIn, float fallDistance) {
        if (!(entityIn instanceof Zombie)) {
            this.tryTrample(worldIn, pos, entityIn, 3);
        }
        super.fallOn(worldIn, state, pos, entityIn, fallDistance);
    }

    private void tryTrample(Level worldIn, BlockPos pos, Entity trampler, int chances) {
        if (this.canTrample(worldIn, trampler) && !worldIn.isClientSide && worldIn.random.nextInt(chances) == 0) {
            BlockState blockstate = worldIn.getBlockState(pos);
            this.removeOneEgg(worldIn, pos, blockstate);
        }
    }

    private void removeOneEgg(Level worldIn, BlockPos pos, BlockState state) {
        worldIn.playSound(null, pos, SoundEvents.TURTLE_EGG_BREAK, SoundSource.BLOCKS, 0.7f, 0.9f + worldIn.random.nextFloat() * 0.2f);
        int i = (Integer)state.getValue((Property)EGGS);
        if (i <= 1) {
            worldIn.destroyBlock(pos, false);
        } else {
            worldIn.setBlock(pos, (BlockState)state.setValue((Property)EGGS, (Comparable)Integer.valueOf(i - 1)), 2);
            worldIn.gameEvent((Holder)GameEvent.BLOCK_DESTROY, pos, GameEvent.Context.of((BlockState)state));
            worldIn.levelEvent(2001, pos, Block.getId((BlockState)state));
        }
    }

    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        if (this.canGrow((Level)worldIn) && BlockTerrapinEgg.hasProperHabitat((BlockGetter)worldIn, pos)) {
            int i = (Integer)state.getValue((Property)HATCH);
            if (i < 2) {
                worldIn.playSound(null, pos, SoundEvents.TURTLE_EGG_CRACK, SoundSource.BLOCKS, 0.7f, 0.9f + random.nextFloat() * 0.2f);
                worldIn.gameEvent((Holder)GameEvent.BLOCK_DESTROY, pos, GameEvent.Context.of((BlockState)state));
                worldIn.setBlock(pos, (BlockState)state.setValue((Property)HATCH, (Comparable)Integer.valueOf(i + 1)), 2);
            } else {
                worldIn.playSound(null, pos, SoundEvents.TURTLE_EGG_HATCH, SoundSource.BLOCKS, 0.7f, 0.9f + random.nextFloat() * 0.2f);
                worldIn.gameEvent((Holder)GameEvent.BLOCK_DESTROY, pos, GameEvent.Context.of((BlockState)state));
                worldIn.removeBlock(pos, false);
                for (int j = 0; j < (Integer)state.getValue((Property)EGGS); ++j) {
                    worldIn.levelEvent(2001, pos, Block.getId((BlockState)state));
                    EntityTerrapin turtleentity = (EntityTerrapin)((EntityType)AMEntityRegistry.TERRAPIN.get()).create((Level)worldIn);
                    turtleentity.setAge(-24000);
                    BlockEntity blockEntity = worldIn.getBlockEntity(pos);
                    if (blockEntity instanceof TileEntityTerrapinEgg) {
                        TileEntityTerrapinEgg eggTE = (TileEntityTerrapinEgg)blockEntity;
                        eggTE.addAttributesToOffspring(turtleentity, random);
                    }
                    turtleentity.setFromBucket(true);
                    turtleentity.moveTo((double)pos.getX() + 0.3 + (double)j * 0.2, pos.getY(), (double)pos.getZ() + 0.3, 0.0f, 0.0f);
                    worldIn.addFreshEntity((Entity)turtleentity);
                }
            }
        }
    }

    public void onPlace(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (BlockTerrapinEgg.hasProperHabitat((BlockGetter)worldIn, pos) && !worldIn.isClientSide) {
            worldIn.levelEvent(2005, pos, 0);
        }
    }

    private boolean canGrow(Level worldIn) {
        float f = worldIn.getTimeOfDay(1.0f);
        if ((double)f < 0.69 && (double)f > 0.65) {
            return true;
        }
        return worldIn.random.nextInt(15) == 0;
    }

    public void playerDestroy(Level worldIn, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        super.playerDestroy(worldIn, player, pos, state, te, stack);
        this.removeOneEgg(worldIn, pos, state);
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        return useContext.getItemInHand().getItem() == this.asItem() && (Integer)state.getValue((Property)EGGS) < 4 || super.canBeReplaced(state, useContext);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockstate = context.getLevel().getBlockState(context.getClickedPos());
        return blockstate.getBlock() == this ? (BlockState)blockstate.setValue((Property)EGGS, (Comparable)Integer.valueOf(Math.min(4, (Integer)blockstate.getValue((Property)EGGS) + 1))) : super.getStateForPlacement(context);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return (Integer)state.getValue((Property)EGGS) > 1 ? MULTI_EGG_SHAPE : ONE_EGG_SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HATCH, EGGS});
    }

    private boolean canTrample(Level worldIn, Entity trampler) {
        if (!(trampler instanceof EntityTerrapin) && !(trampler instanceof Bat)) {
            if (!(trampler instanceof LivingEntity)) {
                return false;
            }
            return trampler instanceof Player || worldIn.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING);
        }
        return false;
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        ItemStack pickaxe = (ItemStack)builder.getOptionalParameter(LootContextParams.TOOL);
        BlockEntity blockentity = (BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        boolean silkTouch = false;
        if (pickaxe != null) {
            silkTouch = false;
        }
        if (silkTouch && blockentity instanceof TileEntityTerrapinEgg) {
            ItemStack stack = new ItemStack((ItemLike)AMBlockRegistry.TERRAPIN_EGG.get());
            TileEntityTerrapinEgg egg = (TileEntityTerrapinEgg)blockentity;
            CompoundTag tag = new CompoundTag();
            CompoundTag parent1 = new CompoundTag();
            CompoundTag parent2 = new CompoundTag();
            boolean flag = false;
            if (egg.parent1 != null) {
                flag = true;
                egg.parent1.writeToNBT(parent1);
            }
            if (egg.parent2 != null) {
                flag = true;
                egg.parent2.writeToNBT(parent2);
            }
            if (flag) {
                tag.put("Parent1Data", (Tag)parent1);
                tag.put("Parent2Data", (Tag)parent2);
                stack.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)tag));
            }
            return List.of(stack);
        }
        return List.of();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flags) {
        super.appendHoverText(stack, context, list, flags);
        CompoundTag compoundtag = ((CustomData)stack.getOrDefault(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (compoundtag != null && compoundtag.contains("Parent1Data") && compoundtag.contains("Parent2Data")) {
            TerrapinTypes parent1Type = TerrapinTypes.values()[Mth.clamp((int)compoundtag.getCompound("Parent1Data").getInt("TerrapinType"), (int)0, (int)(TerrapinTypes.values().length - 1))];
            TerrapinTypes parent2Type = TerrapinTypes.values()[Mth.clamp((int)compoundtag.getCompound("Parent2Data").getInt("TerrapinType"), (int)0, (int)(TerrapinTypes.values().length - 1))];
            String s1 = Component.translatable((String)parent1Type.getTranslationName()).getString();
            String s2 = Component.translatable((String)parent2Type.getTranslationName()).getString();
            list.add((Component)Component.translatable((String)"block.alexsmobs.terrapin_egg.desc", (Object[])new Object[]{s1, s2}).withStyle(ChatFormatting.GRAY));
        }
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState state2, boolean b) {
        if (state.is((Block)AMBlockRegistry.TERRAPIN_EGG.get()) && (Integer)state.getValue((Property)EGGS) <= 1) {
            super.onRemove(state, level, pos, state2, b);
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TileEntityTerrapinEgg(pos, state);
    }
}

