/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.block;

import com.github.alexthe666.alexsmobs.block.AMBlockRegistry;
import com.github.alexthe666.alexsmobs.client.particle.AMParticleRegistry;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.MultifaceSpreader;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;

public class BlockSkunkSpray
extends MultifaceBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<BlockSkunkSpray> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockSkunkSpray.propertiesCodec()).apply((Applicative)instance, props -> new BlockSkunkSpray()));
    public static final IntegerProperty AGE = BlockStateProperties.AGE_3;
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public BlockSkunkSpray() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_GREEN).noOcclusion().randomTicks().noCollission().instabreak().sound(SoundType.FROGSPAWN));
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public MapCodec<BlockSkunkSpray> codec() {
        return CODEC;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState state2, LevelAccessor levelAccessor, BlockPos pos, BlockPos pos2) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)levelAccessor));
        }
        return super.updateShape(state, direction, state2, levelAccessor, pos, pos2);
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource) {
        this.tick(state, level, pos, randomSource);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (random.nextInt(8) == 0) {
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (Direction direction : Direction.values()) {
                blockpos$mutableblockpos.setWithOffset((Vec3i)pos, direction);
                BlockState blockstate = level.getBlockState((BlockPos)blockpos$mutableblockpos);
                if (!blockstate.is((Block)this) || this.incrementAge(blockstate, (Level)level, (BlockPos)blockpos$mutableblockpos)) continue;
                level.scheduleTick((BlockPos)blockpos$mutableblockpos, (Block)this, Mth.nextInt((RandomSource)random, (int)50, (int)100));
            }
            this.incrementAge(state, (Level)level, pos);
        } else {
            level.scheduleTick(pos, (Block)this, Mth.nextInt((RandomSource)random, (int)50, (int)100));
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> definition) {
        super.createBlockStateDefinition(definition);
        definition.add(new Property[]{WATERLOGGED, AGE});
    }

    public InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult hit) {
        Direction dir;
        ItemStack itemStack = player.getMainHandItem();
        int setContent = -1;
        if (itemStack.is(Items.GLASS_BOTTLE) && BlockSkunkSpray.hasFace((BlockState)state, (Direction)(dir = hit.getDirection().getOpposite()))) {
            worldIn.setBlockAndUpdate(pos, BlockSkunkSpray.removeStinkFace(state, dir));
            ItemStack bottle = new ItemStack((ItemLike)AMItemRegistry.STINK_BOTTLE.get());
            if (!player.addItem(bottle)) {
                player.drop(bottle, false);
            }
            if (!player.isCreative()) {
                itemStack.shrink(1);
            }
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, worldIn, pos, player, hit);
    }

    public static BlockState removeStinkFace(BlockState state, Direction faceProperty) {
        BlockState blockstate = (BlockState)state.setValue((Property)BlockSkunkSpray.getFaceProperty((Direction)faceProperty), (Comparable)Boolean.valueOf(false));
        return BlockSkunkSpray.hasAnyFace((BlockState)blockstate) ? blockstate : Blocks.AIR.defaultBlockState();
    }

    private boolean incrementAge(BlockState state, Level level, BlockPos pos) {
        int i = (Integer)state.getValue((Property)AGE);
        if (i < 3) {
            level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
            return false;
        }
        level.setBlock(pos, Blocks.AIR.defaultBlockState(), 2);
        return true;
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        return !context.getItemInHand().is(((Block)AMBlockRegistry.SKUNK_SPRAY.get()).asItem()) || super.canBeReplaced(state, context);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public MultifaceSpreader getSpreader() {
        return null;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return state.getFluidState().isEmpty();
    }

    public void animateTick(BlockState blockState, Level level, BlockPos pos, RandomSource randomSource) {
        if (randomSource.nextInt(2) == 0) {
            ArrayList faces = new ArrayList(BlockSkunkSpray.availableFaces((BlockState)blockState));
            Direction direction = null;
            if (faces.size() == 1) {
                direction = (Direction)faces.get(0);
            } else if (faces.size() > 1) {
                direction = (Direction)Util.getRandom(faces, (RandomSource)randomSource);
            }
            if (direction != null) {
                double d0 = direction.getStepX() == 0 ? randomSource.nextDouble() : 0.5 + (double)direction.getStepX() * 0.8;
                double d1 = direction.getStepY() == 0 ? randomSource.nextDouble() : 0.5 + (double)direction.getStepY() * 0.8;
                double d2 = direction.getStepZ() == 0 ? randomSource.nextDouble() : 0.5 + (double)direction.getStepZ() * 0.8;
                level.addParticle((ParticleOptions)AMParticleRegistry.SMELLY.get(), (double)pos.getX() + d0, (double)pos.getY() + d1, (double)pos.getZ() + d2, 0.0, 0.0, 0.0);
            }
        }
    }
}

