/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.block;

import com.github.alexthe666.alexsmobs.entity.EntityLeafcutterAnt;
import com.github.alexthe666.alexsmobs.entity.EntityManedWolf;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMAdvancementTrigger;
import com.github.alexthe666.alexsmobs.misc.AMAdvancementTriggerRegistry;
import com.github.alexthe666.alexsmobs.tileentity.AMTileEntityRegistry;
import com.github.alexthe666.alexsmobs.tileentity.TileEntityLeafcutterAnthill;
import com.mojang.serialization.MapCodec;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;

public class BlockLeafcutterAnthill
extends BaseEntityBlock {
    public static final MapCodec<BlockLeafcutterAnthill> CODEC = BlockLeafcutterAnthill.simpleCodec(props -> new BlockLeafcutterAnthill());

    public BlockLeafcutterAnthill() {
        super(BlockBehaviour.Properties.of().sound(SoundType.GRAVEL).strength(0.75f));
    }

    public MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public InteractionResult use(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (worldIn.getBlockEntity(pos) instanceof TileEntityLeafcutterAnthill) {
            TileEntityLeafcutterAnthill hill = (TileEntityLeafcutterAnthill)worldIn.getBlockEntity(pos);
            ItemStack heldItem = player.getItemInHand(handIn);
            if (heldItem.getItem() == AMItemRegistry.GONGYLIDIA.get() && hill.hasQueen()) {
                hill.releaseQueens();
                if (!player.isCreative()) {
                    heldItem.shrink(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public RenderShape getRenderShape(BlockState p_149645_1_) {
        return RenderShape.MODEL;
    }

    public BlockState playerWillDestroy(Level worldIn, BlockPos pos, BlockState state, Player player) {
        BlockEntity tileentity;
        if (!worldIn.isClientSide && player.isCreative() && worldIn.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS) && (tileentity = worldIn.getBlockEntity(pos)) instanceof TileEntityLeafcutterAnthill) {
            boolean flag;
            TileEntityLeafcutterAnthill anthivetileentity = (TileEntityLeafcutterAnthill)tileentity;
            ItemStack itemstack = new ItemStack((ItemLike)this);
            boolean bl = flag = !anthivetileentity.hasNoAnts();
            if (!flag) {
                return super.playerWillDestroy(worldIn, pos, state, player);
            }
            if (flag) {
                CompoundTag compoundnbt = new CompoundTag();
                compoundnbt.put("Ants", (Tag)anthivetileentity.getAnts());
                itemstack.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)compoundnbt));
            }
            CompoundTag compoundnbt1 = new CompoundTag();
            itemstack.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)compoundnbt1));
            ItemEntity itementity = new ItemEntity(worldIn, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), itemstack);
            itementity.setDefaultPickUpDelay();
            worldIn.addFreshEntity((Entity)itementity);
        }
        return super.playerWillDestroy(worldIn, pos, state, player);
    }

    public void fallOn(Level worldIn, BlockState state, BlockPos pos, Entity entityIn, float fallDistance) {
        if (entityIn instanceof LivingEntity && !(entityIn instanceof EntityManedWolf)) {
            this.angerNearbyAnts(worldIn, (LivingEntity)entityIn, pos);
            if (!worldIn.isClientSide && worldIn.getBlockEntity(pos) instanceof TileEntityLeafcutterAnthill) {
                TileEntityLeafcutterAnthill beehivetileentity = (TileEntityLeafcutterAnthill)worldIn.getBlockEntity(pos);
                beehivetileentity.angerAnts((LivingEntity)entityIn, worldIn.getBlockState(pos), BeehiveBlockEntity.BeeReleaseStatus.EMERGENCY);
                if (entityIn instanceof ServerPlayer) {
                    ((AMAdvancementTrigger)((Object)AMAdvancementTriggerRegistry.STOMP_LEAFCUTTER_ANTHILL.get())).trigger((ServerPlayer)entityIn);
                }
            }
        }
        super.fallOn(worldIn, state, pos, entityIn, fallDistance);
    }

    public void playerDestroy(Level worldIn, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        super.playerDestroy(worldIn, player, pos, state, te, stack);
        if (!worldIn.isClientSide && te instanceof TileEntityLeafcutterAnthill) {
            TileEntityLeafcutterAnthill beehivetileentity = (TileEntityLeafcutterAnthill)te;
            if (stack.getEnchantmentLevel((Holder)worldIn.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.SILK_TOUCH)) == 0) {
                beehivetileentity.angerAnts((LivingEntity)player, state, BeehiveBlockEntity.BeeReleaseStatus.EMERGENCY);
                worldIn.updateNeighbourForOutputSignal(pos, (Block)this);
                this.angerNearbyAnts(worldIn, pos);
            }
        }
    }

    private void angerNearbyAnts(Level world, BlockPos pos) {
        List list = world.getEntitiesOfClass(EntityLeafcutterAnt.class, new AABB(pos).inflate(20.0, 6.0, 20.0));
        if (!list.isEmpty()) {
            List list1 = world.getEntitiesOfClass(Player.class, new AABB(pos).inflate(20.0, 6.0, 20.0));
            if (list1.isEmpty()) {
                return;
            }
            int i = list1.size();
            for (EntityLeafcutterAnt beeentity : list) {
                if (beeentity.getTarget() != null) continue;
                beeentity.setTarget((LivingEntity)list1.get(world.random.nextInt(i)));
            }
        }
    }

    private void angerNearbyAnts(Level world, LivingEntity entity, BlockPos pos) {
        List list = world.getEntitiesOfClass(EntityLeafcutterAnt.class, new AABB(pos).inflate(20.0, 6.0, 20.0));
        if (!list.isEmpty()) {
            for (EntityLeafcutterAnt beeentity : list) {
                if (beeentity.getTarget() != null) continue;
                beeentity.setTarget(entity);
            }
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TileEntityLeafcutterAnthill(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level p_152180_, BlockState p_152181_, BlockEntityType<T> p_152182_) {
        return p_152180_.isClientSide ? null : BlockLeafcutterAnthill.createTickerHelper(p_152182_, (BlockEntityType)((BlockEntityType)AMTileEntityRegistry.LEAFCUTTER_ANTHILL.get()), TileEntityLeafcutterAnthill::serverTick);
    }
}

