/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.block;

import com.github.alexthe666.alexsmobs.block.AMBlockRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityLeafcutterAnt;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMPointOfInterestRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.github.alexthe666.alexsmobs.tileentity.TileEntityLeafcutterAnthill;
import com.google.common.base.Predicates;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;

public class BlockLeafcutterAntChamber
extends Block {
    public static final MapCodec<BlockLeafcutterAntChamber> CODEC = BlockLeafcutterAntChamber.simpleCodec(props -> new BlockLeafcutterAntChamber());
    public static final IntegerProperty FUNGUS = IntegerProperty.create((String)"fungus", (int)0, (int)5);

    public BlockLeafcutterAntChamber() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.DIRT).sound(SoundType.GRAVEL).strength(1.3f).randomTicks());
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FUNGUS, (Comparable)Integer.valueOf(0)));
    }

    public MapCodec<? extends Block> codec() {
        return CODEC;
    }

    public InteractionResult use(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        int fungalLevel = (Integer)state.getValue((Property)FUNGUS);
        if (fungalLevel == 5) {
            boolean shroomlight = false;
            for (BlockPos blockpos : BlockPos.betweenClosed((BlockPos)pos.offset(-1, -1, -1), (BlockPos)pos.offset(1, 1, 1))) {
                if (worldIn.getBlockState(blockpos).getBlock() != Blocks.SHROOMLIGHT) continue;
                shroomlight = true;
            }
            if (!shroomlight) {
                this.angerNearbyAnts(worldIn, pos);
            }
            worldIn.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)FUNGUS, (Comparable)Integer.valueOf(0)));
            if (!worldIn.isClientSide) {
                if (worldIn.random.nextInt(2) == 0) {
                    BlockPos offset;
                    Direction dir = Direction.getRandom((RandomSource)worldIn.random);
                    if (worldIn.getBlockState(pos.above()).getBlock() == AMBlockRegistry.LEAFCUTTER_ANTHILL.get()) {
                        dir = Direction.DOWN;
                    }
                    if (worldIn.getBlockState(offset = pos.relative(dir)).is(AMTagRegistry.LEAFCUTTER_PUPA_USABLE_ON) && !worldIn.canSeeSky(offset)) {
                        worldIn.setBlockAndUpdate(offset, this.defaultBlockState());
                    }
                }
                BlockLeafcutterAntChamber.popResource((Level)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)AMItemRegistry.GONGYLIDIA.get()));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        if (!worldIn.isAreaLoaded(pos, 3)) {
            return;
        }
        if (worldIn.canSeeSky(pos.above())) {
            worldIn.setBlockAndUpdate(pos, Blocks.DIRT.defaultBlockState());
        }
    }

    public void playerDestroy(Level worldIn, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        super.playerDestroy(worldIn, player, pos, state, te, stack);
        this.angerNearbyAnts(worldIn, pos);
    }

    private void angerNearbyAnts(Level world, BlockPos pos) {
        List list = world.getEntitiesOfClass(EntityLeafcutterAnt.class, new AABB(pos).inflate(20.0, 6.0, 20.0));
        Player player = null;
        List list1 = world.getEntitiesOfClass(Player.class, new AABB(pos).inflate(20.0, 6.0, 20.0));
        if (list1.isEmpty()) {
            return;
        }
        int i = list1.size();
        player = (Player)list1.get(world.random.nextInt(i));
        if (!list.isEmpty()) {
            for (EntityLeafcutterAnt beeentity : list) {
                if (beeentity.getTarget() != null) continue;
                beeentity.setTarget((LivingEntity)player);
            }
        }
        if (!world.isClientSide) {
            PoiManager pointofinterestmanager = ((ServerLevel)world).getPoiManager();
            Stream stream = pointofinterestmanager.findAll(poiTypeHolder -> poiTypeHolder.is(AMPointOfInterestRegistry.LEAFCUTTER_ANT_HILL.getKey()), (Predicate)Predicates.alwaysTrue(), pos, 50, PoiManager.Occupancy.ANY);
            List listOfHives = stream.collect(Collectors.toList());
            for (BlockPos pos2 : listOfHives) {
                if (!(world.getBlockEntity(pos2) instanceof TileEntityLeafcutterAnthill)) continue;
                TileEntityLeafcutterAnthill beehivetileentity = (TileEntityLeafcutterAnthill)world.getBlockEntity(pos2);
                beehivetileentity.angerAnts((LivingEntity)player, world.getBlockState(pos2), BeehiveBlockEntity.BeeReleaseStatus.EMERGENCY);
            }
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FUNGUS});
    }
}

