/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.block;

import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockHummingbirdFeeder
extends Block {
    public static final MapCodec<BlockHummingbirdFeeder> CODEC = BlockHummingbirdFeeder.simpleCodec(props -> new BlockHummingbirdFeeder());
    public static final IntegerProperty CONTENTS = IntegerProperty.create((String)"contents", (int)0, (int)3);
    public static final BooleanProperty HANGING = BlockStateProperties.HANGING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape AABB = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    private static final VoxelShape AABB_HANGING = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);

    public BlockHummingbirdFeeder() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).sound(SoundType.LANTERN).strength(0.5f).randomTicks().noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)CONTENTS, (Comparable)Integer.valueOf(0))).setValue((Property)HANGING, (Comparable)Boolean.valueOf(false)));
    }

    public MapCodec<? extends Block> codec() {
        return CODEC;
    }

    @Deprecated
    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)HANGING) != false ? AABB_HANGING : AABB;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        for (Direction direction : context.getNearestLookingDirections()) {
            BlockState blockstate;
            if (direction.getAxis() != Direction.Axis.Y || !(blockstate = (BlockState)this.defaultBlockState().setValue((Property)HANGING, (Comparable)Boolean.valueOf(direction == Direction.UP))).canSurvive((LevelReader)context.getLevel(), context.getClickedPos())) continue;
            return (BlockState)blockstate.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
        }
        return null;
    }

    protected static Direction getBlockConnected(BlockState state) {
        return (Boolean)state.getValue((Property)HANGING) != false ? Direction.DOWN : Direction.UP;
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        int contents = (Integer)state.getValue((Property)CONTENTS);
        ItemStack waterBottle = PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.WATER);
        int setContent = -1;
        if (contents == 0) {
            if (itemStack.is(AMTagRegistry.HUMMINGNBIRD_FEEDER_SWEETENERS)) {
                setContent = 2;
                this.useItem(player, itemStack, false);
            } else if (itemStack.getItem() == waterBottle.getItem() && ItemStack.isSameItemSameComponents((ItemStack)waterBottle, (ItemStack)itemStack)) {
                setContent = 1;
                this.useItem(player, itemStack, true);
            }
        } else if (contents == 1) {
            if (itemStack.is(AMTagRegistry.HUMMINGNBIRD_FEEDER_SWEETENERS)) {
                setContent = 3;
                this.useItem(player, itemStack, false);
            }
        } else if (contents == 2 && itemStack.getItem() == waterBottle.getItem() && ItemStack.isSameItemSameComponents((ItemStack)waterBottle, (ItemStack)itemStack)) {
            setContent = 3;
            this.useItem(player, itemStack, true);
        }
        if (setContent >= 0) {
            worldIn.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CONTENTS, (Comparable)Integer.valueOf(setContent)));
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void useItem(Player playerEntity, ItemStack stack, boolean dropBottle) {
        if (!playerEntity.isCreative()) {
            if (dropBottle) {
                playerEntity.addItem(new ItemStack((ItemLike)Items.GLASS_BOTTLE));
            }
            stack.shrink(1);
        }
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        Direction direction = BlockHummingbirdFeeder.getBlockConnected(state).getOpposite();
        return Block.canSupportCenter((LevelReader)worldIn, (BlockPos)pos.relative(direction), (Direction)direction.getOpposite());
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        return BlockHummingbirdFeeder.getBlockConnected(stateIn).getOpposite() == facing && !stateIn.canSurvive((LevelReader)worldIn, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean isPathfindable(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{CONTENTS, HANGING, WATERLOGGED});
    }
}

