/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.block;

import com.github.alexthe666.alexsmobs.entity.EntityGust;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;

public class BlockGustmaker
extends Block {
    public static final MapCodec<BlockGustmaker> CODEC = BlockGustmaker.simpleCodec(props -> new BlockGustmaker());
    public static final DirectionProperty FACING = DirectionalBlock.FACING;
    public static final BooleanProperty TRIGGERED = BlockStateProperties.TRIGGERED;

    public BlockGustmaker() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.SAND).requiresCorrectToolForDrops().strength(1.5f));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)));
    }

    public MapCodec<? extends Block> codec() {
        return CODEC;
    }

    public static Vec3 getDispensePosition(BlockPos coords, Direction dir) {
        double d0 = (double)coords.getX() + 0.5 + 0.7 * (double)dir.getStepX();
        double d1 = (double)coords.getY() + 0.15 + 0.7 * (double)dir.getStepY();
        double d2 = (double)coords.getZ() + 0.5 + 0.7 * (double)dir.getStepZ();
        return new Vec3(d0, d1, d2);
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        this.tickGustmaker(state, worldIn, pos, false);
    }

    public void tick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        this.tickGustmaker(state, (Level)worldIn, pos, true);
    }

    public void tickGustmaker(BlockState state, Level worldIn, BlockPos pos, boolean tickOff) {
        boolean flag = worldIn.hasNeighborSignal(pos) || worldIn.hasNeighborSignal(pos.below()) || worldIn.hasNeighborSignal(pos.above());
        boolean flag1 = (Boolean)state.getValue((Property)TRIGGERED);
        if (flag && !flag1) {
            if (worldIn.isLoaded(pos)) {
                Vec3 dispensePosition = BlockGustmaker.getDispensePosition(pos, (Direction)state.getValue((Property)FACING));
                Vec3 gustDir = Vec3.atLowerCornerOf((Vec3i)((Direction)state.getValue((Property)FACING)).getNormal()).multiply(0.1, 0.1, 0.1);
                EntityGust gust = new EntityGust(worldIn);
                gust.setGustDir((float)gustDir.x, (float)gustDir.y, (float)gustDir.z);
                gust.setPos(dispensePosition.x, dispensePosition.y, dispensePosition.z);
                if (((Direction)state.getValue((Property)FACING)).getAxis() == Direction.Axis.Y) {
                    gust.setVertical(true);
                }
                if (!worldIn.isClientSide) {
                    worldIn.addFreshEntity((Entity)gust);
                }
            }
            worldIn.setBlock(pos, (BlockState)state.setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(true)), 2);
            worldIn.scheduleTick(pos, (Block)this, 20);
        } else if (flag1 && tickOff) {
            worldIn.scheduleTick(pos, (Block)this, 20);
            worldIn.setBlock(pos, (BlockState)state.setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getNearestLookingDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, TRIGGERED});
    }
}

