/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.block;

import com.github.alexthe666.alexsmobs.block.AMSpecialRenderBlock;
import com.github.alexthe666.alexsmobs.tileentity.AMTileEntityRegistry;
import com.github.alexthe666.alexsmobs.tileentity.TileEntityEndPirateShipWheel;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockEndPirateShipWheel
extends BaseEntityBlock
implements AMSpecialRenderBlock {
    public static final MapCodec<BlockEndPirateShipWheel> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockEndPirateShipWheel.propertiesCodec()).apply((Applicative)instance, props -> new BlockEndPirateShipWheel()));
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    private static final VoxelShape SOUTH_AABB = Block.box((double)-2.0, (double)-2.0, (double)0.0, (double)18.0, (double)18.0, (double)3.0);
    private static final VoxelShape NORTH_AABB = Block.box((double)-2.0, (double)-2.0, (double)13.0, (double)18.0, (double)18.0, (double)16.0);
    private static final VoxelShape EAST_AABB = Block.box((double)0.0, (double)-2.0, (double)-2.0, (double)3.0, (double)18.0, (double)18.0);
    private static final VoxelShape WEST_AABB = Block.box((double)13.0, (double)-2.0, (double)-2.0, (double)16.0, (double)18.0, (double)18.0);
    private static final VoxelShape UP_AABB = Block.box((double)-2.0, (double)0.0, (double)-2.0, (double)18.0, (double)3.0, (double)18.0);
    private static final VoxelShape DOWN_AABB = Block.box((double)-2.0, (double)13.0, (double)-2.0, (double)16.0, (double)16.0, (double)18.0);

    public BlockEndPirateShipWheel() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_WHITE).noOcclusion().sound(SoundType.ANCIENT_DEBRIS).strength(1.0f).lightLevel(i -> 3).noCollission().requiresCorrectToolForDrops());
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public MapCodec<BlockEndPirateShipWheel> codec() {
        return CODEC;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState state2, LevelAccessor level, BlockPos pos, BlockPos p_52801_) {
        return !state.canSurvive((LevelReader)level, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, state2, level, pos, p_52801_);
    }

    public VoxelShape getShape(BlockState p_54561_, BlockGetter p_54562_, BlockPos p_54563_, CollisionContext p_54564_) {
        return switch ((Direction)p_54561_.getValue((Property)FACING)) {
            case Direction.NORTH -> NORTH_AABB;
            case Direction.SOUTH -> SOUTH_AABB;
            case Direction.EAST -> EAST_AABB;
            case Direction.WEST -> WEST_AABB;
            case Direction.UP -> UP_AABB;
            default -> DOWN_AABB;
        };
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        boolean remove = false;
        Direction dir = ((Direction)state.getValue((Property)FACING)).getOpposite();
        BlockPos offset = pos.relative(dir);
        return remove || world.getBlockState(offset).isFaceSturdy((BlockGetter)world, offset, dir.getOpposite());
    }

    public InteractionResult use(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity blockEntity = worldIn.getBlockEntity(pos);
        if (blockEntity instanceof TileEntityEndPirateShipWheel) {
            TileEntityEndPirateShipWheel wheel = (TileEntityEndPirateShipWheel)blockEntity;
            boolean clockwise = false;
            Vec3 offset = hit.getLocation().subtract((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
            switch ((Direction)state.getValue((Property)FACING)) {
                case NORTH: {
                    clockwise = offset.x <= 0.5;
                    break;
                }
                case SOUTH: {
                    clockwise = offset.x >= 0.5;
                    break;
                }
                case EAST: {
                    clockwise = offset.z <= 0.5;
                    break;
                }
                case WEST: {
                    clockwise = offset.z >= 0.5;
                }
            }
            wheel.rotate(clockwise);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TileEntityEndPirateShipWheel(pos, state);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level p_152180_, BlockState p_152181_, BlockEntityType<T> p_152182_) {
        return BlockEndPirateShipWheel.createTickerHelper(p_152182_, (BlockEntityType)((BlockEntityType)AMTileEntityRegistry.END_PIRATE_SHIP_WHEEL.get()), TileEntityEndPirateShipWheel::commonTick);
    }
}

