/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.block;

import com.mojang.serialization.MapCodec;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockEndPirateSail
extends Block {
    public static final MapCodec<BlockEndPirateSail> CODEC = MapCodec.unit((Object)((Object)new BlockEndPirateSail(false)));
    public static final BooleanProperty EASTORWEST = BooleanProperty.create((String)"eastorwest");
    public static final EnumProperty<SailType> SAIL = EnumProperty.create((String)"sail", SailType.class);
    protected static final VoxelShape EW_AABB = Block.box((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NS_AABB = Block.box((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);

    public BlockEndPirateSail(boolean spectre) {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLUE).noOcclusion().emissiveRendering((a, b, c) -> true).sound(SoundType.WOOL).lightLevel(state -> 5).requiresCorrectToolForDrops().strength(0.4f));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)EASTORWEST, (Comparable)Boolean.valueOf(false))).setValue(SAIL, (Comparable)((Object)SailType.SINGLE)));
    }

    public MapCodec<? extends Block> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState p_52807_, BlockGetter p_52808_, BlockPos p_52809_, CollisionContext p_52810_) {
        return (Boolean)p_52807_.getValue((Property)EASTORWEST) != false ? EW_AABB : NS_AABB;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_58032_) {
        p_58032_.add(new Property[]{EASTORWEST, SAIL});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean axis;
        Level levelreader = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        BlockPos actualPos = context.getClickedPos().relative(context.getClickedFace().getOpposite());
        BlockPos u = blockpos.above();
        BlockPos d = blockpos.below();
        BlockState clickState = levelreader.getBlockState(actualPos);
        BlockState upState = levelreader.getBlockState(u);
        BlockState downState = levelreader.getBlockState(d);
        boolean bl = context.getClickedFace().getAxis() == Direction.Axis.Y ? context.getHorizontalDirection().getAxis() == Direction.Axis.X : (axis = context.getClickedFace().getAxis() != Direction.Axis.X);
        if (clickState.getBlock() instanceof BlockEndPirateSail) {
            axis = (Boolean)clickState.getValue((Property)EASTORWEST);
        }
        BlockState axisState = (BlockState)this.defaultBlockState().setValue((Property)EASTORWEST, (Comparable)Boolean.valueOf(axis));
        return (BlockState)axisState.setValue(SAIL, (Comparable)((Object)BlockEndPirateSail.getSailTypeFor(axisState, downState, upState)));
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState state2, LevelAccessor levelreader, BlockPos blockpos, BlockPos pos2) {
        BlockPos u = blockpos.above();
        BlockPos d = blockpos.below();
        BlockState upState = levelreader.getBlockState(u);
        BlockState downState = levelreader.getBlockState(d);
        return (BlockState)state.setValue(SAIL, (Comparable)((Object)BlockEndPirateSail.getSailTypeFor(state, downState, upState)));
    }

    private static SailType getSailTypeFor(BlockState us, BlockState below, BlockState above) {
        if (below.getBlock() instanceof BlockEndPirateSail && below.getValue((Property)EASTORWEST) == us.getValue((Property)EASTORWEST)) {
            return above.getBlock() instanceof BlockEndPirateSail ? SailType.MIDDLE : SailType.TOP;
        }
        if (above.getBlock() instanceof BlockEndPirateSail && above.getValue((Property)EASTORWEST) == us.getValue((Property)EASTORWEST)) {
            return SailType.BOTTOM;
        }
        return SailType.SINGLE;
    }

    private static enum SailType implements StringRepresentable
    {
        SINGLE,
        TOP,
        MIDDLE,
        BOTTOM;


        public String toString() {
            return this.getSerializedName();
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

