/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.block;

import com.github.alexthe666.alexsmobs.tileentity.AMTileEntityRegistry;
import com.github.alexthe666.alexsmobs.tileentity.TileEntityEndPirateDoor;
import com.mojang.serialization.MapCodec;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockEndPirateDoor
extends BaseEntityBlock {
    public static final MapCodec<BlockEndPirateDoor> CODEC = BlockEndPirateDoor.simpleCodec(props -> new BlockEndPirateDoor());
    public static final DirectionProperty HORIZONTAL_FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty OPEN = BooleanProperty.create((String)"open");
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.DOOR_HINGE;
    public static final IntegerProperty SEGMENT = IntegerProperty.create((String)"segment", (int)0, (int)2);
    protected static final float AABB_DOOR_THICKNESS = 3.0f;
    protected static final VoxelShape SOUTH_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    protected static final VoxelShape NORTH_AABB = Block.box((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);

    public BlockEndPirateDoor() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).noOcclusion().sound(SoundType.GLASS).lightLevel(state -> 3).requiresCorrectToolForDrops().strength(1.5f));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)SEGMENT, (Comparable)Integer.valueOf(0))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue(HINGE, (Comparable)DoorHingeSide.RIGHT)).setValue((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH));
    }

    public MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState p_52807_, BlockGetter p_52808_, BlockPos p_52809_, CollisionContext p_52810_) {
        Direction direction = (Direction)p_52807_.getValue((Property)HORIZONTAL_FACING);
        boolean flag = (Boolean)p_52807_.getValue((Property)OPEN) == false;
        boolean flag1 = p_52807_.getValue(HINGE) == DoorHingeSide.RIGHT;
        return switch (direction) {
            default -> {
                if (flag) {
                    yield EAST_AABB;
                }
                if (flag1) {
                    yield NORTH_AABB;
                }
                yield SOUTH_AABB;
            }
            case Direction.SOUTH -> {
                if (flag) {
                    yield SOUTH_AABB;
                }
                if (flag1) {
                    yield EAST_AABB;
                }
                yield WEST_AABB;
            }
            case Direction.WEST -> {
                if (flag) {
                    yield WEST_AABB;
                }
                if (flag1) {
                    yield SOUTH_AABB;
                }
                yield NORTH_AABB;
            }
            case Direction.NORTH -> flag ? NORTH_AABB : (flag1 ? WEST_AABB : EAST_AABB);
        };
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState state2, LevelAccessor level, BlockPos pos, BlockPos p_52801_) {
        if ((Integer)state.getValue((Property)SEGMENT) == 0) {
            return !state.canSurvive((LevelReader)level, pos) || !level.getBlockState(pos.above()).is((Block)this) || !level.getBlockState(pos.above(2)).is((Block)this) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, state2, level, pos, p_52801_);
        }
        return !state.canSurvive((LevelReader)level, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, state2, level, pos, p_52801_);
    }

    public BlockState rotate(BlockState p_185499_1_, Rotation p_185499_2_) {
        return (BlockState)p_185499_1_.setValue((Property)HORIZONTAL_FACING, (Comparable)p_185499_2_.rotate((Direction)p_185499_1_.getValue((Property)HORIZONTAL_FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mir) {
        return state.rotate(mir.getRotation((Direction)state.getValue((Property)HORIZONTAL_FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SEGMENT, HORIZONTAL_FACING, OPEN, HINGE, POWERED});
    }

    public RenderShape getRenderShape(BlockState state) {
        return (Integer)state.getValue((Property)SEGMENT) == 0 ? RenderShape.ENTITYBLOCK_ANIMATED : RenderShape.INVISIBLE;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return (Integer)state.getValue((Property)SEGMENT) == 0 ? new TileEntityEndPirateDoor(pos, state) : null;
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos p_52780_, boolean p_52781_) {
        boolean flag = level.hasNeighborSignal(pos);
        switch ((Integer)state.getValue((Property)SEGMENT)) {
            case 0: {
                boolean bl;
                if (flag || level.hasNeighborSignal(pos.above()) || level.hasNeighborSignal(pos.above(2))) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 1: {
                boolean bl;
                if (flag || level.hasNeighborSignal(pos.below()) || level.hasNeighborSignal(pos.above())) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 2: {
                boolean bl;
                if (flag || level.hasNeighborSignal(pos.below()) || level.hasNeighborSignal(pos.below(2))) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                boolean bl = flag = flag;
            }
        }
        if (!this.defaultBlockState().is(block) && flag != (Boolean)state.getValue((Property)POWERED)) {
            Direction swap;
            BlockPos relative;
            BlockState neighbor;
            if (flag != (Boolean)state.getValue((Property)OPEN)) {
                // empty if block
            }
            if ((neighbor = level.getBlockState(relative = pos.relative(swap = state.getValue(HINGE) == DoorHingeSide.LEFT ? ((Direction)state.getValue((Property)HORIZONTAL_FACING)).getClockWise() : ((Direction)state.getValue((Property)HORIZONTAL_FACING)).getCounterClockWise()))).getBlock() == this && state.getValue(HINGE) != neighbor.getValue(HINGE)) {
                BlockEndPirateDoor.openDoorAt(level, relative, flag, flag);
            }
            BlockEndPirateDoor.openDoorAt(level, pos, flag, flag);
        }
    }

    public InteractionResult use(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        boolean open = (Boolean)state.getValue((Property)OPEN);
        boolean powered = (Boolean)state.getValue((Property)POWERED);
        Direction swap = state.getValue(HINGE) == DoorHingeSide.LEFT ? ((Direction)state.getValue((Property)HORIZONTAL_FACING)).getClockWise() : ((Direction)state.getValue((Property)HORIZONTAL_FACING)).getCounterClockWise();
        BlockPos relative = pos.relative(swap);
        BlockState neighbor = worldIn.getBlockState(relative);
        if (neighbor.getBlock() == this && state.getValue(HINGE) != neighbor.getValue(HINGE)) {
            BlockEndPirateDoor.openDoorAt(worldIn, relative, !open, powered);
        }
        BlockEndPirateDoor.openDoorAt(worldIn, pos, !open, powered);
        return InteractionResult.sidedSuccess((boolean)worldIn.isClientSide);
    }

    public static void openDoorAt(Level worldIn, BlockPos pos, boolean open, boolean powered) {
        TileEntityEndPirateDoor te = BlockEndPirateDoor.getDoorTE(worldIn, pos);
        if (te != null) {
            BlockPos bottom = te.getBlockPos();
            for (int i = 0; i <= 2; ++i) {
                BlockPos up = bottom.above(i);
                if (!(worldIn.getBlockState(up).getBlock() instanceof BlockEndPirateDoor)) continue;
                worldIn.setBlock(up, (BlockState)((BlockState)worldIn.getBlockState(up).setValue((Property)OPEN, (Comparable)Boolean.valueOf(open))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered)), 10);
            }
        }
    }

    public static TileEntityEndPirateDoor getDoorTE(Level worldIn, BlockPos pos) {
        for (int i = 0; i <= 2; ++i) {
            BlockEntity blockEntity = worldIn.getBlockEntity(pos.below(i));
            if (!(blockEntity instanceof TileEntityEndPirateDoor)) continue;
            TileEntityEndPirateDoor e = (TileEntityEndPirateDoor)blockEntity;
            return e;
        }
        return null;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext p_52739_) {
        BlockPos blockpos = p_52739_.getClickedPos();
        Level level = p_52739_.getLevel();
        if (blockpos.getY() < level.getMaxBuildHeight() - 1 && level.getBlockState(blockpos.above()).canBeReplaced(p_52739_) && level.getBlockState(blockpos.above(2)).canBeReplaced(p_52739_)) {
            boolean flag = level.hasNeighborSignal(blockpos) || level.hasNeighborSignal(blockpos.above());
            return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)HORIZONTAL_FACING, (Comparable)p_52739_.getHorizontalDirection())).setValue(HINGE, (Comparable)this.getHinge(p_52739_))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(flag))).setValue((Property)SEGMENT, (Comparable)Integer.valueOf(0));
        }
        return null;
    }

    public void setPlacedBy(Level p_52749_, BlockPos p_52750_, BlockState p_52751_, LivingEntity p_52752_, ItemStack p_52753_) {
        p_52749_.setBlock(p_52750_.above(), (BlockState)p_52751_.setValue((Property)SEGMENT, (Comparable)Integer.valueOf(1)), 3);
        p_52749_.setBlock(p_52750_.above(2), (BlockState)p_52751_.setValue((Property)SEGMENT, (Comparable)Integer.valueOf(2)), 3);
    }

    private DoorHingeSide getHinge(BlockPlaceContext p_52805_) {
        boolean flag1;
        Level blockgetter = p_52805_.getLevel();
        BlockPos blockpos = p_52805_.getClickedPos();
        Direction direction = p_52805_.getHorizontalDirection();
        BlockPos blockpos1 = blockpos.above();
        Direction direction1 = direction.getCounterClockWise();
        BlockPos blockpos2 = blockpos.relative(direction1);
        BlockState blockstate = blockgetter.getBlockState(blockpos2);
        BlockPos blockpos3 = blockpos1.relative(direction1);
        BlockState blockstate1 = blockgetter.getBlockState(blockpos3);
        Direction direction2 = direction.getClockWise();
        BlockPos blockpos4 = blockpos.relative(direction2);
        BlockState blockstate2 = blockgetter.getBlockState(blockpos4);
        BlockPos blockpos5 = blockpos1.relative(direction2);
        BlockState blockstate3 = blockgetter.getBlockState(blockpos5);
        int i = (blockstate.isCollisionShapeFullBlock((BlockGetter)blockgetter, blockpos2) ? -1 : 0) + (blockstate1.isCollisionShapeFullBlock((BlockGetter)blockgetter, blockpos3) ? -1 : 0) + (blockstate2.isCollisionShapeFullBlock((BlockGetter)blockgetter, blockpos4) ? 1 : 0) + (blockstate3.isCollisionShapeFullBlock((BlockGetter)blockgetter, blockpos5) ? 1 : 0);
        boolean flag = blockstate.is((Block)this) && (Integer)blockstate.getValue((Property)SEGMENT) == 0;
        boolean bl = flag1 = blockstate2.is((Block)this) && (Integer)blockstate2.getValue((Property)SEGMENT) == 0;
        if ((!flag || flag1) && i <= 0) {
            if ((!flag1 || flag) && i >= 0) {
                int j = direction.getStepX();
                int k = direction.getStepZ();
                Vec3 vec3 = p_52805_.getClickLocation();
                double d0 = vec3.x - (double)blockpos.getX();
                double d1 = vec3.z - (double)blockpos.getZ();
                return !(j < 0 && d1 < 0.5 || j > 0 && d1 > 0.5 || k < 0 && d0 > 0.5 || k > 0 && d0 < 0.5) ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
            }
            return DoorHingeSide.LEFT;
        }
        return DoorHingeSide.RIGHT;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return switch ((Integer)state.getValue((Property)SEGMENT)) {
            case 0 -> world.getBlockState(pos.below()).isFaceSturdy((BlockGetter)world, pos.below(), Direction.UP);
            case 1 -> {
                if (world.getBlockState(pos.below()).is((Block)this) && world.getBlockState(pos.above()).is((Block)this)) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (world.getBlockState(pos.below()).is((Block)this) && world.getBlockState(pos.below(2)).is((Block)this)) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level p_152180_, BlockState state, BlockEntityType<T> p_152182_) {
        return (Integer)state.getValue((Property)SEGMENT) == 0 ? BlockEndPirateDoor.createTickerHelper(p_152182_, (BlockEntityType)((BlockEntityType)AMTileEntityRegistry.END_PIRATE_DOOR.get()), TileEntityEndPirateDoor::commonTick) : null;
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        return (Integer)state.getValue((Property)SEGMENT) == 0 ? super.getDrops(state, builder) : Collections.emptyList();
    }
}

