/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.block;

import com.github.alexthe666.alexsmobs.block.AMSpecialRenderBlock;
import com.github.alexthe666.alexsmobs.tileentity.AMTileEntityRegistry;
import com.github.alexthe666.alexsmobs.tileentity.TileEntityEndPirateAnchorWinch;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockEndPirateAnchorWinch
extends BaseEntityBlock
implements AMSpecialRenderBlock {
    public static final MapCodec<BlockEndPirateAnchorWinch> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockEndPirateAnchorWinch.propertiesCodec()).apply((Applicative)instance, props -> new BlockEndPirateAnchorWinch()));
    public static final BooleanProperty EASTORWEST = BooleanProperty.create((String)"eastorwest");
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    protected static final VoxelShape FULL_AABB_EW = Block.box((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)16.0);
    protected static final VoxelShape FULL_AABB_NS = Block.box((double)0.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0);

    public MapCodec<BlockEndPirateAnchorWinch> codec() {
        return CODEC;
    }

    protected BlockEndPirateAnchorWinch() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).friction(0.97f).strength(10.0f).lightLevel(i -> 6).sound(SoundType.STONE).noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)EASTORWEST, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{EASTORWEST, POWERED});
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)EASTORWEST) != false ? FULL_AABB_EW : FULL_AABB_NS;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean axis = context.getClickedFace().getAxis() == Direction.Axis.Y ? context.getHorizontalDirection().getAxis() == Direction.Axis.X : context.getClickedFace().getAxis() != Direction.Axis.X;
        return (BlockState)this.defaultBlockState().setValue((Property)EASTORWEST, (Comparable)Boolean.valueOf(axis));
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity player, ItemStack stack) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TileEntityEndPirateAnchorWinch) {
            TileEntityEndPirateAnchorWinch winch = (TileEntityEndPirateAnchorWinch)blockEntity;
            winch.recalculateChains();
        }
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos p_52780_, boolean p_52781_) {
        boolean flag = level.hasNeighborSignal(pos);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TileEntityEndPirateAnchorWinch) {
            TileEntityEndPirateAnchorWinch winch = (TileEntityEndPirateAnchorWinch)blockEntity;
            if (flag != (Boolean)state.getValue((Property)POWERED)) {
                level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(flag)), 3);
            }
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TileEntityEndPirateAnchorWinch(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level p_152180_, BlockState state, BlockEntityType<T> p_152182_) {
        return BlockEndPirateAnchorWinch.createTickerHelper(p_152182_, (BlockEntityType)((BlockEntityType)AMTileEntityRegistry.END_PIRATE_ANCHOR_WINCH.get()), TileEntityEndPirateAnchorWinch::commonTick);
    }
}

