/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.block;

import com.github.alexthe666.alexsmobs.block.AMSpecialRenderBlock;
import com.github.alexthe666.alexsmobs.block.BlockEndPirateAnchorWinch;
import com.github.alexthe666.alexsmobs.tileentity.AMTileEntityRegistry;
import com.github.alexthe666.alexsmobs.tileentity.TileEntityEndPirateAnchor;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockEndPirateAnchor
extends BaseEntityBlock
implements AMSpecialRenderBlock {
    public static final MapCodec<BlockEndPirateAnchor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockEndPirateAnchor.propertiesCodec()).apply((Applicative)instance, props -> new BlockEndPirateAnchor()));
    public static final BooleanProperty EASTORWEST = BooleanProperty.create((String)"eastorwest");
    public static final EnumProperty<PieceType> PIECE = EnumProperty.create((String)"piece", PieceType.class);
    protected static final VoxelShape FULL_AABB_EW = Block.box((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0);
    protected static final VoxelShape FULL_AABB_NS = Block.box((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0);
    protected static final VoxelShape CHAIN_AABB = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);

    public MapCodec<BlockEndPirateAnchor> codec() {
        return CODEC;
    }

    protected BlockEndPirateAnchor() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).friction(0.97f).strength(10.0f).lightLevel(i -> 6).sound(SoundType.STONE).noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)EASTORWEST, (Comparable)Boolean.valueOf(false))).setValue(PIECE, (Comparable)((Object)PieceType.ANCHOR)));
    }

    public static boolean isClearForPlacement(LevelReader reader, BlockPos center, boolean eastOrWest) {
        List<BlockPos> offsets = TileEntityEndPirateAnchor.getValidBBPositions(eastOrWest);
        for (BlockPos offset : offsets) {
            BlockPos check = center.offset((Vec3i)offset);
            if (reader.isEmptyBlock(check) && reader.getBlockState(check).canBeReplaced()) continue;
            return false;
        }
        return true;
    }

    public static void placeAnchor(Level level, BlockPos pos, BlockState state) {
        List<BlockPos> offsets = TileEntityEndPirateAnchor.getValidBBPositions((Boolean)state.getValue((Property)EASTORWEST));
        for (BlockPos offset : offsets) {
            if (offset.equals((Object)BlockPos.ZERO)) continue;
            level.setBlock(pos.offset((Vec3i)offset), (BlockState)state.setValue(PIECE, (Comparable)((Object)PieceType.ANCHOR_SIDE)), 2);
        }
    }

    public static void removeAnchor(Level level, BlockPos pos, BlockState state) {
        List<BlockPos> offsets = TileEntityEndPirateAnchor.getValidBBPositions((Boolean)state.getValue((Property)EASTORWEST));
        for (BlockPos offset : offsets) {
            level.setBlock(pos.offset((Vec3i)offset), Blocks.AIR.defaultBlockState(), 67);
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean axis;
        Level levelreader = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        BlockPos actualPos = context.getClickedPos().relative(context.getClickedFace().getOpposite());
        BlockPos u = blockpos.above();
        BlockPos d = blockpos.below();
        BlockState clickState = levelreader.getBlockState(actualPos);
        boolean bl = axis = context.getHorizontalDirection().getAxis() == Direction.Axis.X;
        if (clickState.getBlock() instanceof BlockEndPirateAnchor) {
            axis = (Boolean)clickState.getValue((Property)EASTORWEST);
        }
        return BlockEndPirateAnchor.isClearForPlacement((LevelReader)levelreader, blockpos, axis) ? (BlockState)this.defaultBlockState().setValue((Property)EASTORWEST, (Comparable)Boolean.valueOf(axis)) : null;
    }

    public boolean isLadder(BlockState state, LevelReader world, BlockPos pos, LivingEntity entity) {
        return state.getValue(PIECE) == PieceType.CHAIN;
    }

    public boolean isScaffolding(BlockState state, LevelReader world, BlockPos pos, LivingEntity entity) {
        return state.getValue(PIECE) == PieceType.CHAIN;
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof LivingEntity && state.getValue(PIECE) == PieceType.CHAIN) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (livingEntity.horizontalCollision && !livingEntity.isInWater()) {
                livingEntity.fallDistance = 0.0f;
                Vec3 motion = livingEntity.getDeltaMovement();
                double d0 = Mth.clamp((double)motion.x, (double)-0.15f, (double)0.15f);
                double d1 = Mth.clamp((double)motion.z, (double)-0.15f, (double)0.15f);
                double d2 = 0.3;
                if (d2 < 0.0 && livingEntity.isSuppressingSlidingDownLadder()) {
                    d2 = 0.0;
                }
                motion = new Vec3(d0, d2, d1);
                livingEntity.setDeltaMovement(motion);
            }
        }
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos p_52780_, boolean p_52781_) {
        if (state.getValue(PIECE) == PieceType.ANCHOR_SIDE) {
            for (int i = -2; i <= 2; ++i) {
                for (int j = -3; j <= 3; ++j) {
                    for (int k = -2; k <= 2; ++k) {
                        TileEntityEndPirateAnchor anchor;
                        BlockPos offsetPos = pos.offset(i, j, k);
                        BlockEntity blockEntity = level.getBlockEntity(offsetPos);
                        if (!(blockEntity instanceof TileEntityEndPirateAnchor) || (anchor = (TileEntityEndPirateAnchor)blockEntity).hasAllAnchorBlocks()) continue;
                        BlockEndPirateAnchor.removeAnchor(level, offsetPos, level.getBlockState(offsetPos));
                        level.destroyBlock(offsetPos, true);
                    }
                }
            }
        }
        if (!this.canSurviveAnchor(state, (LevelReader)level, pos)) {
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 2);
        }
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity player, ItemStack stack) {
        BlockEndPirateAnchor.placeAnchor(level, pos, state);
    }

    public boolean canSurviveAnchor(BlockState state, LevelReader world, BlockPos pos) {
        if (state.getValue(PIECE) == PieceType.ANCHOR) {
            return true;
        }
        if (state.getValue(PIECE) == PieceType.ANCHOR_SIDE) {
            for (int i = -1; i <= 1; ++i) {
                for (int j = -3; j <= 0; ++j) {
                    for (int k = -1; k <= 1; ++k) {
                        BlockPos offsetPos = pos.offset(i, j, k);
                        BlockState anchorState = world.getBlockState(offsetPos);
                        if (!(anchorState.getBlock() instanceof BlockEndPirateAnchor) || anchorState.getValue(PIECE) != PieceType.ANCHOR || !this.isPartOfAnchor(anchorState, world, offsetPos, pos, (Boolean)state.getValue((Property)EASTORWEST))) continue;
                        return true;
                    }
                }
            }
        } else if (state.getValue(PIECE) == PieceType.CHAIN) {
            BlockPos below = pos.below();
            BlockState chainBelow = world.getBlockState(below);
            BlockState chainAbove = world.getBlockState(below);
            return chainBelow.getBlock() instanceof BlockEndPirateAnchor && (chainAbove.getBlock() instanceof BlockEndPirateAnchor || chainAbove.getBlock() instanceof BlockEndPirateAnchorWinch);
        }
        return false;
    }

    public boolean isPartOfAnchor(BlockState anchor, LevelReader level, BlockPos center, BlockPos pos, boolean eastOrWest) {
        if ((Boolean)anchor.getValue((Property)EASTORWEST) == eastOrWest) {
            BlockPos offset = pos.subtract((Vec3i)center);
            return TileEntityEndPirateAnchor.getValidBBPositions(eastOrWest).contains(offset);
        }
        return false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_58032_) {
        p_58032_.add(new Property[]{EASTORWEST, PIECE});
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        if (state.getValue(PIECE) == PieceType.CHAIN) {
            return CHAIN_AABB;
        }
        return (Boolean)state.getValue((Property)EASTORWEST) != false ? FULL_AABB_NS : FULL_AABB_EW;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return state.getValue(PIECE) == PieceType.ANCHOR ? new TileEntityEndPirateAnchor(pos, state) : null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level p_152180_, BlockState state, BlockEntityType<T> p_152182_) {
        return state.getValue(PIECE) == PieceType.ANCHOR ? BlockEndPirateAnchor.createTickerHelper(p_152182_, (BlockEntityType)((BlockEntityType)AMTileEntityRegistry.END_PIRATE_ANCHOR.get()), TileEntityEndPirateAnchor::commonTick) : null;
    }

    public RenderShape getRenderShape(BlockState state) {
        return state.getValue(PIECE) == PieceType.ANCHOR_SIDE ? RenderShape.INVISIBLE : RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        return state.getValue(PIECE) == PieceType.ANCHOR ? super.getDrops(state, builder) : Collections.emptyList();
    }

    public static enum PieceType implements StringRepresentable
    {
        ANCHOR,
        ANCHOR_SIDE,
        CHAIN;


        public String toString() {
            return this.getSerializedName();
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

