/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.addonslib.roofs;

import fr.samlegamer.addonslib.Finder;
import fr.samlegamer.addonslib.Registration;
import fr.samlegamer.addonslib.data.BlockId;
import fr.samlegamer.addonslib.data.CreateBlockReferences;
import fr.samlegamer.addonslib.data.McwBlocksIdBase;
import java.util.List;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredRegister;

public class Roofs {
    public static final String modid = "mcwroofs";

    public static void setRegistrationWood(List<String> set, DeferredRegister.Blocks block, DeferredRegister.Items item) {
        BlockBehaviour.Properties wood = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS);
        Roofs.setRegistrationWoodModLoaded(set, block, item, wood);
    }

    public static void setRegistrationRock(List<String> rock, DeferredRegister.Blocks block, DeferredRegister.Items item) {
        BlockBehaviour.Properties stone = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLESTONE);
        Roofs.setRegistrationRockModLoaded(rock, block, item, stone);
    }

    public static void setRegistrationWoodModLoaded(List<String> set, DeferredRegister.Blocks block, DeferredRegister.Items item, BlockBehaviour.Properties prop) {
        BlockBehaviour.Properties WOOD = prop;
        boolean isModLoaded = ModList.get().isLoaded(modid);
        for (String i : set) {
            for (BlockId blockId : McwBlocksIdBase.ROOFS_WOOD_BLOCKS.blocks()) {
                String id = McwBlocksIdBase.replacement(blockId.id(), i);
                if (blockId.reflectedLocation().contains("StairBlock")) {
                    CreateBlockReferences.createBlock(id, registryName -> new StairBlock(Blocks.OAK_PLANKS.defaultBlockState(), WOOD), block, item);
                    continue;
                }
                if (isModLoaded) {
                    if (blockId.reflectedLocation().contains("Lower") || blockId.reflectedLocation().contains("Steep")) {
                        CreateBlockReferences.createBlock(id, registryName -> Registration.getBlocksField(blockId.reflectedLocation(), WOOD, Blocks.OAK_PLANKS.defaultBlockState()), block, item);
                        continue;
                    }
                    CreateBlockReferences.createBlock(id, registryName -> Registration.getBlocksField(blockId.reflectedLocation(), WOOD), block, item);
                    continue;
                }
                CreateBlockReferences.createBlock(id, registryName -> new Block(WOOD), block, item);
            }
        }
    }

    public static void setRegistrationRockModLoaded(List<String> rock, DeferredRegister.Blocks block, DeferredRegister.Items item, BlockBehaviour.Properties prop) {
        BlockBehaviour.Properties STONE = prop;
        boolean isModLoaded = ModList.get().isLoaded(modid);
        for (String i : rock) {
            for (BlockId blockId : McwBlocksIdBase.ROOFS_STONE_BLOCKS.blocks()) {
                String id = McwBlocksIdBase.replacement(blockId.id(), i);
                if (blockId.reflectedLocation().contains("StairBlock")) {
                    CreateBlockReferences.createBlockStone(id, registryName -> new StairBlock(Blocks.COBBLESTONE.defaultBlockState(), STONE), block, item);
                    continue;
                }
                if (isModLoaded) {
                    if (blockId.reflectedLocation().contains("Lower") || blockId.reflectedLocation().contains("Steep")) {
                        CreateBlockReferences.createBlockStone(id, registryName -> Registration.getBlocksField(blockId.reflectedLocation(), STONE, Blocks.COBBLESTONE.defaultBlockState()), block, item);
                        continue;
                    }
                    CreateBlockReferences.createBlockStone(id, registryName -> Registration.getBlocksField(blockId.reflectedLocation(), STONE), block, item);
                    continue;
                }
                CreateBlockReferences.createBlockStone(id, registryName -> new Block(STONE), block, item);
            }
        }
    }

    @Deprecated(forRemoval=true)
    public static void addToTab(BuildCreativeModeTabContentsEvent event, String MODID, List<String> WOOD, CreativeModeTab tab) {
        if (event.getTab() == tab && ModList.get().isLoaded(modid)) {
            for (String i : WOOD) {
                Block cherry_roof = Finder.findBlock(MODID, i + "_roof");
                Block cherry_attic_roof = Finder.findBlock(MODID, i + "_attic_roof");
                Block cherry_top_roof = Finder.findBlock(MODID, i + "_top_roof");
                Block cherry_lower_roof = Finder.findBlock(MODID, i + "_lower_roof");
                Block cherry_steep_roof = Finder.findBlock(MODID, i + "_steep_roof");
                Block cherry_upper_lower_roof = Finder.findBlock(MODID, i + "_upper_lower_roof");
                Block cherry_upper_steep_roof = Finder.findBlock(MODID, i + "_upper_steep_roof");
                event.accept((ItemLike)cherry_roof);
                event.accept((ItemLike)cherry_attic_roof);
                event.accept((ItemLike)cherry_top_roof);
                event.accept((ItemLike)cherry_lower_roof);
                event.accept((ItemLike)cherry_steep_roof);
                event.accept((ItemLike)cherry_upper_lower_roof);
                event.accept((ItemLike)cherry_upper_steep_roof);
                Block cherry_planks_roof = Finder.findBlock(MODID, i + "_planks_roof");
                Block cherry_planks_attic_roof = Finder.findBlock(MODID, i + "_planks_attic_roof");
                Block cherry_planks_top_roof = Finder.findBlock(MODID, i + "_planks_top_roof");
                Block cherry_planks_lower_roof = Finder.findBlock(MODID, i + "_planks_lower_roof");
                Block cherry_planks_steep_roof = Finder.findBlock(MODID, i + "_planks_steep_roof");
                Block cherry_planks_upper_lower_roof = Finder.findBlock(MODID, i + "_planks_upper_lower_roof");
                Block cherry_planks_upper_steep_roof = Finder.findBlock(MODID, i + "_planks_upper_steep_roof");
                event.accept((ItemLike)cherry_planks_roof);
                event.accept((ItemLike)cherry_planks_attic_roof);
                event.accept((ItemLike)cherry_planks_top_roof);
                event.accept((ItemLike)cherry_planks_lower_roof);
                event.accept((ItemLike)cherry_planks_steep_roof);
                event.accept((ItemLike)cherry_planks_upper_lower_roof);
                event.accept((ItemLike)cherry_planks_upper_steep_roof);
            }
        }
    }

    @Deprecated(forRemoval=true)
    public static void addToTabStone(BuildCreativeModeTabContentsEvent event, String MODID, List<String> STONE, CreativeModeTab tab) {
        if (event.getTab() == tab && ModList.get().isLoaded(modid)) {
            for (String i : STONE) {
                Block ROOF = Finder.findBlock(MODID, i + "_roof");
                Block ATTIC_ROOF = Finder.findBlock(MODID, i + "_attic_roof");
                Block TOP_ROOF = Finder.findBlock(MODID, i + "_top_roof");
                Block LOWER_ROOF = Finder.findBlock(MODID, i + "_lower_roof");
                Block STEEP_ROOF = Finder.findBlock(MODID, i + "_steep_roof");
                Block UPPER_LOWER_ROOF = Finder.findBlock(MODID, i + "_upper_lower_roof");
                Block UPPER_STEEP_ROOF = Finder.findBlock(MODID, i + "_upper_steep_roof");
                event.accept((ItemLike)ROOF);
                event.accept((ItemLike)ATTIC_ROOF);
                event.accept((ItemLike)TOP_ROOF);
                event.accept((ItemLike)LOWER_ROOF);
                event.accept((ItemLike)STEEP_ROOF);
                event.accept((ItemLike)UPPER_LOWER_ROOF);
                event.accept((ItemLike)UPPER_STEEP_ROOF);
            }
        }
    }
}

