/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.addonslib.door;

import fr.samlegamer.addonslib.Finder;
import fr.samlegamer.addonslib.Registration;
import fr.samlegamer.addonslib.data.BlockId;
import fr.samlegamer.addonslib.data.CreateBlockReferences;
import fr.samlegamer.addonslib.data.McwBlocksIdBase;
import java.util.List;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredRegister;

public class Doors {
    public static final String modid = "mcwdoors";

    public static void setRegistrationWood(List<String> set, DeferredRegister.Blocks block, DeferredRegister.Items item) {
        BlockBehaviour.Properties JAPAN = BlockBehaviour.Properties.of().noOcclusion().strength(1.5f, 1.0f).sound(SoundType.WOOD);
        BlockBehaviour.Properties DOOR_WOOD = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ACACIA_DOOR);
        Doors.setRegistrationWoodModLoaded(set, block, item, JAPAN, DOOR_WOOD);
    }

    public static void setRegistrationWoodModLoaded(List<String> set, DeferredRegister.Blocks block, DeferredRegister.Items item, BlockBehaviour.Properties japan_door, BlockBehaviour.Properties wood_door) {
        BlockBehaviour.Properties JAPAN = japan_door;
        BlockBehaviour.Properties DOOR_WOOD = wood_door;
        boolean isModLoaded = ModList.get().isLoaded(modid);
        BlockSetType blockSetType = DOOR_WOOD.equals(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHERRY_DOOR)) ? BlockSetType.CHERRY : BlockSetType.OAK;
        for (String i : set) {
            for (BlockId blockId : McwBlocksIdBase.DOORS_WOOD_BLOCKS.blocks()) {
                String id = McwBlocksIdBase.replacement(blockId.id(), i);
                if (blockId.reflectedLocation().contains("DoorBlock")) {
                    CreateBlockReferences.createBlock(id, registryName -> new DoorBlock(blockSetType, DOOR_WOOD), block, item);
                    continue;
                }
                if (isModLoaded) {
                    CreateBlockReferences.createBlock(id, registryName -> Registration.getBlocksField(blockId.reflectedLocation(), JAPAN, blockSetType), block, item);
                    continue;
                }
                CreateBlockReferences.createBlock(id, registryName -> new DoorBlock(blockSetType, DOOR_WOOD), block, item);
            }
        }
    }

    @Deprecated(forRemoval=true)
    public static void addToTab(BuildCreativeModeTabContentsEvent event, String MODID, List<String> WOOD, CreativeModeTab tab) {
        if (event.getTab() == tab && ModList.get().isLoaded(modid)) {
            for (String i : WOOD) {
                Block japanese_door = Finder.findBlock(MODID, i + "_japanese_door");
                Block japanese2_door = Finder.findBlock(MODID, i + "_japanese2_door");
                Block barn_door = Finder.findBlock(MODID, i + "_barn_door");
                Block barn_glass_door = Finder.findBlock(MODID, i + "_barn_glass_door");
                Block modern_door = Finder.findBlock(MODID, i + "_modern_door");
                Block cottage_door = Finder.findBlock(MODID, i + "_cottage_door");
                Block classic_door = Finder.findBlock(MODID, i + "_classic_door");
                Block beach_door = Finder.findBlock(MODID, i + "_beach_door");
                Block paper_door = Finder.findBlock(MODID, i + "_paper_door");
                Block four_panel_door = Finder.findBlock(MODID, i + "_four_panel_door");
                Block tropical_door = Finder.findBlock(MODID, i + "_tropical_door");
                Block glass_door = Finder.findBlock(MODID, i + "_glass_door");
                Block stable_door = Finder.findBlock(MODID, i + "_stable_door");
                Block stable_head_door = Finder.findBlock(MODID, i + "_stable_head_door");
                Block western_door = Finder.findBlock(MODID, i + "_western_door");
                Block mystic_door = Finder.findBlock(MODID, i + "_mystic_door");
                Block nether_door = Finder.findBlock(MODID, i + "_nether_door");
                Block swamp_door = Finder.findBlock(MODID, i + "_swamp_door");
                Block bamboo_door = Finder.findBlock(MODID, i + "_bamboo_door");
                Block bark_glass_door = Finder.findBlock(MODID, i + "_bark_glass_door");
                Block waffle_door = Finder.findBlock(MODID, i + "_waffle_door");
                Block whispering_door = Finder.findBlock(MODID, i + "_whispering_door");
                event.accept((ItemLike)japanese_door);
                event.accept((ItemLike)japanese2_door);
                event.accept((ItemLike)barn_door);
                event.accept((ItemLike)barn_glass_door);
                event.accept((ItemLike)modern_door);
                event.accept((ItemLike)cottage_door);
                event.accept((ItemLike)classic_door);
                event.accept((ItemLike)beach_door);
                event.accept((ItemLike)paper_door);
                event.accept((ItemLike)four_panel_door);
                event.accept((ItemLike)tropical_door);
                event.accept((ItemLike)glass_door);
                event.accept((ItemLike)stable_door);
                event.accept((ItemLike)stable_head_door);
                event.accept((ItemLike)western_door);
                event.accept((ItemLike)mystic_door);
                event.accept((ItemLike)nether_door);
                event.accept((ItemLike)swamp_door);
                event.accept((ItemLike)bamboo_door);
                event.accept((ItemLike)bark_glass_door);
                event.accept((ItemLike)waffle_door);
                event.accept((ItemLike)whispering_door);
            }
        }
    }
}

