/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsextras.world.processor;

import com.yungnickyoung.minecraft.yungsapi.api.world.randomize.BlockStateRandomizer;
import com.yungnickyoung.minecraft.yungsextras.world.processor.INbtFeatureProcessor;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class SwampFeatureProcessor
implements INbtFeatureProcessor {
    private static final BlockStateRandomizer STONE_BRICK_SELECTOR = new BlockStateRandomizer(Blocks.STONE_BRICKS.defaultBlockState()).addBlock(Blocks.MOSSY_STONE_BRICKS.defaultBlockState(), 0.45f).addBlock(Blocks.CRACKED_STONE_BRICKS.defaultBlockState(), 0.45f);
    private static final BlockStateRandomizer STONE_BRICK_STAIRS_SELECTOR = new BlockStateRandomizer(Blocks.STONE_BRICK_STAIRS.defaultBlockState()).addBlock(Blocks.MOSSY_STONE_BRICK_STAIRS.defaultBlockState(), 0.6f);
    private static final List<Block> CANDLES = List.of(Blocks.CANDLE, Blocks.WHITE_CANDLE, Blocks.GRAY_CANDLE, Blocks.LIGHT_GRAY_CANDLE, Blocks.BROWN_CANDLE, Blocks.GREEN_CANDLE, Blocks.PURPLE_CANDLE, Blocks.BLACK_CANDLE);

    @Override
    public void processTemplate(StructureTemplate template, WorldGenLevel level, RandomSource randomSource, BlockPos cornerPos, BlockPos centerPos, StructurePlaceSettings placementSettings) {
        for (StructureTemplate.StructureBlockInfo blockInfo : template.filterBlocks(cornerPos, placementSettings, Blocks.GRAY_STAINED_GLASS)) {
            level.setBlock(blockInfo.pos(), STONE_BRICK_SELECTOR.get(randomSource), 2);
            BlockPos.MutableBlockPos mutable = blockInfo.pos().mutable().move(Direction.DOWN);
            BlockState blockState = level.getBlockState((BlockPos)mutable);
            while (blockState.isAir() || blockState.liquid() || blockState.canBeReplaced()) {
                level.setBlock((BlockPos)mutable, STONE_BRICK_SELECTOR.get(randomSource), 2);
                mutable.move(Direction.DOWN);
                blockState = level.getBlockState((BlockPos)mutable);
            }
        }
        for (StructureTemplate.StructureBlockInfo blockInfo : template.filterBlocks(cornerPos, placementSettings, Blocks.LIGHT_GRAY_STAINED_GLASS)) {
            level.setBlock(blockInfo.pos(), (BlockState)STONE_BRICK_STAIRS_SELECTOR.get(randomSource).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.Plane.HORIZONTAL.getRandomDirection(randomSource)), 2);
        }
        for (StructureTemplate.StructureBlockInfo blockInfo : template.filterBlocks(cornerPos, placementSettings, Blocks.STONE_BRICKS)) {
            level.setBlock(blockInfo.pos(), STONE_BRICK_SELECTOR.get(randomSource), 2);
        }
        for (StructureTemplate.StructureBlockInfo blockInfo : template.filterBlocks(cornerPos, placementSettings, Blocks.STONE_BRICK_STAIRS)) {
            level.setBlock(blockInfo.pos(), (BlockState)((BlockState)((BlockState)((BlockState)STONE_BRICK_STAIRS_SELECTOR.get(randomSource).setValue((Property)StairBlock.FACING, (Comparable)((Direction)blockInfo.state().getValue((Property)StairBlock.FACING)))).setValue((Property)StairBlock.HALF, (Comparable)((Half)blockInfo.state().getValue((Property)StairBlock.HALF)))).setValue((Property)StairBlock.SHAPE, (Comparable)((StairsShape)blockInfo.state().getValue((Property)StairBlock.SHAPE)))).setValue((Property)StairBlock.WATERLOGGED, (Comparable)((Boolean)blockInfo.state().getValue((Property)StairBlock.WATERLOGGED))), 2);
        }
        for (StructureTemplate.StructureBlockInfo blockInfo : template.filterBlocks(cornerPos, placementSettings, Blocks.GREEN_CANDLE)) {
            int numCandles = randomSource.nextInt(4) + 1;
            boolean lit = randomSource.nextFloat() < 0.1f;
            level.setBlock(blockInfo.pos(), (BlockState)((BlockState)SwampFeatureProcessor.getRandomCandle(randomSource).defaultBlockState().setValue((Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(numCandles))).setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(lit)), 2);
        }
    }

    private static Block getRandomCandle(RandomSource randomSource) {
        int i = randomSource.nextInt(CANDLES.size());
        return CANDLES.get(i);
    }
}

