/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterendisland.world;

import com.google.common.collect.ImmutableList;
import com.yungnickyoung.minecraft.betterendisland.BetterEndIslandCommon;
import com.yungnickyoung.minecraft.betterendisland.world.IDragonFight;
import com.yungnickyoung.minecraft.betterendisland.world.IEndSpike;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.SpikeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SpikeConfiguration;

public enum DragonRespawnStage implements StringRepresentable
{
    START("start"){

        @Override
        public void tick(ServerLevel level, EndDragonFight dragonFight, List<EndCrystal> summoningCrystals, int phaseTimer, BlockPos portalPos) {
            BlockPos beamTargetPos = new BlockPos(0, 128, 0);
            summoningCrystals.forEach(crystal -> crystal.setBeamTarget(beamTargetPos));
            ((IDragonFight)dragonFight).betterendisland$setDragonRespawnStage(PREPARING_TO_SUMMON_PILLARS);
        }
    }
    ,
    PREPARING_TO_SUMMON_PILLARS("preparing_to_summon_pillars"){

        @Override
        public void tick(ServerLevel level, EndDragonFight dragonFight, List<EndCrystal> summoningCrystals, int phaseTimer, BlockPos portalPos) {
            int totalPhaseTime = 100;
            if (phaseTimer < totalPhaseTime) {
                if (phaseTimer == 0 || phaseTimer == 50 || phaseTimer == 51 || phaseTimer == 52 || phaseTimer >= 95) {
                    DragonRespawnStage.broadcastDragonGrowlSound(level);
                }
            } else {
                ((IDragonFight)dragonFight).betterendisland$setDragonRespawnStage(SUMMONING_PILLARS);
            }
        }
    }
    ,
    SUMMONING_PILLARS("summoning_pillars"){

        @Override
        public void tick(ServerLevel level, EndDragonFight dragonFight, List<EndCrystal> summoningCrystals, int phaseTimer, BlockPos portalPos) {
            boolean isLastTickForSpike;
            int ticksPerSpike = 40;
            boolean isFirstTickForSpike = phaseTimer % ticksPerSpike == 0;
            boolean bl = isLastTickForSpike = phaseTimer % ticksPerSpike == 39;
            if (isFirstTickForSpike || isLastTickForSpike) {
                int spikeIndex = phaseTimer / ticksPerSpike;
                List allSpikes = SpikeFeature.getSpikesForLevel((WorldGenLevel)level);
                if (spikeIndex < allSpikes.size()) {
                    SpikeFeature.EndSpike spike = (SpikeFeature.EndSpike)allSpikes.get(spikeIndex);
                    int pillarHeight = (spike.getHeight() - 73) / 3;
                    if (pillarHeight == 10) {
                        pillarHeight = 9;
                    }
                    ((IEndSpike)spike).betterendisland$setCrystalYOffsetFromPillarHeight(pillarHeight);
                    int topY = BetterEndIslandCommon.betterEnd ? 70 : 60;
                    int crystalY = topY + ((IEndSpike)spike).betterendisland$getCrystalYOffset() - 1;
                    if (isFirstTickForSpike) {
                        for (EndCrystal crystal : summoningCrystals) {
                            crystal.setBeamTarget(new BlockPos(spike.getCenterX(), crystalY, spike.getCenterZ()));
                        }
                    } else {
                        level.explode(null, (double)((float)spike.getCenterX() + 0.5f), (double)crystalY, (double)((float)spike.getCenterZ() + 0.5f), 5.0f, Level.ExplosionInteraction.BLOCK);
                        level.players().forEach(player -> {
                            level.sendParticles(player, (ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, true, (double)((float)spike.getCenterX() - 5.0f), (double)crystalY, (double)((float)spike.getCenterZ() - 5.0f), 1, 0.0, 0.0, 0.0, 0.0);
                            level.sendParticles(player, (ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, true, (double)((float)spike.getCenterX() - 5.0f), (double)crystalY, (double)((float)spike.getCenterZ() + 5.0f), 1, 0.0, 0.0, 0.0, 0.0);
                            level.sendParticles(player, (ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, true, (double)((float)spike.getCenterX() + 5.0f), (double)crystalY, (double)((float)spike.getCenterZ() - 5.0f), 1, 0.0, 0.0, 0.0, 0.0);
                            level.sendParticles(player, (ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, true, (double)((float)spike.getCenterX() + 5.0f), (double)crystalY, (double)((float)spike.getCenterZ() + 5.0f), 1, 0.0, 0.0, 0.0, 0.0);
                            if (player.distanceToSqr((double)spike.getCenterX(), (double)crystalY, (double)spike.getCenterZ()) > 32.0) {
                                level.playSound(null, new BlockPos(spike.getCenterX(), crystalY, spike.getCenterZ()), (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.NEUTRAL, 24.0f, 1.0f);
                            }
                        });
                        int resetRadius = 11;
                        int verticalRadius = BetterEndIslandCommon.betterEnd ? 40 : 30;
                        for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)new BlockPos(spike.getCenterX() - resetRadius, spike.getHeight() - verticalRadius, spike.getCenterZ() - resetRadius), (BlockPos)new BlockPos(spike.getCenterX() + resetRadius, spike.getHeight() + verticalRadius, spike.getCenterZ() + resetRadius))) {
                            if (level.getBlockState(blockPos).is(Blocks.END_STONE)) continue;
                            level.removeBlock(blockPos, false);
                        }
                        SpikeConfiguration spikeConfig = new SpikeConfiguration(true, (List)ImmutableList.of((Object)spike), new BlockPos(0, 128, 0));
                        Feature.END_SPIKE.place((FeatureConfiguration)spikeConfig, (WorldGenLevel)level, level.getChunkSource().getGenerator(), RandomSource.create(), new BlockPos(spike.getCenterX(), 45, spike.getCenterZ()));
                    }
                } else if (isFirstTickForSpike) {
                    ((IDragonFight)dragonFight).betterendisland$setDragonRespawnStage(SUMMONING_DRAGON);
                }
            }
        }
    }
    ,
    SUMMONING_DRAGON("summoning_dragon"){

        @Override
        public void tick(ServerLevel level, EndDragonFight dragonFight, List<EndCrystal> summoningCrystals, int phaseTimer, BlockPos portalPos) {
            int totalPhaseTime = 100;
            if (phaseTimer >= totalPhaseTime) {
                ((IDragonFight)dragonFight).betterendisland$setDragonRespawnStage(END);
                dragonFight.resetSpikeCrystals();
                for (EndCrystal crystal : summoningCrystals) {
                    crystal.setBeamTarget(null);
                    level.explode((Entity)crystal, crystal.getX(), crystal.getY(), crystal.getZ(), 6.0f, Level.ExplosionInteraction.NONE);
                    crystal.discard();
                }
            } else if (phaseTimer >= 80) {
                DragonRespawnStage.broadcastDragonGrowlSound(level);
            } else if (phaseTimer == 0) {
                for (EndCrystal crystal : summoningCrystals) {
                    crystal.setBeamTarget(new BlockPos(0, 128, 0));
                }
            } else if (phaseTimer < 5) {
                DragonRespawnStage.broadcastDragonGrowlSound(level);
            }
        }
    }
    ,
    END("end"){

        @Override
        public void tick(ServerLevel level, EndDragonFight dragonFight, List<EndCrystal> summoningCrystals, int phaseTimer, BlockPos portalPos) {
        }
    };

    public static final StringRepresentable.EnumCodec<DragonRespawnStage> CODEC;
    private final String name;

    @Nullable
    public static DragonRespawnStage byName(@Nullable String name) {
        return (DragonRespawnStage)CODEC.byName(name);
    }

    private DragonRespawnStage(String name) {
        this.name = name.toLowerCase();
    }

    public String getSerializedName() {
        return this.name;
    }

    private static void broadcastDragonGrowlSound(ServerLevel level) {
        level.levelEvent(3001, new BlockPos(0, 128, 0), 0);
    }

    public abstract void tick(ServerLevel var1, EndDragonFight var2, List<EndCrystal> var3, int var4, BlockPos var5);

    static {
        CODEC = StringRepresentable.fromEnum(DragonRespawnStage::values);
    }
}

