/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdeserttemples.mixin.pharaoh;

import com.yungnickyoung.minecraft.betterdeserttemples.BetterDesertTemplesCommon;
import com.yungnickyoung.minecraft.betterdeserttemples.entity.IPharaohData;
import com.yungnickyoung.minecraft.betterdeserttemples.module.TagModule;
import com.yungnickyoung.minecraft.betterdeserttemples.util.PharaohUtil;
import com.yungnickyoung.minecraft.betterdeserttemples.world.state.ITempleStateCacheProvider;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    public LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"die"}, at={@At(value="HEAD")})
    private void betterdeserttemples_clearTempleOnPharaohDeath(DamageSource damageSource, CallbackInfo info) {
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (!PharaohUtil.isPharaoh((Object)this)) {
            return;
        }
        Vec3 originalSpawnPos = ((IPharaohData)((Object)this)).getOriginalSpawnPos();
        if (originalSpawnPos == null) {
            BetterDesertTemplesCommon.LOGGER.error("Pharaoh entity is missing original spawn position data. Attempting to clear the temple it's inside of instead...");
            this.tryClearTempleAtPosition(serverLevel, this.blockPosition(), damageSource);
        } else {
            BlockPos pharaohSpawnPos = new BlockPos((int)originalSpawnPos.x, (int)originalSpawnPos.y, (int)originalSpawnPos.z);
            this.tryClearTempleAtPosition(serverLevel, pharaohSpawnPos, damageSource);
        }
    }

    @Unique
    private void tryClearTempleAtPosition(ServerLevel serverLevel, BlockPos pos, DamageSource damageSource) {
        StructureStart structureStart = serverLevel.structureManager().getStructureWithPieceAt(pos, TagModule.APPLIES_MINING_FATIGUE);
        if (structureStart.isValid()) {
            ServerPlayer killer;
            BlockPos structureStartPos = structureStart.getChunkPos().getWorldPosition();
            ((ITempleStateCacheProvider)this.level()).getTempleStateCache().setTempleCleared(structureStartPos, true);
            List<ServerPlayer> playersInTemple = serverLevel.players().stream().filter(player -> this.level().isLoaded(player.blockPosition()) && serverLevel.structureManager().getStructureWithPieceAt(player.blockPosition(), TagModule.APPLIES_MINING_FATIGUE).isValid()).toList();
            playersInTemple.forEach(player -> {
                player.connection.send((Packet)new ClientboundSoundPacket(BuiltInRegistries.SOUND_EVENT.wrapAsHolder((Object)SoundEvents.BEACON_DEACTIVATE), SoundSource.HOSTILE, this.getX(), this.getY(), this.getZ(), 1.0f, 1.0f, serverLevel.getSeed()));
                player.removeEffect(MobEffects.DIG_SLOWDOWN);
            });
            Entity entity = damageSource.getEntity();
            if (entity instanceof ServerPlayer && !playersInTemple.contains(killer = (ServerPlayer)entity)) {
                killer.connection.send((Packet)new ClientboundSoundPacket(BuiltInRegistries.SOUND_EVENT.wrapAsHolder((Object)SoundEvents.BEACON_DEACTIVATE), SoundSource.HOSTILE, this.getX(), this.getY(), this.getZ(), 1.0f, 1.0f, serverLevel.getSeed()));
                killer.removeEffect(MobEffects.DIG_SLOWDOWN);
            }
            BetterDesertTemplesCommon.LOGGER.info("Cleared Better Desert Temple at x={}, z={}", (Object)structureStartPos.getX(), (Object)structureStartPos.getZ());
        } else {
            BetterDesertTemplesCommon.LOGGER.error("Position provided is not inside a Better Desert Temple. Unable to clear temple.");
        }
    }
}

