/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.undeadnights.entity.ai.goal;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.petemc.undeadnights.entity.DemolitionZombieEntity;
import org.jetbrains.annotations.Nullable;

public class TntIgniteAndThrowGoal
extends Goal {
    private final DemolitionZombieEntity demolitionZombie;
    private int tntCoolDown = 5;
    @Nullable
    private LivingEntity target;

    public TntIgniteAndThrowGoal(DemolitionZombieEntity demolitionZombie) {
        this.demolitionZombie = demolitionZombie;
    }

    public boolean canUse() {
        LivingEntity target = this.demolitionZombie.getTarget();
        if (!(target instanceof Player)) {
            return false;
        }
        return this.demolitionZombie.distanceToSqr((Entity)target) < 18.0;
    }

    public void start() {
        this.target = this.demolitionZombie.getTarget();
    }

    public void stop() {
        this.target = null;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        BlockPos pos = this.demolitionZombie.blockPosition();
        if (this.tntCoolDown <= 0) {
            if (this.target != null && this.demolitionZombie.distanceToSqr((Entity)this.target) < 18.0 && this.demolitionZombie.distanceToSqr((Entity)this.target) > 5.0 && this.demolitionZombie.getSensing().hasLineOfSight((Entity)this.target) && this.demolitionZombie.getMainHandItem().getCount() > 0) {
                PrimedTnt tntEntity = new PrimedTnt(this.demolitionZombie.level(), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (LivingEntity)this.demolitionZombie);
                RandomSource random = RandomSource.create();
                double d0 = this.target.getY() + (double)this.target.getEyeHeight() - 1.1;
                double d1 = this.target.getX() - this.demolitionZombie.getX();
                double d3 = this.target.getZ() - this.demolitionZombie.getZ();
                double pX = d1;
                double pY = d0 - tntEntity.getY() + Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f;
                double pZ = d3;
                double pVelocity = 0.8f;
                double pInaccuracy = 12.0;
                Vec3 vec3 = new Vec3(pX, pY, pZ).normalize().add(random.triangle(0.0, 0.0172275 * pInaccuracy), random.triangle(0.0, 0.0172275 * pInaccuracy), random.triangle(0.0, 0.0172275 * pInaccuracy)).scale(pVelocity);
                tntEntity.setDeltaMovement(vec3);
                double d0a = vec3.horizontalDistance();
                tntEntity.setYRot((float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 57.2957763671875));
                tntEntity.setXRot((float)(Mth.atan2((double)vec3.y, (double)d0a) * 57.2957763671875));
                tntEntity.yRotO = tntEntity.getYRot();
                tntEntity.xRotO = tntEntity.getXRot();
                this.demolitionZombie.level().addFreshEntity((Entity)tntEntity);
                this.demolitionZombie.level().playSound(null, tntEntity.getX(), tntEntity.getY(), tntEntity.getZ(), SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (this.demolitionZombie.getNumberTnt() != 0) {
                    this.demolitionZombie.getMainHandItem().shrink(1);
                }
                this.tntCoolDown = 100;
            }
        } else {
            --this.tntCoolDown;
        }
        super.tick();
    }
}

