/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.undeadnights.entity.ai.goal;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.petemc.undeadnights.UndeadNights;
import net.petemc.undeadnights.casts.BlockBreakingZombie;
import net.petemc.undeadnights.command.HordeMobsCommand;
import net.petemc.undeadnights.config.MainConfig;
import net.petemc.undeadnights.entity.EliteZombieEntity;
import net.petemc.undeadnights.entity.HordeZombieEntity;

public class BreakBlockGoal
extends Goal {
    private final Zombie mob;
    private final float breakProgressPerTick = 0.04f;
    private BlockPos targetBlock;
    private float scaledTargetDestroyTime;
    private float breakProgress;
    private float ratio;

    public BreakBlockGoal(Zombie mob) {
        this.mob = mob;
    }

    public static float blockPosDistance(Entity entity, BlockPos pos) {
        return BreakBlockGoal.blockPosDistance(entity.blockPosition(), pos);
    }

    public static float blockPosDistance(BlockPos pos1, BlockPos pos2) {
        float x = pos1.getX() - pos2.getX();
        float y = pos1.getY() - pos2.getY();
        float z = pos1.getZ() - pos2.getZ();
        return Mth.sqrt((float)(x * x + y * y + z * z));
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public boolean canContinueToUse() {
        return BreakBlockGoal.blockPosDistance((Entity)this.mob, this.targetBlock) <= 3.0f && this.breakProgress <= this.scaledTargetDestroyTime;
    }

    public void start() {
        Zombie zombie = this.mob;
        if (zombie instanceof HordeZombieEntity) {
            HordeZombieEntity hordeZombie = (HordeZombieEntity)zombie;
            hordeZombie.setBreakingBlock(true);
        }
        if ((zombie = this.mob) instanceof EliteZombieEntity) {
            EliteZombieEntity eliteZombie = (EliteZombieEntity)zombie;
            eliteZombie.setBreakingBlock(true);
        }
        if ((zombie = this.mob) instanceof BlockBreakingZombie) {
            BlockBreakingZombie zombie2 = (BlockBreakingZombie)zombie;
            zombie2.setBreakingBlock(true);
        }
    }

    public boolean isInterruptable() {
        return false;
    }

    public void tick() {
        this.breakProgress += 0.04f;
        this.mob.swing(InteractionHand.MAIN_HAND);
        if (this.breakProgress >= this.scaledTargetDestroyTime) {
            this.mob.level().destroyBlock(this.targetBlock, true);
            return;
        }
        this.mob.level().destroyBlockProgress(this.mob.getId(), this.targetBlock, (int)(this.breakProgress * this.ratio));
    }

    public void stop() {
        this.mob.level().destroyBlockProgress(this.mob.getId(), this.targetBlock, 0);
        this.breakProgress = 0.0f;
        this.targetBlock = null;
        this.scaledTargetDestroyTime = 0.0f;
        Zombie zombie = this.mob;
        if (zombie instanceof HordeZombieEntity) {
            HordeZombieEntity hordeZombie = (HordeZombieEntity)zombie;
            hordeZombie.setBreakingBlock(false);
        }
        this.mob.getNavigation().recomputePath();
    }

    public boolean canUse() {
        if (!HordeMobsCommand.hordeZombiesCanBreakBlocks) {
            return false;
        }
        LivingEntity targetEntity = this.mob.getTarget();
        if (targetEntity == null) {
            return false;
        }
        if (this.mob.getRandom().nextFloat() < 0.5f) {
            return false;
        }
        Level world = this.mob.level();
        Direction direction = this.mob.getDirection();
        BlockPos blockPos = this.mob.blockPosition();
        blockPos = blockPos.offset(direction.getNormal()).offset(0, 1, 0);
        if (!this.mob.getNavigation().isDone()) {
            return false;
        }
        int yDistance = Math.abs(targetEntity.getBlockY() - this.mob.getBlockY());
        int yCheckModifier = yDistance > 2 ? ((double)targetEntity.getBlockY() > this.mob.getY() ? 1 : -2) : -1;
        BlockState state = world.getBlockState(blockPos);
        Block block = state.getBlock();
        if ((block instanceof AirBlock || block.isPossibleToRespawnInThis(state)) && ((block = (state = world.getBlockState(blockPos = blockPos.offset(0, yCheckModifier, 0))).getBlock()) instanceof AirBlock || block.isPossibleToRespawnInThis(state))) {
            return false;
        }
        this.targetBlock = blockPos;
        float destroyTime = world.getBlockState(this.targetBlock).getBlock().defaultDestroyTime();
        this.scaledTargetDestroyTime = destroyTime * 2.0f;
        if (MainConfig.getPrintDebugMessages()) {
            UndeadNights.LOGGER.info("Block: {} destroyTime: {} Stage: {}", new Object[]{world.getBlockState(this.targetBlock).getBlock(), Float.valueOf(world.getBlockState(this.targetBlock).getBlock().defaultDestroyTime()), MainConfig.getZombiesBlockBreakTier()});
        }
        if (block instanceof DoorBlock && destroyTime == 3.0f) {
            this.ratio = 10.0f / this.scaledTargetDestroyTime;
            return true;
        }
        String blockName = world.getBlockState(this.targetBlock).getBlock().toString();
        if (blockName.contains("securitycraft") && blockName.contains("reinforced") && MainConfig.getSecurityCraftCompatibility()) {
            return false;
        }
        if (this.scaledTargetDestroyTime < 0.0f) {
            return false;
        }
        if (destroyTime > 0.6f && HordeMobsCommand.hordeZombiesBlockBreakingTier <= 1) {
            return false;
        }
        if (destroyTime > 3.0f && HordeMobsCommand.hordeZombiesBlockBreakingTier == 2) {
            return false;
        }
        if (destroyTime > 20.0f && HordeMobsCommand.hordeZombiesBlockBreakingTier == 3) {
            return false;
        }
        if (destroyTime > 75.0f) {
            return false;
        }
        if (destroyTime >= 50.0f) {
            this.scaledTargetDestroyTime = 25.0f;
        }
        this.ratio = 10.0f / this.scaledTargetDestroyTime;
        return true;
    }
}

