/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.undeadnights.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.petemc.undeadnights.UndeadNights;
import net.petemc.undeadnights.config.HordeConfig;
import net.petemc.undeadnights.config.MainConfig;
import net.petemc.undeadnights.world.spawner.UndeadSpawner;

public class HordeMobsCommand {
    public static boolean hordeZombiesCanBreakBlocks = false;
    public static int hordeZombiesBlockBreakingTier = 1;

    public HordeMobsCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"undeadnights").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"horde_mobs").then(Commands.literal((String)"remove_all").executes(command -> this.removeMobs((CommandSourceStack)command.getSource())))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"undeadnights").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"horde_mobs").then(Commands.literal((String)"print_config").executes(command -> this.printConfig((CommandSourceStack)command.getSource())))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"undeadnights").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"horde_mobs").then(Commands.literal((String)"block_breaking").then(Commands.literal((String)"enable").executes(command -> this.blockBreaking((CommandSourceStack)command.getSource(), true, 0))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"undeadnights").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"horde_mobs").then(Commands.literal((String)"block_breaking").then(Commands.literal((String)"disable").executes(command -> this.blockBreaking((CommandSourceStack)command.getSource(), false, 0))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"undeadnights").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"horde_mobs").then(Commands.literal((String)"block_breaking").then(Commands.literal((String)"set_tier").then(Commands.argument((String)"tierValue", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(command -> this.blockBreaking((CommandSourceStack)command.getSource(), false, IntegerArgumentType.getInteger((CommandContext)command, (String)"tierValue"))))))));
    }

    private int removeMobs(CommandSourceStack source) throws CommandSyntaxException {
        int count = 0;
        Objects.requireNonNull(source.getEntity()).sendSystemMessage((Component)Component.translatable((String)"message.undeadnights.command_remove_horde_mobs"));
        for (UUID hordeMobUUID : UndeadNights.serverState.spawnedHordeMobs.stream().toList()) {
            ++count;
            Entity entity = (Entity)source.getLevel().getEntities().get(hordeMobUUID);
            if (entity != null) {
                entity.discard();
                continue;
            }
            UndeadNights.serverState.hordeMobsToRemove.add(hordeMobUUID);
        }
        if (MainConfig.getPrintDebugMessages()) {
            UndeadNights.LOGGER.info("{} horde mobs removed or marked for removal", (Object)count);
        }
        return 0;
    }

    private int printConfig(CommandSourceStack source) throws CommandSyntaxException {
        if (HordeConfig.getReadingConfigFailed()) {
            Objects.requireNonNull(source.getEntity()).sendSystemMessage((Component)Component.literal((String)"Reading the horde mob config failed!\nSpawning 15 default horde zombies instead.\nPlease check: https://github.com/MC-Mods-Pete/UndeadNights/wiki").withStyle(ChatFormatting.YELLOW));
            return 0;
        }
        StringBuilder message = new StringBuilder("Variant: " + HordeConfig.getConfigVariant() + "\n");
        if (HordeConfig.getConfigVariant() == 1) {
            message.append("defaultHordeMob: ").append(HordeConfig.getDefaultHordeMob().mobId()).append("\n");
            if (!HordeConfig.getHordeMobs().isEmpty()) {
                for (HordeConfig.MobSpawnData hordeMob : HordeConfig.getHordeMobs()) {
                    message.append(hordeMob.mobId()).append(" chance: ").append(hordeMob.chance()).append("\n");
                }
            }
        } else if (!HordeConfig.getHordes().isEmpty()) {
            for (HordeConfig.HordesData horde : HordeConfig.getHordes()) {
                message.append("hordeId: ").append(horde.hordeId()).append("\n");
                message.append("hordeName: ").append(horde.hordeName()).append("\n");
                if (horde.hordeMobs().isEmpty()) continue;
                for (HordeConfig.MobSpawnData hordeMob : horde.hordeMobs()) {
                    message.append(hordeMob.mobId());
                    if (hordeMob.countMin() >= hordeMob.countMax()) {
                        message.append(" count: ").append(hordeMob.countMin()).append("\n");
                        continue;
                    }
                    message.append(" count: ").append(hordeMob.countMin()).append("-").append(hordeMob.countMax()).append("\n");
                }
            }
        }
        Objects.requireNonNull(source.getEntity()).sendSystemMessage((Component)Component.literal((String)message.toString()));
        if (UndeadSpawner.invalidHordeMobEntry) {
            Objects.requireNonNull(source.getEntity()).sendSystemMessage((Component)Component.literal((String)"A horde mob entry in the horde mob config could not be read!\nA default horde zombie will be spawned instead.\nPlease check: https://github.com/MC-Mods-Pete/UndeadNights/wiki").withStyle(ChatFormatting.YELLOW));
        }
        return 0;
    }

    private int blockBreaking(CommandSourceStack source, boolean value, int tier) throws CommandSyntaxException {
        if (tier == 0) {
            hordeZombiesCanBreakBlocks = value;
            Objects.requireNonNull(source.getEntity()).sendSystemMessage((Component)Component.literal((String)("Block breaking for Horde and Elite Zombies " + (value ? "enabled" : "disabled"))));
        } else {
            hordeZombiesBlockBreakingTier = tier;
            Objects.requireNonNull(source.getEntity()).sendSystemMessage((Component)Component.literal((String)("Setting block breaking tier " + tier)));
        }
        return 0;
    }
}

