/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.travelerstitles.module;

import com.google.common.collect.Lists;
import com.yungnickyoung.minecraft.travelerstitles.TravelersTitlesCommon;
import com.yungnickyoung.minecraft.travelerstitles.TravelersTitlesNeoForge;
import com.yungnickyoung.minecraft.travelerstitles.config.TTConfigNeoForge;
import com.yungnickyoung.minecraft.travelerstitles.module.ConfigModule;
import java.util.ArrayList;
import java.util.List;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.LevelEvent;

public class ConfigModuleNeoForge {
    public static void init(ModContainer container) {
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)TTConfigNeoForge.SPEC, "travelerstitles-neoforge-1_21.toml");
        NeoForge.EVENT_BUS.addListener(ConfigModuleNeoForge::onWorldLoad);
        TravelersTitlesNeoForge.loadingContextEventBus.addListener(ConfigModuleNeoForge::configChanged);
    }

    public static void onWorldLoad(LevelEvent.Load event) {
        ConfigModuleNeoForge.bakeConfig();
        ConfigModule.updateRenderersFromConfig();
    }

    public static void configChanged(ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == TTConfigNeoForge.SPEC) {
            ConfigModuleNeoForge.bakeConfig();
            ConfigModule.updateRenderersFromConfig();
        }
    }

    public static void bakeConfig() {
        TravelersTitlesCommon.CONFIG.biomes.enabled = (Boolean)TTConfigNeoForge.biomes.enabled.get();
        TravelersTitlesCommon.CONFIG.biomes.textFadeInTime = (Integer)TTConfigNeoForge.biomes.textFadeInTime.get();
        TravelersTitlesCommon.CONFIG.biomes.textDisplayTime = (Integer)TTConfigNeoForge.biomes.textDisplayTime.get();
        TravelersTitlesCommon.CONFIG.biomes.textFadeOutTime = (Integer)TTConfigNeoForge.biomes.textFadeOutTime.get();
        TravelersTitlesCommon.CONFIG.biomes.textCooldownTime = (Integer)TTConfigNeoForge.biomes.textCooldownTime.get();
        TravelersTitlesCommon.CONFIG.biomes.textColor = (String)TTConfigNeoForge.biomes.textColor.get();
        TravelersTitlesCommon.CONFIG.biomes.textSize = (Double)TTConfigNeoForge.biomes.textSize.get();
        TravelersTitlesCommon.CONFIG.biomes.renderShadow = (Boolean)TTConfigNeoForge.biomes.renderShadow.get();
        TravelersTitlesCommon.CONFIG.biomes.textYOffset = (Integer)TTConfigNeoForge.biomes.textYOffset.get();
        TravelersTitlesCommon.CONFIG.biomes.textXOffset = (Integer)TTConfigNeoForge.biomes.textXOffset.get();
        TravelersTitlesCommon.CONFIG.biomes.recentBiomeCacheSize = (Integer)TTConfigNeoForge.biomes.recentBiomeCacheSize.get();
        TravelersTitlesCommon.CONFIG.biomes.centerText = (Boolean)TTConfigNeoForge.biomes.centerText.get();
        TravelersTitlesCommon.CONFIG.biomes.resetBiomeCacheOnDimensionChange = (Boolean)TTConfigNeoForge.biomes.resetBiomeCacheOnDimensionChange.get();
        TravelersTitlesCommon.CONFIG.biomes.onlyUpdateAtSurface = (Boolean)TTConfigNeoForge.biomes.onlyUpdateAtSurface.get();
        TravelersTitlesCommon.CONFIG.biomes.biomeBlacklist = ConfigModuleNeoForge.parseList((String)TTConfigNeoForge.biomes.biomeBlacklist.get(), "Blacklisted Biomes");
        TravelersTitlesCommon.CONFIG.dimensions.enabled = (Boolean)TTConfigNeoForge.dimensions.enabled.get();
        TravelersTitlesCommon.CONFIG.dimensions.textFadeInTime = (Integer)TTConfigNeoForge.dimensions.textFadeInTime.get();
        TravelersTitlesCommon.CONFIG.dimensions.textDisplayTime = (Integer)TTConfigNeoForge.dimensions.textDisplayTime.get();
        TravelersTitlesCommon.CONFIG.dimensions.textFadeOutTime = (Integer)TTConfigNeoForge.dimensions.textFadeOutTime.get();
        TravelersTitlesCommon.CONFIG.dimensions.textColor = (String)TTConfigNeoForge.dimensions.textColor.get();
        TravelersTitlesCommon.CONFIG.dimensions.textSize = (Double)TTConfigNeoForge.dimensions.textSize.get();
        TravelersTitlesCommon.CONFIG.dimensions.renderShadow = (Boolean)TTConfigNeoForge.dimensions.renderShadow.get();
        TravelersTitlesCommon.CONFIG.dimensions.textYOffset = (Integer)TTConfigNeoForge.dimensions.textYOffset.get();
        TravelersTitlesCommon.CONFIG.dimensions.textXOffset = (Integer)TTConfigNeoForge.dimensions.textXOffset.get();
        TravelersTitlesCommon.CONFIG.dimensions.centerText = (Boolean)TTConfigNeoForge.dimensions.centerText.get();
        TravelersTitlesCommon.CONFIG.dimensions.onlyUpdateAtSurface = (Boolean)TTConfigNeoForge.dimensions.onlyUpdateAtSurface.get();
        TravelersTitlesCommon.CONFIG.dimensions.dimensionBlacklist = ConfigModuleNeoForge.parseList((String)TTConfigNeoForge.dimensions.dimensionBlacklist.get(), "Blacklisted Dimensions");
        TravelersTitlesCommon.CONFIG.sound.biomeVolume = (Double)TTConfigNeoForge.sound.biomeVolume.get();
        TravelersTitlesCommon.CONFIG.sound.biomePitch = (Double)TTConfigNeoForge.sound.biomePitch.get();
        TravelersTitlesCommon.CONFIG.sound.dimensionVolume = (Double)TTConfigNeoForge.sound.dimensionVolume.get();
        TravelersTitlesCommon.CONFIG.sound.dimensionPitch = (Double)TTConfigNeoForge.sound.dimensionPitch.get();
        TravelersTitlesCommon.CONFIG.sound.waystoneVolume = (Double)TTConfigNeoForge.sound.waystoneVolume.get();
        TravelersTitlesCommon.CONFIG.sound.waystonePitch = (Double)TTConfigNeoForge.sound.waystonePitch.get();
        TravelersTitlesCommon.CONFIG.waystones.enabled = (Boolean)TTConfigNeoForge.waystones.enabled.get();
        TravelersTitlesCommon.CONFIG.waystones.textFadeInTime = (Integer)TTConfigNeoForge.waystones.textFadeInTime.get();
        TravelersTitlesCommon.CONFIG.waystones.textDisplayTime = (Integer)TTConfigNeoForge.waystones.textDisplayTime.get();
        TravelersTitlesCommon.CONFIG.waystones.textFadeOutTime = (Integer)TTConfigNeoForge.waystones.textFadeOutTime.get();
        TravelersTitlesCommon.CONFIG.waystones.textCooldownTime = (Integer)TTConfigNeoForge.waystones.textCooldownTime.get();
        TravelersTitlesCommon.CONFIG.waystones.textColor = (String)TTConfigNeoForge.waystones.textColor.get();
        TravelersTitlesCommon.CONFIG.waystones.textSize = (Double)TTConfigNeoForge.waystones.textSize.get();
        TravelersTitlesCommon.CONFIG.waystones.renderShadow = (Boolean)TTConfigNeoForge.waystones.renderShadow.get();
        TravelersTitlesCommon.CONFIG.waystones.textYOffset = (Integer)TTConfigNeoForge.waystones.textYOffset.get();
        TravelersTitlesCommon.CONFIG.waystones.textXOffset = (Integer)TTConfigNeoForge.waystones.textXOffset.get();
        TravelersTitlesCommon.CONFIG.waystones.recentWaystoneCacheSize = (Integer)TTConfigNeoForge.waystones.recentWaystoneCacheSize.get();
        TravelersTitlesCommon.CONFIG.waystones.centerText = (Boolean)TTConfigNeoForge.waystones.centerText.get();
        TravelersTitlesCommon.CONFIG.waystones.resetWaystoneCacheOnDimensionChange = (Boolean)TTConfigNeoForge.waystones.resetWaystoneCacheOnDimensionChange.get();
        TravelersTitlesCommon.CONFIG.waystones.range = (Integer)TTConfigNeoForge.waystones.range.get();
        TravelersTitlesCommon.CONFIG.waystones.waystonesOverrideBiomeTitle = (Boolean)TTConfigNeoForge.waystones.waystonesOverrideBiomeTitle.get();
        TravelersTitlesCommon.CONFIG.waystones.onlyUpdateAtSurface = (Boolean)TTConfigNeoForge.waystones.onlyUpdateAtSurface.get();
    }

    private static List<String> parseList(String rawStringOfList, String settingName) {
        int strLen = rawStringOfList.length();
        if (strLen < 2 || rawStringOfList.charAt(0) != '[' || rawStringOfList.charAt(strLen - 1) != ']') {
            TravelersTitlesCommon.LOGGER.error("INVALID VALUE FOR SETTING '" + settingName + "'. Using empty list instead...");
            return new ArrayList<String>();
        }
        return Lists.newArrayList((Object[])rawStringOfList.substring(1, strLen - 1).split(",\\s*"));
    }
}

