/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.travelerstitles.config;

import net.neoforged.neoforge.common.ModConfigSpec;

public class ConfigWaystonesNeoForge {
    public final ModConfigSpec.ConfigValue<Boolean> enabled;
    public final ModConfigSpec.ConfigValue<Integer> textFadeInTime;
    public final ModConfigSpec.ConfigValue<Integer> textDisplayTime;
    public final ModConfigSpec.ConfigValue<Integer> textFadeOutTime;
    public final ModConfigSpec.ConfigValue<Integer> textCooldownTime;
    public final ModConfigSpec.ConfigValue<String> textColor;
    public final ModConfigSpec.ConfigValue<Double> textSize;
    public final ModConfigSpec.ConfigValue<Boolean> renderShadow;
    public final ModConfigSpec.ConfigValue<Integer> textYOffset;
    public final ModConfigSpec.ConfigValue<Integer> textXOffset;
    public final ModConfigSpec.ConfigValue<Integer> recentWaystoneCacheSize;
    public final ModConfigSpec.ConfigValue<Boolean> centerText;
    public final ModConfigSpec.ConfigValue<Boolean> resetWaystoneCacheOnDimensionChange;
    public final ModConfigSpec.ConfigValue<Integer> range;
    public final ModConfigSpec.ConfigValue<Boolean> waystonesOverrideBiomeTitle;
    public final ModConfigSpec.ConfigValue<Boolean> onlyUpdateAtSurface;

    public ConfigWaystonesNeoForge(ModConfigSpec.Builder BUILDER) {
        BUILDER.comment("##########################################################################################################\n# Waystone title settings. Only used if the Waystones mod is installed.\n##########################################################################################################").push("Waystone Titles");
        this.enabled = BUILDER.define("Enable Waystone Titles", true);
        this.textFadeInTime = BUILDER.comment(" How long the fade-in text effect lasts, in ticks.\n 20 ticks = 1 second.\n Default: 10").define("Text Fade-In Time", (Object)10);
        this.textDisplayTime = BUILDER.comment(" How long the text displays, in ticks.\n 20 ticks = 1 second.\n Default: 50").define("Text Display Time", (Object)50);
        this.textFadeOutTime = BUILDER.comment(" How long the fade-out text effect lasts, in ticks.\n 20 ticks = 1 second.\n Default: 10").define("Text Fade-Out Time", (Object)10);
        this.textCooldownTime = BUILDER.comment(" The minimum amount of time in ticks that must pass after a Waystone title is displayed before\n another can be displayed.\n Useful for preventing the player from being spammed if they are traveling quickly.\n 20 ticks = 1 second.\n Default: 80").define("Text Cooldown Time", (Object)80);
        this.textColor = BUILDER.comment(" The text's default RGB color.\n Default: \"c2b740\"").define("Default Text Color", (Object)"c2b740");
        this.textSize = BUILDER.comment(" The text's scale.\n Default: 2.1").define("Text Size", (Object)2.1);
        this.renderShadow = BUILDER.comment(" If enabled, will render a shadow below the text making it easier to read.\n Default: true").define("Display Text Shadow", true);
        this.textYOffset = BUILDER.comment(" The text's vertical position on the screen.\n If Horizontally Center Title is enabled, this number is relative to the center of the screen.\n If Horizontally Center Title is disabled, this number is relative to the top of the screen.\n Default: -33.0").define("Text Y Offset", (Object)-33);
        this.textXOffset = BUILDER.comment(" The text's horizontal position on the screen.\n If Horizontally Center Title is enabled, this number is relative to the center of the screen.\n If Horizontally Center Title is disabled, this number is relative to the left side of the screen.\n Default: 0.0").define("Text X Offset", (Object)0);
        this.recentWaystoneCacheSize = BUILDER.comment(" Traveler's Titles tracks a list of Waystones the player most recently visited in order to\n prevent the player from being spammed with titles when they move between the same few Waystones.\n This is the size of that list.\n For example, if this value is 5, then your 5 most recent Waystones will be saved.\n Default: 3").define("Number of Most Recent Waystones Saved", (Object)3);
        this.centerText = BUILDER.comment(" Whether or not the Waystone text should be centered on the screen.\n The Text X Offset and Text Y Offset options are relative to the center of the screen if this is enabled.\n Default: true").define("Center Title", true);
        this.resetWaystoneCacheOnDimensionChange = BUILDER.comment(" Traveler's Titles tracks a list of Waystones the player most recently visited in order to\n prevent the player from being spammed with titles when they move between the same few Waystones.\n This option determines whether or not that list should be cleared every time\n the player changes dimensions.\n Default: true").define("Reset Waystone Cache When Changing Dimensions", true);
        this.range = BUILDER.comment(" The distance from a Waystone (in blocks) at which the Waystone's title will trigger.\n Default: 30").define("Waystone Title Range", (Object)30);
        this.waystonesOverrideBiomeTitle = BUILDER.comment(" Whether or not Waystone titles should override Biome titles.\n That is, if a player enters the area for a Waystone while also entering a new biome,\n the Waystone title will take precedence.\n Default: true").define("Waystone Titles Override Biome Titles", true);
        this.onlyUpdateAtSurface = BUILDER.comment(" If enabled, dimensions without ceilings (like the Overworld) will only display Waystone titles when the player is exposed to the skylight.\n This prevents Waystone titles from showing while the player is underground.\n Default: false").define("Only Show Waystone Titles When Exposed To Skylight", false);
        BUILDER.pop();
    }
}

